/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.exception.InvalidCurrencyException;
import org.apache.fineract.portfolio.accounts.constants.ShareAccountApiConstants;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeCalculationType;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountCharge;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountChargePaidBy;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountStatusType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountTransaction;
import org.apache.fineract.portfolio.shareaccounts.serialization.ShareAccountDataSerializer;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductRepositoryWrapper;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareAccountDataSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ShareAccountDataSerializer.class);
    private final PlatformSecurityContext platformSecurityContext;
    private final FromJsonHelper fromApiJsonHelper;
    private final ChargeRepositoryWrapper chargeRepository;
    private final SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ShareProductRepositoryWrapper shareProductRepository;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private static final Set<String> approvalParameters = new HashSet<String>(Arrays.asList("locale", "dateFormat", "approvedDate", "note"));
    private static final Set<String> activateParameters = new HashSet<String>(Arrays.asList("locale", "dateFormat", "activatedDate"));
    private static final Set<String> closeParameters = new HashSet<String>(Arrays.asList("locale", "dateFormat", "closedDate", "note"));
    private static final Set<String> addtionalSharesParameters = new HashSet<String>(Arrays.asList("locale", "requestedDate", "requestedShares", "unitPrice", "dateFormat"));

    @Autowired
    public ShareAccountDataSerializer(PlatformSecurityContext platformSecurityContext, FromJsonHelper fromApiJsonHelper, ChargeRepositoryWrapper chargeRepository, SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper, ClientRepositoryWrapper clientRepositoryWrapper, ShareProductRepositoryWrapper shareProductRepository, SavingsAccountReadPlatformService savingsAccountReadPlatformService) {
        this.platformSecurityContext = platformSecurityContext;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.chargeRepository = chargeRepository;
        this.savingsAccountRepositoryWrapper = savingsAccountRepositoryWrapper;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.shareProductRepository = shareProductRepository;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
    }

    public ShareAccount validateAndCreate(JsonCommand jsonCommand) {
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)ShareAccountApiConstants.supportedParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        ShareProduct shareProduct = this.shareProductRepository.findOneWithNotFoundDetection(productId);
        LocalDate submittedDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedDate", element);
        baseDataValidator.reset().parameter("submittedDate").value((Object)submittedDate).notNull();
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        Long savingsAccountId = this.fromApiJsonHelper.extractLongNamed("savingsAccountId", element);
        baseDataValidator.reset().parameter("savingsAccountId").value((Object)savingsAccountId).notNull().longGreaterThanZero();
        Long requestedShares = this.fromApiJsonHelper.extractLongNamed("requestedShares", element);
        baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).notNull().longGreaterThanZero();
        if (shareProduct.getMinimumClientShares() != null && requestedShares < shareProduct.getMinimumClientShares()) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).failWithCode("client.can.not.purchase.shares.lessthan.product.definition", new Object[]{"Client can not purchase shares less than product definition"});
        }
        if (shareProduct.getMaximumClientShares() != null && requestedShares > shareProduct.getMaximumClientShares()) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).failWithCode("client.can.not.purchase.shares.morethan.product.definition", new Object[]{"Client can not purchase shares more than product definition"});
        }
        LocalDate applicationDate = this.fromApiJsonHelper.extractLocalDateNamed("applicationDate", element);
        baseDataValidator.reset().parameter("applicationDate").value((Object)applicationDate).notNull();
        Boolean allowdividendsForInactiveClients = this.fromApiJsonHelper.extractBooleanNamed("allowDividendCalculationForInactiveClients", element);
        Integer minimumActivePeriod = this.fromApiJsonHelper.extractIntegerNamed("minimumActivePeriod", element, locale);
        PeriodFrequencyType minimumActivePeriodEnum = this.extractPeriodType("minimumActivePeriodFrequencyType", element);
        if (minimumActivePeriod != null) {
            baseDataValidator.reset().parameter("minimumActivePeriodFrequencyType").value((Object)minimumActivePeriodEnum.getValue()).integerSameAsNumber(PeriodFrequencyType.DAYS.getValue());
        }
        Integer lockinPeriod = this.fromApiJsonHelper.extractIntegerNamed("lockinPeriodFrequency", element, locale);
        PeriodFrequencyType lockPeriodEnum = this.extractPeriodType("lockinPeriodFrequencyType", element);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        if (!this.savingsAccountReadPlatformService.isAccountBelongsToClient(clientId, savingsAccountId, DepositAccountType.SAVINGS_DEPOSIT, shareProduct.getCurrency().getCode())) {
            throw new SavingsAccountNotFoundException(savingsAccountId);
        }
        SavingsAccount savingsAccount = this.savingsAccountRepositoryWrapper.findOneWithNotFoundDetection(savingsAccountId, DepositAccountType.SAVINGS_DEPOSIT);
        MonetaryCurrency currency = shareProduct.getCurrency();
        Set charges = this.assembleListOfAccountCharges(element, currency.getCode());
        AppUser submittedBy = this.platformSecurityContext.authenticatedUser();
        AppUser approvedBy = null;
        LocalDate approvedDate = null;
        AppUser rejectedBy = null;
        LocalDate rejectedDate = null;
        AppUser activatedBy = null;
        LocalDate activatedDate = null;
        AppUser closedBy = null;
        LocalDate closedDate = null;
        AppUser modifiedBy = null;
        LocalDateTime modifiedDate = null;
        String accountNo = null;
        Long approvedShares = null;
        Long pendingShares = requestedShares;
        BigDecimal unitPrice = shareProduct.deriveMarketPrice(applicationDate);
        ShareAccountTransaction transaction = new ShareAccountTransaction(applicationDate, requestedShares, unitPrice);
        HashSet<ShareAccountTransaction> sharesPurchased = new HashSet<ShareAccountTransaction>();
        sharesPurchased.add(transaction);
        ShareAccount account = new ShareAccount(client, shareProduct, externalId, currency, savingsAccount, accountNo, approvedShares, pendingShares, sharesPurchased, allowdividendsForInactiveClients, lockinPeriod, lockPeriodEnum, minimumActivePeriod, minimumActivePeriodEnum, charges, submittedBy, submittedDate, approvedBy, approvedDate, rejectedBy, rejectedDate, activatedBy, activatedDate, closedBy, closedDate, modifiedBy, modifiedDate);
        for (ShareAccountTransaction pur : sharesPurchased) {
            pur.setShareAccount(account);
        }
        if (charges != null) {
            for (ShareAccountCharge charge : charges) {
                charge.update(account);
            }
        }
        this.createChargeTransaction(account);
        return account;
    }

    private void createChargeTransaction(ShareAccount account) {
        BigDecimal totalChargeAmount = BigDecimal.ZERO;
        Set charges = account.getCharges();
        LocalDate currentDate = DateUtils.getBusinessLocalDate();
        for (ShareAccountCharge charge : charges) {
            if (!charge.isActive() || !charge.isShareAccountActivation()) continue;
            charge.deriveChargeAmount(totalChargeAmount, account.getCurrency());
            ShareAccountTransaction chargeTransaction = ShareAccountTransaction.createChargeTransaction((LocalDate)currentDate, (ShareAccountCharge)charge);
            ShareAccountChargePaidBy paidBy = new ShareAccountChargePaidBy(chargeTransaction, charge, charge.percentageOrAmount());
            chargeTransaction.addShareAccountChargePaidBy(paidBy);
            account.addChargeTransaction(chargeTransaction);
        }
        Set pendingApprovalTransaction = account.getPendingForApprovalSharePurchaseTransactions();
        for (ShareAccountTransaction pending : pendingApprovalTransaction) {
            for (ShareAccountCharge charge : charges) {
                if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
                BigDecimal amount = charge.deriveChargeAmount(pending.amount(), account.getCurrency());
                ShareAccountChargePaidBy paidBy = new ShareAccountChargePaidBy(pending, charge, amount);
                pending.addShareAccountChargePaidBy(paidBy);
                totalChargeAmount = totalChargeAmount.add(amount);
            }
            pending.updateChargeAmount(totalChargeAmount);
        }
    }

    public Map<String, Object> validateAndUpdate(JsonCommand jsonCommand, ShareAccount account) {
        MonetaryCurrency currency;
        Integer minimumActivePeriod;
        PeriodFrequencyType lockPeriod;
        Boolean allowdividendsForInactiveClients;
        String externalId;
        Long productId;
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)ShareAccountApiConstants.supportedParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        ShareProduct shareProduct = account.getShareProduct();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        if (this.fromApiJsonHelper.parameterExists("productId", element) && account.setShareProduct(shareProduct = this.shareProductRepository.findOneWithNotFoundDetection(productId = this.fromApiJsonHelper.extractLongNamed("productId", element)))) {
            actualChanges.put("productId", productId);
        }
        if (this.fromApiJsonHelper.parameterExists("submittedDate", element)) {
            LocalDate submittedDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedDate", element);
            baseDataValidator.reset().parameter("submittedDate").value((Object)submittedDate).notNull();
            if (account.setSubmittedDate(submittedDate)) {
                actualChanges.put("submittedDate", submittedDate);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element) && account.setExternalId(externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element))) {
            actualChanges.put("externalId", externalId);
        }
        if (this.fromApiJsonHelper.parameterExists("savingsAccountId", element)) {
            Long savingsAccountId = this.fromApiJsonHelper.extractLongNamed("savingsAccountId", element);
            baseDataValidator.reset().parameter("savingsAccountId").value((Object)savingsAccountId).notNull().longGreaterThanZero();
            if (savingsAccountId != null) {
                if (!this.savingsAccountReadPlatformService.isAccountBelongsToClient(account.getClientId(), savingsAccountId, DepositAccountType.SAVINGS_DEPOSIT, shareProduct.getCurrency().getCode())) {
                    throw new SavingsAccountNotFoundException(savingsAccountId);
                }
                SavingsAccount savingsAccount = this.savingsAccountRepositoryWrapper.findOneWithNotFoundDetection(savingsAccountId);
                if (account.setSavingsAccount(savingsAccount)) {
                    actualChanges.put("savingsAccountId", savingsAccount.getId());
                }
            }
        }
        LocalDate existingApplicationDate = null;
        ArrayList<Object> purchaseTransactionsList = new ArrayList<Object>();
        Set chargesList = new HashSet<ShareAccountCharge>();
        if (this.fromApiJsonHelper.parameterExists("requestedShares", element) || this.fromApiJsonHelper.parameterExists("charges", element)) {
            Set transactions = account.getShareAccountTransactions();
            ArrayList<Long> reveralIds = new ArrayList<Long>();
            for (Object transaction : transactions) {
                if (!transaction.isActive()) continue;
                reveralIds.add((Long)transaction.getId());
                transaction.setActive(false);
                if (transaction.isChargeTransaction()) continue;
                existingApplicationDate = transaction.getPurchasedDate();
                ShareAccountTransaction newtransaction = new ShareAccountTransaction(transaction.getPurchasedDate(), transaction.getTotalShares(), transaction.getPurchasePrice());
                purchaseTransactionsList.add(newtransaction);
            }
            actualChanges.put("reversalIds", reveralIds);
            Set charges = account.getCharges();
            for (ShareAccountCharge charge : charges) {
                if (!charge.isActive()) continue;
                charge.setActive(false);
                ChargeTimeType chargeTime = null;
                ChargeCalculationType chargeCalculation = null;
                Boolean status = Boolean.TRUE;
                ShareAccountCharge accountCharge = ShareAccountCharge.createNewWithoutShareAccount((Charge)charge.getCharge(), (BigDecimal)charge.percentageOrAmount(), chargeTime, chargeCalculation, (boolean)status);
                chargesList.add(accountCharge);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("requestedShares", element)) {
            Object transaction;
            Long requestedShares = this.fromApiJsonHelper.extractLongNamed("requestedShares", element);
            baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).notNull();
            LocalDate applicationDate = null;
            purchaseTransactionsList.clear();
            if (this.fromApiJsonHelper.parameterExists("applicationDate", element)) {
                applicationDate = this.fromApiJsonHelper.extractLocalDateNamed("applicationDate", element);
                baseDataValidator.reset().parameter("applicationDate").value((Object)applicationDate).notNull();
            } else {
                applicationDate = existingApplicationDate;
            }
            BigDecimal unitPrice = shareProduct.deriveMarketPrice(applicationDate);
            transaction = new ShareAccountTransaction(applicationDate, requestedShares, unitPrice);
            purchaseTransactionsList.add(transaction);
            actualChanges.put("requestedShares", "Transaction");
            if (shareProduct.getMinimumClientShares() != null && requestedShares < shareProduct.getMinimumClientShares()) {
                baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).failWithCode("client.can.not.purchase.shares.lessthan.product.definition", new Object[]{"Client can not purchase shares less than product definition"});
            }
            if (shareProduct.getMaximumClientShares() != null && requestedShares > shareProduct.getMaximumClientShares()) {
                baseDataValidator.reset().parameter("requestedShares").value((Object)requestedShares).failWithCode("client.can.not.purchase.shares.morethan.product.definition", new Object[]{"Client can not purchase shares more than product definition"});
            }
        }
        if (!purchaseTransactionsList.isEmpty()) {
            ShareAccountTransaction transaction = (ShareAccountTransaction)purchaseTransactionsList.get(0);
            account.addTransaction(transaction);
            account.setTotalPendingShares(transaction.getTotalShares());
        }
        if (this.fromApiJsonHelper.parameterExists("allowDividendCalculationForInactiveClients", element) && account.setAllowDividendCalculationForInactiveClients(allowdividendsForInactiveClients = this.fromApiJsonHelper.extractBooleanNamed("allowDividendCalculationForInactiveClients", element))) {
            actualChanges.put("allowDividendCalculationForInactiveClients", allowdividendsForInactiveClients);
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element)) {
            Integer lockinperiod = this.fromApiJsonHelper.extractIntegerNamed("lockinPeriodFrequency", element, locale);
            baseDataValidator.reset().parameter("lockinPeriodFrequency").value((Object)lockinperiod).notNull();
            if (account.setLockPeriod(lockinperiod)) {
                actualChanges.put("lockinPeriodFrequency", lockinperiod);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element) && account.setLockPeriodFrequencyEnum(lockPeriod = this.extractPeriodType("lockinPeriodFrequencyType", element))) {
            actualChanges.put("lockinPeriodFrequencyType", lockPeriod);
        }
        if (this.fromApiJsonHelper.parameterExists("minimumActivePeriod", element)) {
            minimumActivePeriod = this.fromApiJsonHelper.extractIntegerNamed("minimumActivePeriod", element, locale);
            baseDataValidator.reset().parameter("minimumActivePeriod").value((Object)minimumActivePeriod).notNull();
            if (account.setminimumActivePeriod(minimumActivePeriod)) {
                actualChanges.put("minimumActivePeriod", minimumActivePeriod);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("minimumActivePeriodFrequencyType", element) && account.setminimumActivePeriodTypeEnum((PeriodFrequencyType)(minimumActivePeriod = this.extractPeriodType("minimumActivePeriodFrequencyType", element)))) {
            actualChanges.put("minimumActivePeriodFrequencyType", minimumActivePeriod);
        }
        if (this.fromApiJsonHelper.parameterExists("charges", element) && (chargesList = this.assembleListOfAccountCharges(element, (currency = (shareProduct = account.getShareProduct()).getCurrency()).getCode())) != null && !chargesList.isEmpty()) {
            actualChanges.put("charges", new HashSet());
        }
        if (chargesList != null && !chargesList.isEmpty()) {
            for (ShareAccountCharge charge : chargesList) {
                charge.update(account);
            }
            account.addCharges(chargesList);
        }
        this.createChargeTransaction(account);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        return actualChanges;
    }

    public Map<String, Object> validateAndApprove(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)approvalParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        if (!account.status().equals(ShareAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue())) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("is.not.pending.for.approval", new Object[0]);
        }
        LocalDate approvedDate = this.fromApiJsonHelper.extractLocalDateNamed("approvedDate", element);
        LocalDate submittalDate = account.getSubmittedDate();
        if (approvedDate != null && DateUtils.isBefore((LocalDate)approvedDate, (LocalDate)submittalDate)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            String submittalDateAsString = formatter.format(submittalDate);
            baseDataValidator.reset().parameter("approvedDate").value((Object)submittalDateAsString).failWithCodeNoParameterAddedToErrorCode("approved.date.cannot.be.before.submitted.date", new Object[0]);
        }
        Set transactions = account.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            if (!transaction.isActive() || !transaction.isPendingForApprovalTransaction()) continue;
            this.validateTotalSubsribedShares(account, transaction, baseDataValidator);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        AppUser approvedUser = this.platformSecurityContext.authenticatedUser();
        account.approve(approvedDate, approvedUser);
        actualChanges.put("id", account.getId());
        this.updateTotalChargeDerived(account);
        return actualChanges;
    }

    private void validateTotalSubsribedShares(ShareAccount account, ShareAccountTransaction transaction, DataValidatorBuilder baseDataValidator) {
        Long totalSharesIssuable;
        Long totalSubsribedShares = account.getShareProduct().getSubscribedShares();
        Long requested = 0L;
        if (transaction.isActive() && transaction.isPendingForApprovalTransaction()) {
            requested = requested + transaction.getTotalShares();
        }
        if ((totalSharesIssuable = account.getShareProduct().getSharesIssued()) == null) {
            totalSharesIssuable = account.getShareProduct().getTotalShares();
        }
        if (totalSubsribedShares == null) {
            totalSubsribedShares = 0L;
        }
        if (totalSubsribedShares + requested > totalSharesIssuable) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)requested).failWithCodeNoParameterAddedToErrorCode("shares.requested.can.not.be.approved.exceeding.totalshares.issuable", new Object[0]);
        }
    }

    private void updateTotalChargeDerived(ShareAccount shareAccount) {
        Set transactions = shareAccount.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            if (!transaction.isActive()) continue;
            Set paidBySet = transaction.getChargesPaidBy();
            if (paidBySet != null && !paidBySet.isEmpty()) {
                for (ShareAccountChargePaidBy chargePaidBy : paidBySet) {
                    ShareAccountCharge charge = chargePaidBy.getCharge();
                    if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
                    Money money = Money.of((MonetaryCurrency)shareAccount.getCurrency(), (BigDecimal)chargePaidBy.getAmount());
                    charge.updatePaidAmountBy(money);
                }
            }
            if (transaction.isChargeTransaction()) continue;
            transaction.addAmountPaid(transaction.chargeAmount());
        }
    }

    public Map<String, Object> validateAndUndoApprove(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)activateParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        if (!account.status().equals(ShareAccountStatusType.APPROVED.getValue())) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("is.not.in.approved.status", new Object[0]);
        }
        account.undoApprove();
        this.updateTotalChargeDerivedForUndoApproval(account);
        actualChanges.put("charges", Boolean.TRUE);
        return actualChanges;
    }

    private void updateTotalChargeDerivedForUndoApproval(ShareAccount shareAccount) {
        Set purchaseTransactions = shareAccount.getPendingForApprovalSharePurchaseTransactions();
        ShareAccountTransaction purchaseTransaction = null;
        Iterator iterator = purchaseTransactions.iterator();
        while (iterator.hasNext()) {
            ShareAccountTransaction transaction;
            purchaseTransaction = transaction = (ShareAccountTransaction)iterator.next();
        }
        BigDecimal transactionAmount = BigDecimal.ZERO;
        if (purchaseTransaction != null) {
            transactionAmount = purchaseTransaction.amount().subtract(purchaseTransaction.chargeAmount());
        }
        Set charges = shareAccount.getCharges();
        for (ShareAccountCharge charge : charges) {
            if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
            charge.update(transactionAmount, charge.percentageOrAmount());
            charge.deriveChargeAmount(transactionAmount, shareAccount.getCurrency());
        }
        Set transactions = shareAccount.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            if (!transaction.isActive() || transaction.isChargeTransaction()) continue;
            transaction.resetAmountPaid();
        }
    }

    public Map<String, Object> validateAndReject(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        AppUser rejectedUser = this.platformSecurityContext.authenticatedUser();
        LocalDate rejectedDate = DateUtils.getBusinessLocalDate();
        account.reject(rejectedDate, rejectedUser);
        actualChanges.put("charges", Boolean.TRUE);
        return actualChanges;
    }

    public Map<String, Object> validateAndActivate(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)activateParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        if (!account.status().equals(ShareAccountStatusType.APPROVED.getValue())) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("is.not.in.approved.status", new Object[0]);
        }
        LocalDate activatedDate = this.fromApiJsonHelper.extractLocalDateNamed("activatedDate", element);
        baseDataValidator.reset().parameter("activatedDate").value((Object)activatedDate).notNull();
        LocalDate approvedDate = account.getApprovedDate();
        if (activatedDate != null && DateUtils.isBefore((LocalDate)activatedDate, (LocalDate)approvedDate)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            String submittalDateAsString = formatter.format(approvedDate);
            baseDataValidator.reset().parameter("activatedDate").value((Object)submittalDateAsString).failWithCodeNoParameterAddedToErrorCode("cannot.be.before.approved.date", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        AppUser approvedUser = this.platformSecurityContext.authenticatedUser();
        account.activate(activatedDate, approvedUser);
        this.handlechargesOnActivation(account);
        actualChanges.put("charges", activatedDate);
        return actualChanges;
    }

    private void handlechargesOnActivation(ShareAccount account) {
        Set charges = account.getCharges();
        for (ShareAccountCharge charge : charges) {
            if (!charge.isActive() || !charge.isShareAccountActivation()) continue;
            charge.markAsFullyPaid();
        }
        Set transactions = account.getChargeTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            if (!transaction.isChargeTransaction()) continue;
            transaction.updateTransactionDate(account.getActivatedDate());
            transaction.updateAmountPaid(transaction.amount());
        }
    }

    private Set<ShareAccountCharge> assembleListOfAccountCharges(JsonElement element, String currencyCode) {
        JsonArray chargesArray;
        HashSet<ShareAccountCharge> charges = new HashSet<ShareAccountCharge>();
        if (this.fromApiJsonHelper.parameterExists("charges", element) && (chargesArray = this.fromApiJsonHelper.extractJsonArrayNamed("charges", element)) != null) {
            for (int i = 0; i < chargesArray.size(); ++i) {
                JsonObject jsonObject = chargesArray.get(i).getAsJsonObject();
                if (!jsonObject.has("chargeId")) continue;
                Long id = jsonObject.get("chargeId").getAsLong();
                BigDecimal amount = jsonObject.get("amount").getAsBigDecimal();
                Charge charge = this.chargeRepository.findOneWithNotFoundDetection(id);
                if (!currencyCode.equals(charge.getCurrencyCode())) {
                    String errorMessage = "Charge and Share Account must have the same currency.";
                    throw new InvalidCurrencyException("charge", "attach.to.share.account", "Charge and Share Account must have the same currency.", new Object[0]);
                }
                ChargeTimeType chargeTime = null;
                ChargeCalculationType chargeCalculation = null;
                Boolean status = Boolean.TRUE;
                ShareAccountCharge accountCharge = ShareAccountCharge.createNewWithoutShareAccount((Charge)charge, (BigDecimal)amount, chargeTime, chargeCalculation, (boolean)status);
                charges.add(accountCharge);
            }
        }
        return charges;
    }

    private PeriodFrequencyType extractPeriodType(String paramName, JsonElement element) {
        PeriodFrequencyType frequencyType = PeriodFrequencyType.INVALID;
        frequencyType = PeriodFrequencyType.fromInt((Integer)this.fromApiJsonHelper.extractIntegerWithLocaleNamed(paramName, element));
        return frequencyType;
    }

    public Map<String, Object> validateAndApplyAddtionalShares(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)addtionalSharesParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        if (!account.status().equals(ShareAccountStatusType.ACTIVE.getValue())) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("is.not.in.active.state", new Object[0]);
        }
        LocalDate requestedDate = this.fromApiJsonHelper.extractLocalDateNamed("requestedDate", element);
        baseDataValidator.reset().parameter("requestedDate").value((Object)requestedDate).notNull();
        Long sharesRequested = this.fromApiJsonHelper.extractLongNamed("requestedShares", element);
        baseDataValidator.reset().parameter("requestedShares").value((Object)sharesRequested).notNull();
        ShareProduct shareProduct = account.getShareProduct();
        if (sharesRequested != null) {
            Long totalSharesAfterapproval = account.getTotalApprovedShares() + sharesRequested;
            if (shareProduct.getMaximumClientShares() != null && totalSharesAfterapproval > shareProduct.getMaximumClientShares()) {
                baseDataValidator.reset().parameter("requestedShares").value((Object)sharesRequested).failWithCode("exceeding.maximum.limit.defined.in.the.shareproduct", new Object[]{"Existing and requested shares count is more than product definition"});
            }
        }
        boolean isTransactionBeforeExistingTransactions = false;
        Set transactions = account.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            LocalDate transactionDate;
            if (transaction.isChargeTransaction() || !DateUtils.isBefore((LocalDate)requestedDate, (LocalDate)(transactionDate = transaction.getPurchasedDate()))) continue;
            isTransactionBeforeExistingTransactions = true;
            break;
        }
        if (isTransactionBeforeExistingTransactions) {
            baseDataValidator.reset().parameter("requestedDate").value((Object)requestedDate).failWithCodeNoParameterAddedToErrorCode("purchase.transaction.date.cannot.be.before.existing.transactions", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        BigDecimal unitPrice = shareProduct.deriveMarketPrice(requestedDate);
        ShareAccountTransaction purchaseTransaction = new ShareAccountTransaction(requestedDate, sharesRequested, unitPrice);
        account.addAdditionalPurchasedShares(purchaseTransaction);
        this.handleAdditionalSharesChargeTransactions(account, purchaseTransaction);
        actualChanges.put("additionalshares", purchaseTransaction);
        return actualChanges;
    }

    private void handleAdditionalSharesChargeTransactions(ShareAccount account, ShareAccountTransaction purchaseTransaction) {
        Set charges = account.getCharges();
        BigDecimal totalChargeAmount = BigDecimal.ZERO;
        for (ShareAccountCharge charge : charges) {
            if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
            BigDecimal amount = charge.updateChargeDetailsForAdditionalSharesRequest(purchaseTransaction.amount(), account.getCurrency());
            ShareAccountChargePaidBy paidBy = new ShareAccountChargePaidBy(purchaseTransaction, charge, amount);
            purchaseTransaction.addShareAccountChargePaidBy(paidBy);
            totalChargeAmount = totalChargeAmount.add(amount);
        }
        purchaseTransaction.updateChargeAmount(totalChargeAmount);
    }

    public Map<String, Object> validateAndApproveAddtionalShares(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)addtionalSharesParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        ArrayList<Long> purchasedShares = new ArrayList<Long>();
        if (this.fromApiJsonHelper.parameterExists("requestedShares", element)) {
            JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("requestedShares", element);
            long totalShares = 0L;
            for (JsonElement arrayElement : array) {
                Long purchasedSharesId = this.fromApiJsonHelper.extractLongNamed("id", arrayElement);
                baseDataValidator.reset().parameter("requestedShares").value((Object)purchasedSharesId).notBlank();
                ShareAccountTransaction transaction = account.retrievePurchasedShares(purchasedSharesId);
                if (transaction != null) {
                    this.validateTotalSubsribedShares(account, transaction, baseDataValidator);
                    totalShares += transaction.getTotalShares().longValue();
                    transaction.approve();
                    this.updateTotalChargeDerivedForAdditonalShares(account, transaction);
                }
                purchasedShares.add(purchasedSharesId);
            }
            if (totalShares > 0L) {
                account.updateApprovedShares(Long.valueOf(totalShares));
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        actualChanges.put("requestedShares", purchasedShares);
        return actualChanges;
    }

    private void updateTotalChargeDerivedForAdditonalShares(ShareAccount shareAccount, ShareAccountTransaction transaction) {
        Set paidBySet = transaction.getChargesPaidBy();
        if (paidBySet != null && !paidBySet.isEmpty()) {
            for (ShareAccountChargePaidBy chargePaidBy : paidBySet) {
                ShareAccountCharge charge = chargePaidBy.getCharge();
                if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
                Money money = Money.of((MonetaryCurrency)shareAccount.getCurrency(), (BigDecimal)chargePaidBy.getAmount());
                charge.updatePaidAmountBy(money);
            }
            if (!transaction.isChargeTransaction()) {
                transaction.addAmountPaid(transaction.chargeAmount());
            }
        }
    }

    public Map<String, Object> validateAndRejectAddtionalShares(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)addtionalSharesParameters);
        JsonElement element = jsonCommand.parsedJson();
        ArrayList<Long> purchasedShares = new ArrayList<Long>();
        if (this.fromApiJsonHelper.parameterExists("requestedShares", element)) {
            long totalShares = 0L;
            JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("requestedShares", element);
            for (JsonElement arrayElement : array) {
                Long purchasedSharesId = this.fromApiJsonHelper.extractLongNamed("id", arrayElement);
                ShareAccountTransaction shares = account.retrievePurchasedShares(purchasedSharesId);
                if (shares != null) {
                    shares.reject();
                    this.updateTotalChargeDerivedForAdditonalSharesReject(account, shares);
                    totalShares += shares.getTotalShares().longValue();
                }
                purchasedShares.add(purchasedSharesId);
            }
            if (totalShares > 0L) {
                account.removePendingShares(Long.valueOf(totalShares));
            }
        }
        actualChanges.put("requestedShares", purchasedShares);
        return actualChanges;
    }

    private void updateTotalChargeDerivedForAdditonalSharesReject(ShareAccount shareAccount, ShareAccountTransaction transaction) {
        Set paidBySet = transaction.getChargesPaidBy();
        if (paidBySet != null && !paidBySet.isEmpty()) {
            for (ShareAccountChargePaidBy chargePaidBy : paidBySet) {
                ShareAccountCharge charge = chargePaidBy.getCharge();
                if (!charge.isActive() || !charge.isSharesPurchaseCharge()) continue;
                Money money = Money.of((MonetaryCurrency)shareAccount.getCurrency(), (BigDecimal)chargePaidBy.getAmount());
                charge.updatePaidAmountBy(money);
            }
            if (!transaction.isChargeTransaction()) {
                transaction.addAmountPaid(transaction.chargeAmount());
            }
        }
    }

    public Map<String, Object> validateAndRedeemShares(JsonCommand jsonCommand, ShareAccount account) {
        ShareAccountTransaction transaction2;
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)addtionalSharesParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        LocalDate requestedDate = this.fromApiJsonHelper.extractLocalDateNamed("requestedDate", element);
        baseDataValidator.reset().parameter("requestedDate").value((Object)requestedDate).notNull();
        Long sharesRequested = this.fromApiJsonHelper.extractLongNamed("requestedShares", element);
        baseDataValidator.reset().parameter("requestedShares").value((Object)sharesRequested).notNull().longGreaterThanZero();
        boolean isTransactionBeforeExistingTransactions = false;
        Set transactions = account.getShareAccountTransactions();
        for (ShareAccountTransaction transaction2 : transactions) {
            LocalDate transactionDate;
            if (transaction2.isChargeTransaction() || !transaction2.isActive() || !DateUtils.isBefore((LocalDate)requestedDate, (LocalDate)(transactionDate = transaction2.getPurchasedDate()))) continue;
            isTransactionBeforeExistingTransactions = true;
            break;
        }
        if (isTransactionBeforeExistingTransactions) {
            baseDataValidator.reset().parameter("requestedDate").value((Object)requestedDate).failWithCodeNoParameterAddedToErrorCode("redeem.transaction.date.cannot.be.before.existing.transactions", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        BigDecimal unitPrice = account.getShareProduct().deriveMarketPrice(requestedDate);
        transaction2 = ShareAccountTransaction.createRedeemTransaction((LocalDate)requestedDate, (Long)sharesRequested, (BigDecimal)unitPrice);
        this.validateRedeemRequest(account, transaction2, baseDataValidator, dataValidationErrors);
        account.addAdditionalPurchasedShares(transaction2);
        actualChanges.put("requestedShares", transaction2);
        this.handleRedeemSharesChargeTransactions(account, transaction2);
        return actualChanges;
    }

    private void validateRedeemRequest(ShareAccount account, ShareAccountTransaction redeemTransaction, DataValidatorBuilder baseDataValidator, List<ApiParameterError> dataValidationErrors) {
        if (account.getTotalApprovedShares() < redeemTransaction.getTotalShares()) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)redeemTransaction.getTotalShares()).failWithCodeNoParameterAddedToErrorCode("cannot.be.redeemed.due.to.insufficient.shares", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        LocalDate redeemDate = redeemTransaction.getPurchasedDate();
        Integer lockinPeriod = account.getLockinPeriodFrequency();
        PeriodFrequencyType periodType = account.getLockinPeriodFrequencyType();
        if (lockinPeriod == null && periodType == null) {
            return;
        }
        Long totalSharesCanBeRedeemed = 0L;
        Long totalSharesPurchasedBeforeRedeem = 0L;
        boolean isPurchaseTransactionExist = false;
        Set transactions = account.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            if (!transaction.isActive() || transaction.isChargeTransaction()) continue;
            LocalDate purchaseDate = transaction.getPurchasedDate();
            LocalDate lockinDate = this.deriveLockinPeriodDuration(lockinPeriod, periodType, purchaseDate);
            if (!DateUtils.isAfter((LocalDate)lockinDate, (LocalDate)redeemDate)) {
                if (transaction.isPurchasTransaction()) {
                    totalSharesCanBeRedeemed = totalSharesCanBeRedeemed + transaction.getTotalShares();
                } else if (transaction.isRedeemTransaction()) {
                    totalSharesCanBeRedeemed = totalSharesCanBeRedeemed - transaction.getTotalShares();
                }
            }
            if (DateUtils.isAfter((LocalDate)purchaseDate, (LocalDate)redeemDate)) continue;
            isPurchaseTransactionExist = true;
            if (transaction.isPurchasTransaction()) {
                totalSharesPurchasedBeforeRedeem = totalSharesPurchasedBeforeRedeem + transaction.getTotalShares();
                continue;
            }
            if (!transaction.isRedeemTransaction()) continue;
            totalSharesPurchasedBeforeRedeem = totalSharesPurchasedBeforeRedeem - transaction.getTotalShares();
        }
        if (!isPurchaseTransactionExist) {
            baseDataValidator.reset().parameter("requestedDate").value((Object)redeemDate).failWithCodeNoParameterAddedToErrorCode("no.purchase.transaction.found.before.redeem.date", new Object[0]);
        } else if (totalSharesPurchasedBeforeRedeem < redeemTransaction.getTotalShares()) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)redeemTransaction.getTotalShares()).failWithCodeNoParameterAddedToErrorCode("cannot.be.redeemed.due.to.insufficient.shares.for.this.redeem.date", new Object[0]);
        } else if (totalSharesCanBeRedeemed < redeemTransaction.getTotalShares()) {
            baseDataValidator.reset().parameter("requestedShares").value((Object)redeemTransaction.getTotalShares()).failWithCodeNoParameterAddedToErrorCode("cannot.be.redeemed.due.to.lockinperiod", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private LocalDate deriveLockinPeriodDuration(Integer lockinPeriod, PeriodFrequencyType periodType, LocalDate purchaseDate) {
        LocalDate lockinDate = purchaseDate;
        if (periodType != null) {
            switch (11.$SwitchMap$org$apache$fineract$portfolio$common$domain$PeriodFrequencyType[periodType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    lockinDate = purchaseDate.plusDays(lockinPeriod.intValue());
                    break;
                }
                case 3: {
                    lockinDate = purchaseDate.plusWeeks(lockinPeriod.intValue());
                    break;
                }
                case 4: {
                    lockinDate = purchaseDate.plusMonths(lockinPeriod.intValue());
                    break;
                }
                case 5: {
                    lockinDate = purchaseDate.plusYears(lockinPeriod.intValue());
                    break;
                }
            }
        }
        return lockinDate;
    }

    private void handleRedeemSharesChargeTransactions(ShareAccount account, ShareAccountTransaction transaction) {
        Set charges = account.getCharges();
        BigDecimal totalChargeAmount = BigDecimal.ZERO;
        for (ShareAccountCharge charge : charges) {
            if (!charge.isActive() || !charge.isSharesRedeemCharge()) continue;
            BigDecimal amount = charge.updateChargeDetailsForAdditionalSharesRequest(transaction.amount(), account.getCurrency());
            ShareAccountChargePaidBy paidBy = new ShareAccountChargePaidBy(transaction, charge, amount);
            transaction.addShareAccountChargePaidBy(paidBy);
            totalChargeAmount = totalChargeAmount.add(amount);
        }
        transaction.deductChargesFromTotalAmount(totalChargeAmount);
        Set paidBySet = transaction.getChargesPaidBy();
        if (paidBySet != null && !paidBySet.isEmpty()) {
            for (ShareAccountChargePaidBy chargePaidBy : paidBySet) {
                ShareAccountCharge charge = chargePaidBy.getCharge();
                if (!charge.isActive() || !charge.isSharesRedeemCharge()) continue;
                Money money = Money.of((MonetaryCurrency)account.getCurrency(), (BigDecimal)chargePaidBy.getAmount());
                charge.updatePaidAmountBy(money);
            }
        }
        transaction.addAmountPaid(transaction.chargeAmount());
    }

    public Map<String, Object> validateAndClose(JsonCommand jsonCommand, ShareAccount account) {
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)closeParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesaccount");
        JsonElement element = jsonCommand.parsedJson();
        LocalDate closedDate = this.fromApiJsonHelper.extractLocalDateNamed("closedDate", element);
        baseDataValidator.reset().parameter("approvedDate").value((Object)closedDate).notNull();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        boolean isTransactionBeforeExistingTransactions = false;
        Set transactions = account.getShareAccountTransactions();
        for (ShareAccountTransaction transaction : transactions) {
            LocalDate transactionDate;
            if (transaction.isChargeTransaction() || !DateUtils.isBefore((LocalDate)closedDate, (LocalDate)(transactionDate = transaction.getPurchasedDate()))) continue;
            isTransactionBeforeExistingTransactions = true;
            break;
        }
        if (isTransactionBeforeExistingTransactions) {
            baseDataValidator.reset().parameter("closedDate").value((Object)closedDate).failWithCodeNoParameterAddedToErrorCode("share.account.cannot.be.closed.before.existing.transactions", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        AppUser approvedUser = this.platformSecurityContext.authenticatedUser();
        BigDecimal unitPrice = account.getShareProduct().deriveMarketPrice(DateUtils.getBusinessLocalDate());
        ShareAccountTransaction transaction = ShareAccountTransaction.createRedeemTransaction((LocalDate)closedDate, (Long)account.getTotalApprovedShares(), (BigDecimal)unitPrice);
        account.addAdditionalPurchasedShares(transaction);
        account.close(closedDate, approvedUser);
        this.handleRedeemSharesChargeTransactions(account, transaction);
        actualChanges.put("requestedShares", transaction);
        return actualChanges;
    }
}

