/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GetCodeValuesDataResponse;
import org.apache.fineract.client.models.GetLoanProductsAccountingMappingOptions;
import org.apache.fineract.client.models.GetLoanProductsAccountingRule;
import org.apache.fineract.client.models.GetLoanProductsAmortizationType;
import org.apache.fineract.client.models.GetLoanProductsChargeOffReasonOptions;
import org.apache.fineract.client.models.GetLoanProductsChargeOptions;
import org.apache.fineract.client.models.GetLoanProductsCurrencyOptions;
import org.apache.fineract.client.models.GetLoanProductsDaysInMonthType;
import org.apache.fineract.client.models.GetLoanProductsDaysInYearType;
import org.apache.fineract.client.models.GetLoanProductsInterestRateTemplateFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsInterestRecalculationCompoundingFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsInterestRecalculationCompoundingType;
import org.apache.fineract.client.models.GetLoanProductsInterestRecalculationTemplateData;
import org.apache.fineract.client.models.GetLoanProductsInterestTemplateType;
import org.apache.fineract.client.models.GetLoanProductsPaymentTypeOptions;
import org.apache.fineract.client.models.GetLoanProductsPreClosureInterestCalculationStrategy;
import org.apache.fineract.client.models.GetLoanProductsRepaymentStartDateType;
import org.apache.fineract.client.models.GetLoanProductsRepaymentTemplateFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsRescheduleStrategyType;
import org.apache.fineract.client.models.GetLoanProductsTemplateCurrency;
import org.apache.fineract.client.models.GetLoanProductsTransactionProcessingStrategyOptions;
import org.apache.fineract.client.models.GetLoanProductsValueConditionTypeOptions;
import org.apache.fineract.client.models.GetLoanProductsWriteOffReasonOptions;
import org.apache.fineract.client.models.GetLoansProductsInterestCalculationPeriodType;
import org.apache.fineract.client.models.StringEnumOptionData;

/**
 * GetLoanProductsTemplateResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoanProductsTemplateResponse {
  public static final String SERIALIZED_NAME_ACCOUNTING_MAPPING_OPTIONS = "accountingMappingOptions";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_MAPPING_OPTIONS)
  private GetLoanProductsAccountingMappingOptions accountingMappingOptions;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private GetLoanProductsAccountingRule accountingRule;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE_OPTIONS = "accountingRuleOptions";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE_OPTIONS)
  private Set<GetLoanProductsAccountingRule> accountingRuleOptions;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_FUTURE_INSTALLMENT_ALLOCATION_RULES = "advancedPaymentAllocationFutureInstallmentAllocationRules";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_FUTURE_INSTALLMENT_ALLOCATION_RULES)
  private List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TRANSACTION_TYPES = "advancedPaymentAllocationTransactionTypes";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TRANSACTION_TYPES)
  private List<EnumOptionData> advancedPaymentAllocationTransactionTypes;

  public static final String SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TYPES = "advancedPaymentAllocationTypes";
  @SerializedName(SERIALIZED_NAME_ADVANCED_PAYMENT_ALLOCATION_TYPES)
  private List<EnumOptionData> advancedPaymentAllocationTypes;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private GetLoanProductsAmortizationType amortizationType;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE_OPTIONS = "amortizationTypeOptions";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE_OPTIONS)
  private Set<GetLoanProductsAmortizationType> amortizationTypeOptions;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private StringEnumOptionData buyDownFeeCalculationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE_OPTIONS = "buyDownFeeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private StringEnumOptionData buyDownFeeIncomeType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE_OPTIONS = "buyDownFeeIncomeTypeOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeIncomeTypeOptions;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private StringEnumOptionData buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY_OPTIONS = "buyDownFeeStrategyOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeStrategyOptions;

  public static final String SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_OPTIONS = "buydownFeeClassificationOptions";
  @SerializedName(SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_OPTIONS)
  private List<GetCodeValuesDataResponse> buydownFeeClassificationOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private StringEnumOptionData capitalizedIncomeCalculationType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE_OPTIONS = "capitalizedIncomeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_OPTIONS = "capitalizedIncomeClassificationOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_OPTIONS)
  private List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private StringEnumOptionData capitalizedIncomeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY_OPTIONS = "capitalizedIncomeStrategyOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeStrategyOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private StringEnumOptionData capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE_OPTIONS = "capitalizedIncomeTypeOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeTypeOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private StringEnumOptionData chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR_OPTIONS = "chargeOffBehaviourOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR_OPTIONS)
  private List<StringEnumOptionData> chargeOffBehaviourOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS = "chargeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS)
  private List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions;

  public static final String SERIALIZED_NAME_CHARGE_OPTIONS = "chargeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OPTIONS)
  private Set<GetLoanProductsChargeOptions> chargeOptions;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION_ALLOCATION_TYPES = "creditAllocationAllocationTypes";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION_ALLOCATION_TYPES)
  private List<EnumOptionData> creditAllocationAllocationTypes;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION_TRANSACTION_TYPES = "creditAllocationTransactionTypes";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION_TRANSACTION_TYPES)
  private List<EnumOptionData> creditAllocationTransactionTypes;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoanProductsTemplateCurrency currency;

  public static final String SERIALIZED_NAME_CURRENCY_OPTIONS = "currencyOptions";
  @SerializedName(SERIALIZED_NAME_CURRENCY_OPTIONS)
  private Set<GetLoanProductsCurrencyOptions> currencyOptions;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private GetLoanProductsDaysInMonthType daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE_OPTIONS = "daysInMonthTypeOptions";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE_OPTIONS)
  private Set<StringEnumOptionData> daysInMonthTypeOptions;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private StringEnumOptionData daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private GetLoanProductsDaysInYearType daysInYearType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_CUSTOM_STRATEGY_OPTIONS = "daysInYearTypeCustomStrategyOptions";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_CUSTOM_STRATEGY_OPTIONS)
  private Set<StringEnumOptionData> daysInYearTypeCustomStrategyOptions;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_OPTIONS = "daysInYearTypeOptions";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE_OPTIONS)
  private Set<GetLoanProductsInterestTemplateType> daysInYearTypeOptions;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE_OPTIONS = "interestCalculationPeriodTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE_OPTIONS)
  private Set<GetLoansProductsInterestCalculationPeriodType> interestCalculationPeriodTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private GetLoanProductsInterestRateTemplateFrequencyType interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE_OPTIONS = "interestRateFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE_OPTIONS)
  private Set<GetLoanProductsInterestRateTemplateFrequencyType> interestRateFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_TYPE_OPTIONS = "interestRecalculationCompoundingTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_COMPOUNDING_TYPE_OPTIONS)
  private Set<GetLoanProductsInterestRecalculationCompoundingType> interestRecalculationCompoundingTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_DATA = "interestRecalculationData";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_DATA)
  private GetLoanProductsInterestRecalculationTemplateData interestRecalculationData;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_FREQUENCY_TYPE_OPTIONS = "interestRecalculationFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_FREQUENCY_TYPE_OPTIONS)
  private Set<GetLoanProductsInterestRecalculationCompoundingFrequencyType> interestRecalculationFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private GetLoanProductsInterestTemplateType interestType;

  public static final String SERIALIZED_NAME_INTEREST_TYPE_OPTIONS = "interestTypeOptions";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE_OPTIONS)
  private Set<GetLoanProductsInterestTemplateType> interestTypeOptions;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE_OPTIONS = "loanScheduleProcessingTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE_OPTIONS)
  private List<EnumOptionData> loanScheduleProcessingTypeOptions;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE_OPTIONS = "loanScheduleTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE_OPTIONS)
  private List<EnumOptionData> loanScheduleTypeOptions;

  public static final String SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE = "merchantBuyDownFee";
  @SerializedName(SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE)
  private Boolean merchantBuyDownFee;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS = "paymentTypeOptions";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS)
  private Set<GetLoanProductsPaymentTypeOptions> paymentTypeOptions;

  public static final String SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY_OPTIONS = "preClosureInterestCalculationStrategyOptions";
  @SerializedName(SERIALIZED_NAME_PRE_CLOSURE_INTEREST_CALCULATION_STRATEGY_OPTIONS)
  private Set<GetLoanProductsPreClosureInterestCalculationStrategy> preClosureInterestCalculationStrategyOptions;

  public static final String SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "principalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> principalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private GetLoanProductsRepaymentTemplateFrequencyType repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE_OPTIONS = "repaymentFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE_OPTIONS)
  private Set<GetLoanProductsRepaymentTemplateFrequencyType> repaymentFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE_OPTIONS = "repaymentStartDateTypeOptions";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE_OPTIONS)
  private Set<GetLoanProductsRepaymentStartDateType> repaymentStartDateTypeOptions;

  public static final String SERIALIZED_NAME_RESCHEDULE_STRATEGY_TYPE_OPTIONS = "rescheduleStrategyTypeOptions";
  @SerializedName(SERIALIZED_NAME_RESCHEDULE_STRATEGY_TYPE_OPTIONS)
  private Set<GetLoanProductsRescheduleStrategyType> rescheduleStrategyTypeOptions;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<StringEnumOptionData> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES_OPTIONS = "supportedInterestRefundTypesOptions";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES_OPTIONS)
  private List<StringEnumOptionData> supportedInterestRefundTypesOptions;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_OPTIONS = "transactionProcessingStrategyOptions";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_OPTIONS)
  private Set<GetLoanProductsTransactionProcessingStrategyOptions> transactionProcessingStrategyOptions;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_VALUE_CONDITION_TYPE_OPTIONS = "valueConditionTypeOptions";
  @SerializedName(SERIALIZED_NAME_VALUE_CONDITION_TYPE_OPTIONS)
  private Set<GetLoanProductsValueConditionTypeOptions> valueConditionTypeOptions;

  public static final String SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS = "writeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS)
  private List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions;

  public GetLoanProductsTemplateResponse() {
  }

  public GetLoanProductsTemplateResponse accountingMappingOptions(GetLoanProductsAccountingMappingOptions accountingMappingOptions) {
    
    this.accountingMappingOptions = accountingMappingOptions;
    return this;
  }

  /**
   * Get accountingMappingOptions
   * @return accountingMappingOptions
   */
  @javax.annotation.Nullable

  public GetLoanProductsAccountingMappingOptions getAccountingMappingOptions() {
    return accountingMappingOptions;
  }


  public void setAccountingMappingOptions(GetLoanProductsAccountingMappingOptions accountingMappingOptions) {
    this.accountingMappingOptions = accountingMappingOptions;
  }

  public GetLoanProductsTemplateResponse accountingRule(GetLoanProductsAccountingRule accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public GetLoanProductsAccountingRule getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(GetLoanProductsAccountingRule accountingRule) {
    this.accountingRule = accountingRule;
  }

  public GetLoanProductsTemplateResponse accountingRuleOptions(Set<GetLoanProductsAccountingRule> accountingRuleOptions) {
    
    this.accountingRuleOptions = accountingRuleOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addAccountingRuleOptionsItem(GetLoanProductsAccountingRule accountingRuleOptionsItem) {
    if (this.accountingRuleOptions == null) {
      this.accountingRuleOptions = new LinkedHashSet<>();
    }
    this.accountingRuleOptions.add(accountingRuleOptionsItem);
    return this;
  }

  /**
   * Get accountingRuleOptions
   * @return accountingRuleOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsAccountingRule> getAccountingRuleOptions() {
    return accountingRuleOptions;
  }


  public void setAccountingRuleOptions(Set<GetLoanProductsAccountingRule> accountingRuleOptions) {
    this.accountingRuleOptions = accountingRuleOptions;
  }

  public GetLoanProductsTemplateResponse advancedPaymentAllocationFutureInstallmentAllocationRules(List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules) {
    
    this.advancedPaymentAllocationFutureInstallmentAllocationRules = advancedPaymentAllocationFutureInstallmentAllocationRules;
    return this;
  }

  public GetLoanProductsTemplateResponse addAdvancedPaymentAllocationFutureInstallmentAllocationRulesItem(EnumOptionData advancedPaymentAllocationFutureInstallmentAllocationRulesItem) {
    if (this.advancedPaymentAllocationFutureInstallmentAllocationRules == null) {
      this.advancedPaymentAllocationFutureInstallmentAllocationRules = new ArrayList<>();
    }
    this.advancedPaymentAllocationFutureInstallmentAllocationRules.add(advancedPaymentAllocationFutureInstallmentAllocationRulesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationFutureInstallmentAllocationRules
   * @return advancedPaymentAllocationFutureInstallmentAllocationRules
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationFutureInstallmentAllocationRules() {
    return advancedPaymentAllocationFutureInstallmentAllocationRules;
  }


  public void setAdvancedPaymentAllocationFutureInstallmentAllocationRules(List<EnumOptionData> advancedPaymentAllocationFutureInstallmentAllocationRules) {
    this.advancedPaymentAllocationFutureInstallmentAllocationRules = advancedPaymentAllocationFutureInstallmentAllocationRules;
  }

  public GetLoanProductsTemplateResponse advancedPaymentAllocationTransactionTypes(List<EnumOptionData> advancedPaymentAllocationTransactionTypes) {
    
    this.advancedPaymentAllocationTransactionTypes = advancedPaymentAllocationTransactionTypes;
    return this;
  }

  public GetLoanProductsTemplateResponse addAdvancedPaymentAllocationTransactionTypesItem(EnumOptionData advancedPaymentAllocationTransactionTypesItem) {
    if (this.advancedPaymentAllocationTransactionTypes == null) {
      this.advancedPaymentAllocationTransactionTypes = new ArrayList<>();
    }
    this.advancedPaymentAllocationTransactionTypes.add(advancedPaymentAllocationTransactionTypesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationTransactionTypes
   * @return advancedPaymentAllocationTransactionTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationTransactionTypes() {
    return advancedPaymentAllocationTransactionTypes;
  }


  public void setAdvancedPaymentAllocationTransactionTypes(List<EnumOptionData> advancedPaymentAllocationTransactionTypes) {
    this.advancedPaymentAllocationTransactionTypes = advancedPaymentAllocationTransactionTypes;
  }

  public GetLoanProductsTemplateResponse advancedPaymentAllocationTypes(List<EnumOptionData> advancedPaymentAllocationTypes) {
    
    this.advancedPaymentAllocationTypes = advancedPaymentAllocationTypes;
    return this;
  }

  public GetLoanProductsTemplateResponse addAdvancedPaymentAllocationTypesItem(EnumOptionData advancedPaymentAllocationTypesItem) {
    if (this.advancedPaymentAllocationTypes == null) {
      this.advancedPaymentAllocationTypes = new ArrayList<>();
    }
    this.advancedPaymentAllocationTypes.add(advancedPaymentAllocationTypesItem);
    return this;
  }

  /**
   * Get advancedPaymentAllocationTypes
   * @return advancedPaymentAllocationTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getAdvancedPaymentAllocationTypes() {
    return advancedPaymentAllocationTypes;
  }


  public void setAdvancedPaymentAllocationTypes(List<EnumOptionData> advancedPaymentAllocationTypes) {
    this.advancedPaymentAllocationTypes = advancedPaymentAllocationTypes;
  }

  public GetLoanProductsTemplateResponse amortizationType(GetLoanProductsAmortizationType amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public GetLoanProductsAmortizationType getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(GetLoanProductsAmortizationType amortizationType) {
    this.amortizationType = amortizationType;
  }

  public GetLoanProductsTemplateResponse amortizationTypeOptions(Set<GetLoanProductsAmortizationType> amortizationTypeOptions) {
    
    this.amortizationTypeOptions = amortizationTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addAmortizationTypeOptionsItem(GetLoanProductsAmortizationType amortizationTypeOptionsItem) {
    if (this.amortizationTypeOptions == null) {
      this.amortizationTypeOptions = new LinkedHashSet<>();
    }
    this.amortizationTypeOptions.add(amortizationTypeOptionsItem);
    return this;
  }

  /**
   * Get amortizationTypeOptions
   * @return amortizationTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsAmortizationType> getAmortizationTypeOptions() {
    return amortizationTypeOptions;
  }


  public void setAmortizationTypeOptions(Set<GetLoanProductsAmortizationType> amortizationTypeOptions) {
    this.amortizationTypeOptions = amortizationTypeOptions;
  }

  public GetLoanProductsTemplateResponse buyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public GetLoanProductsTemplateResponse buyDownFeeCalculationTypeOptions(List<StringEnumOptionData> buyDownFeeCalculationTypeOptions) {
    
    this.buyDownFeeCalculationTypeOptions = buyDownFeeCalculationTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addBuyDownFeeCalculationTypeOptionsItem(StringEnumOptionData buyDownFeeCalculationTypeOptionsItem) {
    if (this.buyDownFeeCalculationTypeOptions == null) {
      this.buyDownFeeCalculationTypeOptions = new ArrayList<>();
    }
    this.buyDownFeeCalculationTypeOptions.add(buyDownFeeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeCalculationTypeOptions
   * @return buyDownFeeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeCalculationTypeOptions() {
    return buyDownFeeCalculationTypeOptions;
  }


  public void setBuyDownFeeCalculationTypeOptions(List<StringEnumOptionData> buyDownFeeCalculationTypeOptions) {
    this.buyDownFeeCalculationTypeOptions = buyDownFeeCalculationTypeOptions;
  }

  public GetLoanProductsTemplateResponse buyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public GetLoanProductsTemplateResponse buyDownFeeIncomeTypeOptions(List<StringEnumOptionData> buyDownFeeIncomeTypeOptions) {
    
    this.buyDownFeeIncomeTypeOptions = buyDownFeeIncomeTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addBuyDownFeeIncomeTypeOptionsItem(StringEnumOptionData buyDownFeeIncomeTypeOptionsItem) {
    if (this.buyDownFeeIncomeTypeOptions == null) {
      this.buyDownFeeIncomeTypeOptions = new ArrayList<>();
    }
    this.buyDownFeeIncomeTypeOptions.add(buyDownFeeIncomeTypeOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeIncomeTypeOptions
   * @return buyDownFeeIncomeTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeIncomeTypeOptions() {
    return buyDownFeeIncomeTypeOptions;
  }


  public void setBuyDownFeeIncomeTypeOptions(List<StringEnumOptionData> buyDownFeeIncomeTypeOptions) {
    this.buyDownFeeIncomeTypeOptions = buyDownFeeIncomeTypeOptions;
  }

  public GetLoanProductsTemplateResponse buyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public GetLoanProductsTemplateResponse buyDownFeeStrategyOptions(List<StringEnumOptionData> buyDownFeeStrategyOptions) {
    
    this.buyDownFeeStrategyOptions = buyDownFeeStrategyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addBuyDownFeeStrategyOptionsItem(StringEnumOptionData buyDownFeeStrategyOptionsItem) {
    if (this.buyDownFeeStrategyOptions == null) {
      this.buyDownFeeStrategyOptions = new ArrayList<>();
    }
    this.buyDownFeeStrategyOptions.add(buyDownFeeStrategyOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeStrategyOptions
   * @return buyDownFeeStrategyOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeStrategyOptions() {
    return buyDownFeeStrategyOptions;
  }


  public void setBuyDownFeeStrategyOptions(List<StringEnumOptionData> buyDownFeeStrategyOptions) {
    this.buyDownFeeStrategyOptions = buyDownFeeStrategyOptions;
  }

  public GetLoanProductsTemplateResponse buydownFeeClassificationOptions(List<GetCodeValuesDataResponse> buydownFeeClassificationOptions) {
    
    this.buydownFeeClassificationOptions = buydownFeeClassificationOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addBuydownFeeClassificationOptionsItem(GetCodeValuesDataResponse buydownFeeClassificationOptionsItem) {
    if (this.buydownFeeClassificationOptions == null) {
      this.buydownFeeClassificationOptions = new ArrayList<>();
    }
    this.buydownFeeClassificationOptions.add(buydownFeeClassificationOptionsItem);
    return this;
  }

  /**
   * Get buydownFeeClassificationOptions
   * @return buydownFeeClassificationOptions
   */
  @javax.annotation.Nullable

  public List<GetCodeValuesDataResponse> getBuydownFeeClassificationOptions() {
    return buydownFeeClassificationOptions;
  }


  public void setBuydownFeeClassificationOptions(List<GetCodeValuesDataResponse> buydownFeeClassificationOptions) {
    this.buydownFeeClassificationOptions = buydownFeeClassificationOptions;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeCalculationTypeOptions(List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions) {
    
    this.capitalizedIncomeCalculationTypeOptions = capitalizedIncomeCalculationTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addCapitalizedIncomeCalculationTypeOptionsItem(StringEnumOptionData capitalizedIncomeCalculationTypeOptionsItem) {
    if (this.capitalizedIncomeCalculationTypeOptions == null) {
      this.capitalizedIncomeCalculationTypeOptions = new ArrayList<>();
    }
    this.capitalizedIncomeCalculationTypeOptions.add(capitalizedIncomeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationTypeOptions
   * @return capitalizedIncomeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeCalculationTypeOptions() {
    return capitalizedIncomeCalculationTypeOptions;
  }


  public void setCapitalizedIncomeCalculationTypeOptions(List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions) {
    this.capitalizedIncomeCalculationTypeOptions = capitalizedIncomeCalculationTypeOptions;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeClassificationOptions(List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions) {
    
    this.capitalizedIncomeClassificationOptions = capitalizedIncomeClassificationOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addCapitalizedIncomeClassificationOptionsItem(GetCodeValuesDataResponse capitalizedIncomeClassificationOptionsItem) {
    if (this.capitalizedIncomeClassificationOptions == null) {
      this.capitalizedIncomeClassificationOptions = new ArrayList<>();
    }
    this.capitalizedIncomeClassificationOptions.add(capitalizedIncomeClassificationOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeClassificationOptions
   * @return capitalizedIncomeClassificationOptions
   */
  @javax.annotation.Nullable

  public List<GetCodeValuesDataResponse> getCapitalizedIncomeClassificationOptions() {
    return capitalizedIncomeClassificationOptions;
  }


  public void setCapitalizedIncomeClassificationOptions(List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions) {
    this.capitalizedIncomeClassificationOptions = capitalizedIncomeClassificationOptions;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeStrategyOptions(List<StringEnumOptionData> capitalizedIncomeStrategyOptions) {
    
    this.capitalizedIncomeStrategyOptions = capitalizedIncomeStrategyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addCapitalizedIncomeStrategyOptionsItem(StringEnumOptionData capitalizedIncomeStrategyOptionsItem) {
    if (this.capitalizedIncomeStrategyOptions == null) {
      this.capitalizedIncomeStrategyOptions = new ArrayList<>();
    }
    this.capitalizedIncomeStrategyOptions.add(capitalizedIncomeStrategyOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeStrategyOptions
   * @return capitalizedIncomeStrategyOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeStrategyOptions() {
    return capitalizedIncomeStrategyOptions;
  }


  public void setCapitalizedIncomeStrategyOptions(List<StringEnumOptionData> capitalizedIncomeStrategyOptions) {
    this.capitalizedIncomeStrategyOptions = capitalizedIncomeStrategyOptions;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public GetLoanProductsTemplateResponse capitalizedIncomeTypeOptions(List<StringEnumOptionData> capitalizedIncomeTypeOptions) {
    
    this.capitalizedIncomeTypeOptions = capitalizedIncomeTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addCapitalizedIncomeTypeOptionsItem(StringEnumOptionData capitalizedIncomeTypeOptionsItem) {
    if (this.capitalizedIncomeTypeOptions == null) {
      this.capitalizedIncomeTypeOptions = new ArrayList<>();
    }
    this.capitalizedIncomeTypeOptions.add(capitalizedIncomeTypeOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeTypeOptions
   * @return capitalizedIncomeTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeTypeOptions() {
    return capitalizedIncomeTypeOptions;
  }


  public void setCapitalizedIncomeTypeOptions(List<StringEnumOptionData> capitalizedIncomeTypeOptions) {
    this.capitalizedIncomeTypeOptions = capitalizedIncomeTypeOptions;
  }

  public GetLoanProductsTemplateResponse chargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public GetLoanProductsTemplateResponse chargeOffBehaviourOptions(List<StringEnumOptionData> chargeOffBehaviourOptions) {
    
    this.chargeOffBehaviourOptions = chargeOffBehaviourOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addChargeOffBehaviourOptionsItem(StringEnumOptionData chargeOffBehaviourOptionsItem) {
    if (this.chargeOffBehaviourOptions == null) {
      this.chargeOffBehaviourOptions = new ArrayList<>();
    }
    this.chargeOffBehaviourOptions.add(chargeOffBehaviourOptionsItem);
    return this;
  }

  /**
   * Get chargeOffBehaviourOptions
   * @return chargeOffBehaviourOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getChargeOffBehaviourOptions() {
    return chargeOffBehaviourOptions;
  }


  public void setChargeOffBehaviourOptions(List<StringEnumOptionData> chargeOffBehaviourOptions) {
    this.chargeOffBehaviourOptions = chargeOffBehaviourOptions;
  }

  public GetLoanProductsTemplateResponse chargeOffReasonOptions(List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions) {
    
    this.chargeOffReasonOptions = chargeOffReasonOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addChargeOffReasonOptionsItem(GetLoanProductsChargeOffReasonOptions chargeOffReasonOptionsItem) {
    if (this.chargeOffReasonOptions == null) {
      this.chargeOffReasonOptions = new ArrayList<>();
    }
    this.chargeOffReasonOptions.add(chargeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get chargeOffReasonOptions
   * @return chargeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<GetLoanProductsChargeOffReasonOptions> getChargeOffReasonOptions() {
    return chargeOffReasonOptions;
  }


  public void setChargeOffReasonOptions(List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions) {
    this.chargeOffReasonOptions = chargeOffReasonOptions;
  }

  public GetLoanProductsTemplateResponse chargeOptions(Set<GetLoanProductsChargeOptions> chargeOptions) {
    
    this.chargeOptions = chargeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addChargeOptionsItem(GetLoanProductsChargeOptions chargeOptionsItem) {
    if (this.chargeOptions == null) {
      this.chargeOptions = new LinkedHashSet<>();
    }
    this.chargeOptions.add(chargeOptionsItem);
    return this;
  }

  /**
   * Get chargeOptions
   * @return chargeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsChargeOptions> getChargeOptions() {
    return chargeOptions;
  }


  public void setChargeOptions(Set<GetLoanProductsChargeOptions> chargeOptions) {
    this.chargeOptions = chargeOptions;
  }

  public GetLoanProductsTemplateResponse creditAllocationAllocationTypes(List<EnumOptionData> creditAllocationAllocationTypes) {
    
    this.creditAllocationAllocationTypes = creditAllocationAllocationTypes;
    return this;
  }

  public GetLoanProductsTemplateResponse addCreditAllocationAllocationTypesItem(EnumOptionData creditAllocationAllocationTypesItem) {
    if (this.creditAllocationAllocationTypes == null) {
      this.creditAllocationAllocationTypes = new ArrayList<>();
    }
    this.creditAllocationAllocationTypes.add(creditAllocationAllocationTypesItem);
    return this;
  }

  /**
   * Get creditAllocationAllocationTypes
   * @return creditAllocationAllocationTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getCreditAllocationAllocationTypes() {
    return creditAllocationAllocationTypes;
  }


  public void setCreditAllocationAllocationTypes(List<EnumOptionData> creditAllocationAllocationTypes) {
    this.creditAllocationAllocationTypes = creditAllocationAllocationTypes;
  }

  public GetLoanProductsTemplateResponse creditAllocationTransactionTypes(List<EnumOptionData> creditAllocationTransactionTypes) {
    
    this.creditAllocationTransactionTypes = creditAllocationTransactionTypes;
    return this;
  }

  public GetLoanProductsTemplateResponse addCreditAllocationTransactionTypesItem(EnumOptionData creditAllocationTransactionTypesItem) {
    if (this.creditAllocationTransactionTypes == null) {
      this.creditAllocationTransactionTypes = new ArrayList<>();
    }
    this.creditAllocationTransactionTypes.add(creditAllocationTransactionTypesItem);
    return this;
  }

  /**
   * Get creditAllocationTransactionTypes
   * @return creditAllocationTransactionTypes
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getCreditAllocationTransactionTypes() {
    return creditAllocationTransactionTypes;
  }


  public void setCreditAllocationTransactionTypes(List<EnumOptionData> creditAllocationTransactionTypes) {
    this.creditAllocationTransactionTypes = creditAllocationTransactionTypes;
  }

  public GetLoanProductsTemplateResponse currency(GetLoanProductsTemplateCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoanProductsTemplateCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoanProductsTemplateCurrency currency) {
    this.currency = currency;
  }

  public GetLoanProductsTemplateResponse currencyOptions(Set<GetLoanProductsCurrencyOptions> currencyOptions) {
    
    this.currencyOptions = currencyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addCurrencyOptionsItem(GetLoanProductsCurrencyOptions currencyOptionsItem) {
    if (this.currencyOptions == null) {
      this.currencyOptions = new LinkedHashSet<>();
    }
    this.currencyOptions.add(currencyOptionsItem);
    return this;
  }

  /**
   * Get currencyOptions
   * @return currencyOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsCurrencyOptions> getCurrencyOptions() {
    return currencyOptions;
  }


  public void setCurrencyOptions(Set<GetLoanProductsCurrencyOptions> currencyOptions) {
    this.currencyOptions = currencyOptions;
  }

  public GetLoanProductsTemplateResponse daysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInMonthType getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public GetLoanProductsTemplateResponse daysInMonthTypeOptions(Set<StringEnumOptionData> daysInMonthTypeOptions) {
    
    this.daysInMonthTypeOptions = daysInMonthTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addDaysInMonthTypeOptionsItem(StringEnumOptionData daysInMonthTypeOptionsItem) {
    if (this.daysInMonthTypeOptions == null) {
      this.daysInMonthTypeOptions = new LinkedHashSet<>();
    }
    this.daysInMonthTypeOptions.add(daysInMonthTypeOptionsItem);
    return this;
  }

  /**
   * Get daysInMonthTypeOptions
   * @return daysInMonthTypeOptions
   */
  @javax.annotation.Nullable

  public Set<StringEnumOptionData> getDaysInMonthTypeOptions() {
    return daysInMonthTypeOptions;
  }


  public void setDaysInMonthTypeOptions(Set<StringEnumOptionData> daysInMonthTypeOptions) {
    this.daysInMonthTypeOptions = daysInMonthTypeOptions;
  }

  public GetLoanProductsTemplateResponse daysInYearCustomStrategy(StringEnumOptionData daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(StringEnumOptionData daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public GetLoanProductsTemplateResponse daysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInYearType getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public GetLoanProductsTemplateResponse daysInYearTypeCustomStrategyOptions(Set<StringEnumOptionData> daysInYearTypeCustomStrategyOptions) {
    
    this.daysInYearTypeCustomStrategyOptions = daysInYearTypeCustomStrategyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addDaysInYearTypeCustomStrategyOptionsItem(StringEnumOptionData daysInYearTypeCustomStrategyOptionsItem) {
    if (this.daysInYearTypeCustomStrategyOptions == null) {
      this.daysInYearTypeCustomStrategyOptions = new LinkedHashSet<>();
    }
    this.daysInYearTypeCustomStrategyOptions.add(daysInYearTypeCustomStrategyOptionsItem);
    return this;
  }

  /**
   * Get daysInYearTypeCustomStrategyOptions
   * @return daysInYearTypeCustomStrategyOptions
   */
  @javax.annotation.Nullable

  public Set<StringEnumOptionData> getDaysInYearTypeCustomStrategyOptions() {
    return daysInYearTypeCustomStrategyOptions;
  }


  public void setDaysInYearTypeCustomStrategyOptions(Set<StringEnumOptionData> daysInYearTypeCustomStrategyOptions) {
    this.daysInYearTypeCustomStrategyOptions = daysInYearTypeCustomStrategyOptions;
  }

  public GetLoanProductsTemplateResponse daysInYearTypeOptions(Set<GetLoanProductsInterestTemplateType> daysInYearTypeOptions) {
    
    this.daysInYearTypeOptions = daysInYearTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addDaysInYearTypeOptionsItem(GetLoanProductsInterestTemplateType daysInYearTypeOptionsItem) {
    if (this.daysInYearTypeOptions == null) {
      this.daysInYearTypeOptions = new LinkedHashSet<>();
    }
    this.daysInYearTypeOptions.add(daysInYearTypeOptionsItem);
    return this;
  }

  /**
   * Get daysInYearTypeOptions
   * @return daysInYearTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsInterestTemplateType> getDaysInYearTypeOptions() {
    return daysInYearTypeOptions;
  }


  public void setDaysInYearTypeOptions(Set<GetLoanProductsInterestTemplateType> daysInYearTypeOptions) {
    this.daysInYearTypeOptions = daysInYearTypeOptions;
  }

  public GetLoanProductsTemplateResponse enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public GetLoanProductsTemplateResponse enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public GetLoanProductsTemplateResponse includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public GetLoanProductsTemplateResponse interestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public GetLoansProductsInterestCalculationPeriodType getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public GetLoanProductsTemplateResponse interestCalculationPeriodTypeOptions(Set<GetLoansProductsInterestCalculationPeriodType> interestCalculationPeriodTypeOptions) {
    
    this.interestCalculationPeriodTypeOptions = interestCalculationPeriodTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestCalculationPeriodTypeOptionsItem(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodTypeOptionsItem) {
    if (this.interestCalculationPeriodTypeOptions == null) {
      this.interestCalculationPeriodTypeOptions = new LinkedHashSet<>();
    }
    this.interestCalculationPeriodTypeOptions.add(interestCalculationPeriodTypeOptionsItem);
    return this;
  }

  /**
   * Get interestCalculationPeriodTypeOptions
   * @return interestCalculationPeriodTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoansProductsInterestCalculationPeriodType> getInterestCalculationPeriodTypeOptions() {
    return interestCalculationPeriodTypeOptions;
  }


  public void setInterestCalculationPeriodTypeOptions(Set<GetLoansProductsInterestCalculationPeriodType> interestCalculationPeriodTypeOptions) {
    this.interestCalculationPeriodTypeOptions = interestCalculationPeriodTypeOptions;
  }

  public GetLoanProductsTemplateResponse interestRateFrequencyType(GetLoanProductsInterestRateTemplateFrequencyType interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRateTemplateFrequencyType getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(GetLoanProductsInterestRateTemplateFrequencyType interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public GetLoanProductsTemplateResponse interestRateFrequencyTypeOptions(Set<GetLoanProductsInterestRateTemplateFrequencyType> interestRateFrequencyTypeOptions) {
    
    this.interestRateFrequencyTypeOptions = interestRateFrequencyTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestRateFrequencyTypeOptionsItem(GetLoanProductsInterestRateTemplateFrequencyType interestRateFrequencyTypeOptionsItem) {
    if (this.interestRateFrequencyTypeOptions == null) {
      this.interestRateFrequencyTypeOptions = new LinkedHashSet<>();
    }
    this.interestRateFrequencyTypeOptions.add(interestRateFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRateFrequencyTypeOptions
   * @return interestRateFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsInterestRateTemplateFrequencyType> getInterestRateFrequencyTypeOptions() {
    return interestRateFrequencyTypeOptions;
  }


  public void setInterestRateFrequencyTypeOptions(Set<GetLoanProductsInterestRateTemplateFrequencyType> interestRateFrequencyTypeOptions) {
    this.interestRateFrequencyTypeOptions = interestRateFrequencyTypeOptions;
  }

  public GetLoanProductsTemplateResponse interestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestRateVariationsForBorrowerCycleItem(Integer interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public GetLoanProductsTemplateResponse interestRecalculationCompoundingTypeOptions(Set<GetLoanProductsInterestRecalculationCompoundingType> interestRecalculationCompoundingTypeOptions) {
    
    this.interestRecalculationCompoundingTypeOptions = interestRecalculationCompoundingTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestRecalculationCompoundingTypeOptionsItem(GetLoanProductsInterestRecalculationCompoundingType interestRecalculationCompoundingTypeOptionsItem) {
    if (this.interestRecalculationCompoundingTypeOptions == null) {
      this.interestRecalculationCompoundingTypeOptions = new LinkedHashSet<>();
    }
    this.interestRecalculationCompoundingTypeOptions.add(interestRecalculationCompoundingTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationCompoundingTypeOptions
   * @return interestRecalculationCompoundingTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsInterestRecalculationCompoundingType> getInterestRecalculationCompoundingTypeOptions() {
    return interestRecalculationCompoundingTypeOptions;
  }


  public void setInterestRecalculationCompoundingTypeOptions(Set<GetLoanProductsInterestRecalculationCompoundingType> interestRecalculationCompoundingTypeOptions) {
    this.interestRecalculationCompoundingTypeOptions = interestRecalculationCompoundingTypeOptions;
  }

  public GetLoanProductsTemplateResponse interestRecalculationData(GetLoanProductsInterestRecalculationTemplateData interestRecalculationData) {
    
    this.interestRecalculationData = interestRecalculationData;
    return this;
  }

  /**
   * Get interestRecalculationData
   * @return interestRecalculationData
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRecalculationTemplateData getInterestRecalculationData() {
    return interestRecalculationData;
  }


  public void setInterestRecalculationData(GetLoanProductsInterestRecalculationTemplateData interestRecalculationData) {
    this.interestRecalculationData = interestRecalculationData;
  }

  public GetLoanProductsTemplateResponse interestRecalculationFrequencyTypeOptions(Set<GetLoanProductsInterestRecalculationCompoundingFrequencyType> interestRecalculationFrequencyTypeOptions) {
    
    this.interestRecalculationFrequencyTypeOptions = interestRecalculationFrequencyTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestRecalculationFrequencyTypeOptionsItem(GetLoanProductsInterestRecalculationCompoundingFrequencyType interestRecalculationFrequencyTypeOptionsItem) {
    if (this.interestRecalculationFrequencyTypeOptions == null) {
      this.interestRecalculationFrequencyTypeOptions = new LinkedHashSet<>();
    }
    this.interestRecalculationFrequencyTypeOptions.add(interestRecalculationFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get interestRecalculationFrequencyTypeOptions
   * @return interestRecalculationFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsInterestRecalculationCompoundingFrequencyType> getInterestRecalculationFrequencyTypeOptions() {
    return interestRecalculationFrequencyTypeOptions;
  }


  public void setInterestRecalculationFrequencyTypeOptions(Set<GetLoanProductsInterestRecalculationCompoundingFrequencyType> interestRecalculationFrequencyTypeOptions) {
    this.interestRecalculationFrequencyTypeOptions = interestRecalculationFrequencyTypeOptions;
  }

  public GetLoanProductsTemplateResponse interestType(GetLoanProductsInterestTemplateType interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestTemplateType getInterestType() {
    return interestType;
  }


  public void setInterestType(GetLoanProductsInterestTemplateType interestType) {
    this.interestType = interestType;
  }

  public GetLoanProductsTemplateResponse interestTypeOptions(Set<GetLoanProductsInterestTemplateType> interestTypeOptions) {
    
    this.interestTypeOptions = interestTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addInterestTypeOptionsItem(GetLoanProductsInterestTemplateType interestTypeOptionsItem) {
    if (this.interestTypeOptions == null) {
      this.interestTypeOptions = new LinkedHashSet<>();
    }
    this.interestTypeOptions.add(interestTypeOptionsItem);
    return this;
  }

  /**
   * Get interestTypeOptions
   * @return interestTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsInterestTemplateType> getInterestTypeOptions() {
    return interestTypeOptions;
  }


  public void setInterestTypeOptions(Set<GetLoanProductsInterestTemplateType> interestTypeOptions) {
    this.interestTypeOptions = interestTypeOptions;
  }

  public GetLoanProductsTemplateResponse isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public GetLoanProductsTemplateResponse loanScheduleProcessingTypeOptions(List<EnumOptionData> loanScheduleProcessingTypeOptions) {
    
    this.loanScheduleProcessingTypeOptions = loanScheduleProcessingTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addLoanScheduleProcessingTypeOptionsItem(EnumOptionData loanScheduleProcessingTypeOptionsItem) {
    if (this.loanScheduleProcessingTypeOptions == null) {
      this.loanScheduleProcessingTypeOptions = new ArrayList<>();
    }
    this.loanScheduleProcessingTypeOptions.add(loanScheduleProcessingTypeOptionsItem);
    return this;
  }

  /**
   * Get loanScheduleProcessingTypeOptions
   * @return loanScheduleProcessingTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanScheduleProcessingTypeOptions() {
    return loanScheduleProcessingTypeOptions;
  }


  public void setLoanScheduleProcessingTypeOptions(List<EnumOptionData> loanScheduleProcessingTypeOptions) {
    this.loanScheduleProcessingTypeOptions = loanScheduleProcessingTypeOptions;
  }

  public GetLoanProductsTemplateResponse loanScheduleTypeOptions(List<EnumOptionData> loanScheduleTypeOptions) {
    
    this.loanScheduleTypeOptions = loanScheduleTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addLoanScheduleTypeOptionsItem(EnumOptionData loanScheduleTypeOptionsItem) {
    if (this.loanScheduleTypeOptions == null) {
      this.loanScheduleTypeOptions = new ArrayList<>();
    }
    this.loanScheduleTypeOptions.add(loanScheduleTypeOptionsItem);
    return this;
  }

  /**
   * Get loanScheduleTypeOptions
   * @return loanScheduleTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLoanScheduleTypeOptions() {
    return loanScheduleTypeOptions;
  }


  public void setLoanScheduleTypeOptions(List<EnumOptionData> loanScheduleTypeOptions) {
    this.loanScheduleTypeOptions = loanScheduleTypeOptions;
  }

  public GetLoanProductsTemplateResponse merchantBuyDownFee(Boolean merchantBuyDownFee) {
    
    this.merchantBuyDownFee = merchantBuyDownFee;
    return this;
  }

  /**
   * Get merchantBuyDownFee
   * @return merchantBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getMerchantBuyDownFee() {
    return merchantBuyDownFee;
  }


  public void setMerchantBuyDownFee(Boolean merchantBuyDownFee) {
    this.merchantBuyDownFee = merchantBuyDownFee;
  }

  public GetLoanProductsTemplateResponse numberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsTemplateResponse addNumberOfRepaymentVariationsForBorrowerCycleItem(Integer numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public GetLoanProductsTemplateResponse paymentTypeOptions(Set<GetLoanProductsPaymentTypeOptions> paymentTypeOptions) {
    
    this.paymentTypeOptions = paymentTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addPaymentTypeOptionsItem(GetLoanProductsPaymentTypeOptions paymentTypeOptionsItem) {
    if (this.paymentTypeOptions == null) {
      this.paymentTypeOptions = new LinkedHashSet<>();
    }
    this.paymentTypeOptions.add(paymentTypeOptionsItem);
    return this;
  }

  /**
   * Get paymentTypeOptions
   * @return paymentTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsPaymentTypeOptions> getPaymentTypeOptions() {
    return paymentTypeOptions;
  }


  public void setPaymentTypeOptions(Set<GetLoanProductsPaymentTypeOptions> paymentTypeOptions) {
    this.paymentTypeOptions = paymentTypeOptions;
  }

  public GetLoanProductsTemplateResponse preClosureInterestCalculationStrategyOptions(Set<GetLoanProductsPreClosureInterestCalculationStrategy> preClosureInterestCalculationStrategyOptions) {
    
    this.preClosureInterestCalculationStrategyOptions = preClosureInterestCalculationStrategyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addPreClosureInterestCalculationStrategyOptionsItem(GetLoanProductsPreClosureInterestCalculationStrategy preClosureInterestCalculationStrategyOptionsItem) {
    if (this.preClosureInterestCalculationStrategyOptions == null) {
      this.preClosureInterestCalculationStrategyOptions = new LinkedHashSet<>();
    }
    this.preClosureInterestCalculationStrategyOptions.add(preClosureInterestCalculationStrategyOptionsItem);
    return this;
  }

  /**
   * Get preClosureInterestCalculationStrategyOptions
   * @return preClosureInterestCalculationStrategyOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsPreClosureInterestCalculationStrategy> getPreClosureInterestCalculationStrategyOptions() {
    return preClosureInterestCalculationStrategyOptions;
  }


  public void setPreClosureInterestCalculationStrategyOptions(Set<GetLoanProductsPreClosureInterestCalculationStrategy> preClosureInterestCalculationStrategyOptions) {
    this.preClosureInterestCalculationStrategyOptions = preClosureInterestCalculationStrategyOptions;
  }

  public GetLoanProductsTemplateResponse principalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsTemplateResponse addPrincipalVariationsForBorrowerCycleItem(Integer principalVariationsForBorrowerCycleItem) {
    if (this.principalVariationsForBorrowerCycle == null) {
      this.principalVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.principalVariationsForBorrowerCycle.add(principalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get principalVariationsForBorrowerCycle
   * @return principalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getPrincipalVariationsForBorrowerCycle() {
    return principalVariationsForBorrowerCycle;
  }


  public void setPrincipalVariationsForBorrowerCycle(List<Integer> principalVariationsForBorrowerCycle) {
    this.principalVariationsForBorrowerCycle = principalVariationsForBorrowerCycle;
  }

  public GetLoanProductsTemplateResponse repaymentFrequencyType(GetLoanProductsRepaymentTemplateFrequencyType repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsRepaymentTemplateFrequencyType getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(GetLoanProductsRepaymentTemplateFrequencyType repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public GetLoanProductsTemplateResponse repaymentFrequencyTypeOptions(Set<GetLoanProductsRepaymentTemplateFrequencyType> repaymentFrequencyTypeOptions) {
    
    this.repaymentFrequencyTypeOptions = repaymentFrequencyTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addRepaymentFrequencyTypeOptionsItem(GetLoanProductsRepaymentTemplateFrequencyType repaymentFrequencyTypeOptionsItem) {
    if (this.repaymentFrequencyTypeOptions == null) {
      this.repaymentFrequencyTypeOptions = new LinkedHashSet<>();
    }
    this.repaymentFrequencyTypeOptions.add(repaymentFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get repaymentFrequencyTypeOptions
   * @return repaymentFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsRepaymentTemplateFrequencyType> getRepaymentFrequencyTypeOptions() {
    return repaymentFrequencyTypeOptions;
  }


  public void setRepaymentFrequencyTypeOptions(Set<GetLoanProductsRepaymentTemplateFrequencyType> repaymentFrequencyTypeOptions) {
    this.repaymentFrequencyTypeOptions = repaymentFrequencyTypeOptions;
  }

  public GetLoanProductsTemplateResponse repaymentStartDateTypeOptions(Set<GetLoanProductsRepaymentStartDateType> repaymentStartDateTypeOptions) {
    
    this.repaymentStartDateTypeOptions = repaymentStartDateTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addRepaymentStartDateTypeOptionsItem(GetLoanProductsRepaymentStartDateType repaymentStartDateTypeOptionsItem) {
    if (this.repaymentStartDateTypeOptions == null) {
      this.repaymentStartDateTypeOptions = new LinkedHashSet<>();
    }
    this.repaymentStartDateTypeOptions.add(repaymentStartDateTypeOptionsItem);
    return this;
  }

  /**
   * Get repaymentStartDateTypeOptions
   * @return repaymentStartDateTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsRepaymentStartDateType> getRepaymentStartDateTypeOptions() {
    return repaymentStartDateTypeOptions;
  }


  public void setRepaymentStartDateTypeOptions(Set<GetLoanProductsRepaymentStartDateType> repaymentStartDateTypeOptions) {
    this.repaymentStartDateTypeOptions = repaymentStartDateTypeOptions;
  }

  public GetLoanProductsTemplateResponse rescheduleStrategyTypeOptions(Set<GetLoanProductsRescheduleStrategyType> rescheduleStrategyTypeOptions) {
    
    this.rescheduleStrategyTypeOptions = rescheduleStrategyTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addRescheduleStrategyTypeOptionsItem(GetLoanProductsRescheduleStrategyType rescheduleStrategyTypeOptionsItem) {
    if (this.rescheduleStrategyTypeOptions == null) {
      this.rescheduleStrategyTypeOptions = new LinkedHashSet<>();
    }
    this.rescheduleStrategyTypeOptions.add(rescheduleStrategyTypeOptionsItem);
    return this;
  }

  /**
   * Get rescheduleStrategyTypeOptions
   * @return rescheduleStrategyTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsRescheduleStrategyType> getRescheduleStrategyTypeOptions() {
    return rescheduleStrategyTypeOptions;
  }


  public void setRescheduleStrategyTypeOptions(Set<GetLoanProductsRescheduleStrategyType> rescheduleStrategyTypeOptions) {
    this.rescheduleStrategyTypeOptions = rescheduleStrategyTypeOptions;
  }

  public GetLoanProductsTemplateResponse supportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public GetLoanProductsTemplateResponse addSupportedInterestRefundTypesItem(StringEnumOptionData supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public GetLoanProductsTemplateResponse supportedInterestRefundTypesOptions(List<StringEnumOptionData> supportedInterestRefundTypesOptions) {
    
    this.supportedInterestRefundTypesOptions = supportedInterestRefundTypesOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addSupportedInterestRefundTypesOptionsItem(StringEnumOptionData supportedInterestRefundTypesOptionsItem) {
    if (this.supportedInterestRefundTypesOptions == null) {
      this.supportedInterestRefundTypesOptions = new ArrayList<>();
    }
    this.supportedInterestRefundTypesOptions.add(supportedInterestRefundTypesOptionsItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypesOptions
   * @return supportedInterestRefundTypesOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypesOptions() {
    return supportedInterestRefundTypesOptions;
  }


  public void setSupportedInterestRefundTypesOptions(List<StringEnumOptionData> supportedInterestRefundTypesOptions) {
    this.supportedInterestRefundTypesOptions = supportedInterestRefundTypesOptions;
  }

  public GetLoanProductsTemplateResponse transactionProcessingStrategyOptions(Set<GetLoanProductsTransactionProcessingStrategyOptions> transactionProcessingStrategyOptions) {
    
    this.transactionProcessingStrategyOptions = transactionProcessingStrategyOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addTransactionProcessingStrategyOptionsItem(GetLoanProductsTransactionProcessingStrategyOptions transactionProcessingStrategyOptionsItem) {
    if (this.transactionProcessingStrategyOptions == null) {
      this.transactionProcessingStrategyOptions = new LinkedHashSet<>();
    }
    this.transactionProcessingStrategyOptions.add(transactionProcessingStrategyOptionsItem);
    return this;
  }

  /**
   * Get transactionProcessingStrategyOptions
   * @return transactionProcessingStrategyOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsTransactionProcessingStrategyOptions> getTransactionProcessingStrategyOptions() {
    return transactionProcessingStrategyOptions;
  }


  public void setTransactionProcessingStrategyOptions(Set<GetLoanProductsTransactionProcessingStrategyOptions> transactionProcessingStrategyOptions) {
    this.transactionProcessingStrategyOptions = transactionProcessingStrategyOptions;
  }

  public GetLoanProductsTemplateResponse useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public GetLoanProductsTemplateResponse valueConditionTypeOptions(Set<GetLoanProductsValueConditionTypeOptions> valueConditionTypeOptions) {
    
    this.valueConditionTypeOptions = valueConditionTypeOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addValueConditionTypeOptionsItem(GetLoanProductsValueConditionTypeOptions valueConditionTypeOptionsItem) {
    if (this.valueConditionTypeOptions == null) {
      this.valueConditionTypeOptions = new LinkedHashSet<>();
    }
    this.valueConditionTypeOptions.add(valueConditionTypeOptionsItem);
    return this;
  }

  /**
   * Get valueConditionTypeOptions
   * @return valueConditionTypeOptions
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsValueConditionTypeOptions> getValueConditionTypeOptions() {
    return valueConditionTypeOptions;
  }


  public void setValueConditionTypeOptions(Set<GetLoanProductsValueConditionTypeOptions> valueConditionTypeOptions) {
    this.valueConditionTypeOptions = valueConditionTypeOptions;
  }

  public GetLoanProductsTemplateResponse writeOffReasonOptions(List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions) {
    
    this.writeOffReasonOptions = writeOffReasonOptions;
    return this;
  }

  public GetLoanProductsTemplateResponse addWriteOffReasonOptionsItem(GetLoanProductsWriteOffReasonOptions writeOffReasonOptionsItem) {
    if (this.writeOffReasonOptions == null) {
      this.writeOffReasonOptions = new ArrayList<>();
    }
    this.writeOffReasonOptions.add(writeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get writeOffReasonOptions
   * @return writeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<GetLoanProductsWriteOffReasonOptions> getWriteOffReasonOptions() {
    return writeOffReasonOptions;
  }


  public void setWriteOffReasonOptions(List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions) {
    this.writeOffReasonOptions = writeOffReasonOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoanProductsTemplateResponse getLoanProductsTemplateResponse = (GetLoanProductsTemplateResponse) o;
    return Objects.equals(this.accountingMappingOptions, getLoanProductsTemplateResponse.accountingMappingOptions) &&
        Objects.equals(this.accountingRule, getLoanProductsTemplateResponse.accountingRule) &&
        Objects.equals(this.accountingRuleOptions, getLoanProductsTemplateResponse.accountingRuleOptions) &&
        Objects.equals(this.advancedPaymentAllocationFutureInstallmentAllocationRules, getLoanProductsTemplateResponse.advancedPaymentAllocationFutureInstallmentAllocationRules) &&
        Objects.equals(this.advancedPaymentAllocationTransactionTypes, getLoanProductsTemplateResponse.advancedPaymentAllocationTransactionTypes) &&
        Objects.equals(this.advancedPaymentAllocationTypes, getLoanProductsTemplateResponse.advancedPaymentAllocationTypes) &&
        Objects.equals(this.amortizationType, getLoanProductsTemplateResponse.amortizationType) &&
        Objects.equals(this.amortizationTypeOptions, getLoanProductsTemplateResponse.amortizationTypeOptions) &&
        Objects.equals(this.buyDownFeeCalculationType, getLoanProductsTemplateResponse.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeCalculationTypeOptions, getLoanProductsTemplateResponse.buyDownFeeCalculationTypeOptions) &&
        Objects.equals(this.buyDownFeeIncomeType, getLoanProductsTemplateResponse.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeIncomeTypeOptions, getLoanProductsTemplateResponse.buyDownFeeIncomeTypeOptions) &&
        Objects.equals(this.buyDownFeeStrategy, getLoanProductsTemplateResponse.buyDownFeeStrategy) &&
        Objects.equals(this.buyDownFeeStrategyOptions, getLoanProductsTemplateResponse.buyDownFeeStrategyOptions) &&
        Objects.equals(this.buydownFeeClassificationOptions, getLoanProductsTemplateResponse.buydownFeeClassificationOptions) &&
        Objects.equals(this.capitalizedIncomeCalculationType, getLoanProductsTemplateResponse.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeCalculationTypeOptions, getLoanProductsTemplateResponse.capitalizedIncomeCalculationTypeOptions) &&
        Objects.equals(this.capitalizedIncomeClassificationOptions, getLoanProductsTemplateResponse.capitalizedIncomeClassificationOptions) &&
        Objects.equals(this.capitalizedIncomeStrategy, getLoanProductsTemplateResponse.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeStrategyOptions, getLoanProductsTemplateResponse.capitalizedIncomeStrategyOptions) &&
        Objects.equals(this.capitalizedIncomeType, getLoanProductsTemplateResponse.capitalizedIncomeType) &&
        Objects.equals(this.capitalizedIncomeTypeOptions, getLoanProductsTemplateResponse.capitalizedIncomeTypeOptions) &&
        Objects.equals(this.chargeOffBehaviour, getLoanProductsTemplateResponse.chargeOffBehaviour) &&
        Objects.equals(this.chargeOffBehaviourOptions, getLoanProductsTemplateResponse.chargeOffBehaviourOptions) &&
        Objects.equals(this.chargeOffReasonOptions, getLoanProductsTemplateResponse.chargeOffReasonOptions) &&
        Objects.equals(this.chargeOptions, getLoanProductsTemplateResponse.chargeOptions) &&
        Objects.equals(this.creditAllocationAllocationTypes, getLoanProductsTemplateResponse.creditAllocationAllocationTypes) &&
        Objects.equals(this.creditAllocationTransactionTypes, getLoanProductsTemplateResponse.creditAllocationTransactionTypes) &&
        Objects.equals(this.currency, getLoanProductsTemplateResponse.currency) &&
        Objects.equals(this.currencyOptions, getLoanProductsTemplateResponse.currencyOptions) &&
        Objects.equals(this.daysInMonthType, getLoanProductsTemplateResponse.daysInMonthType) &&
        Objects.equals(this.daysInMonthTypeOptions, getLoanProductsTemplateResponse.daysInMonthTypeOptions) &&
        Objects.equals(this.daysInYearCustomStrategy, getLoanProductsTemplateResponse.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, getLoanProductsTemplateResponse.daysInYearType) &&
        Objects.equals(this.daysInYearTypeCustomStrategyOptions, getLoanProductsTemplateResponse.daysInYearTypeCustomStrategyOptions) &&
        Objects.equals(this.daysInYearTypeOptions, getLoanProductsTemplateResponse.daysInYearTypeOptions) &&
        Objects.equals(this.enableBuyDownFee, getLoanProductsTemplateResponse.enableBuyDownFee) &&
        Objects.equals(this.enableIncomeCapitalization, getLoanProductsTemplateResponse.enableIncomeCapitalization) &&
        Objects.equals(this.includeInBorrowerCycle, getLoanProductsTemplateResponse.includeInBorrowerCycle) &&
        Objects.equals(this.interestCalculationPeriodType, getLoanProductsTemplateResponse.interestCalculationPeriodType) &&
        Objects.equals(this.interestCalculationPeriodTypeOptions, getLoanProductsTemplateResponse.interestCalculationPeriodTypeOptions) &&
        Objects.equals(this.interestRateFrequencyType, getLoanProductsTemplateResponse.interestRateFrequencyType) &&
        Objects.equals(this.interestRateFrequencyTypeOptions, getLoanProductsTemplateResponse.interestRateFrequencyTypeOptions) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, getLoanProductsTemplateResponse.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationCompoundingTypeOptions, getLoanProductsTemplateResponse.interestRecalculationCompoundingTypeOptions) &&
        Objects.equals(this.interestRecalculationData, getLoanProductsTemplateResponse.interestRecalculationData) &&
        Objects.equals(this.interestRecalculationFrequencyTypeOptions, getLoanProductsTemplateResponse.interestRecalculationFrequencyTypeOptions) &&
        Objects.equals(this.interestType, getLoanProductsTemplateResponse.interestType) &&
        Objects.equals(this.interestTypeOptions, getLoanProductsTemplateResponse.interestTypeOptions) &&
        Objects.equals(this.isInterestRecalculationEnabled, getLoanProductsTemplateResponse.isInterestRecalculationEnabled) &&
        Objects.equals(this.loanScheduleProcessingTypeOptions, getLoanProductsTemplateResponse.loanScheduleProcessingTypeOptions) &&
        Objects.equals(this.loanScheduleTypeOptions, getLoanProductsTemplateResponse.loanScheduleTypeOptions) &&
        Objects.equals(this.merchantBuyDownFee, getLoanProductsTemplateResponse.merchantBuyDownFee) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, getLoanProductsTemplateResponse.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.paymentTypeOptions, getLoanProductsTemplateResponse.paymentTypeOptions) &&
        Objects.equals(this.preClosureInterestCalculationStrategyOptions, getLoanProductsTemplateResponse.preClosureInterestCalculationStrategyOptions) &&
        Objects.equals(this.principalVariationsForBorrowerCycle, getLoanProductsTemplateResponse.principalVariationsForBorrowerCycle) &&
        Objects.equals(this.repaymentFrequencyType, getLoanProductsTemplateResponse.repaymentFrequencyType) &&
        Objects.equals(this.repaymentFrequencyTypeOptions, getLoanProductsTemplateResponse.repaymentFrequencyTypeOptions) &&
        Objects.equals(this.repaymentStartDateTypeOptions, getLoanProductsTemplateResponse.repaymentStartDateTypeOptions) &&
        Objects.equals(this.rescheduleStrategyTypeOptions, getLoanProductsTemplateResponse.rescheduleStrategyTypeOptions) &&
        Objects.equals(this.supportedInterestRefundTypes, getLoanProductsTemplateResponse.supportedInterestRefundTypes) &&
        Objects.equals(this.supportedInterestRefundTypesOptions, getLoanProductsTemplateResponse.supportedInterestRefundTypesOptions) &&
        Objects.equals(this.transactionProcessingStrategyOptions, getLoanProductsTemplateResponse.transactionProcessingStrategyOptions) &&
        Objects.equals(this.useBorrowerCycle, getLoanProductsTemplateResponse.useBorrowerCycle) &&
        Objects.equals(this.valueConditionTypeOptions, getLoanProductsTemplateResponse.valueConditionTypeOptions) &&
        Objects.equals(this.writeOffReasonOptions, getLoanProductsTemplateResponse.writeOffReasonOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountingMappingOptions, accountingRule, accountingRuleOptions, advancedPaymentAllocationFutureInstallmentAllocationRules, advancedPaymentAllocationTransactionTypes, advancedPaymentAllocationTypes, amortizationType, amortizationTypeOptions, buyDownFeeCalculationType, buyDownFeeCalculationTypeOptions, buyDownFeeIncomeType, buyDownFeeIncomeTypeOptions, buyDownFeeStrategy, buyDownFeeStrategyOptions, buydownFeeClassificationOptions, capitalizedIncomeCalculationType, capitalizedIncomeCalculationTypeOptions, capitalizedIncomeClassificationOptions, capitalizedIncomeStrategy, capitalizedIncomeStrategyOptions, capitalizedIncomeType, capitalizedIncomeTypeOptions, chargeOffBehaviour, chargeOffBehaviourOptions, chargeOffReasonOptions, chargeOptions, creditAllocationAllocationTypes, creditAllocationTransactionTypes, currency, currencyOptions, daysInMonthType, daysInMonthTypeOptions, daysInYearCustomStrategy, daysInYearType, daysInYearTypeCustomStrategyOptions, daysInYearTypeOptions, enableBuyDownFee, enableIncomeCapitalization, includeInBorrowerCycle, interestCalculationPeriodType, interestCalculationPeriodTypeOptions, interestRateFrequencyType, interestRateFrequencyTypeOptions, interestRateVariationsForBorrowerCycle, interestRecalculationCompoundingTypeOptions, interestRecalculationData, interestRecalculationFrequencyTypeOptions, interestType, interestTypeOptions, isInterestRecalculationEnabled, loanScheduleProcessingTypeOptions, loanScheduleTypeOptions, merchantBuyDownFee, numberOfRepaymentVariationsForBorrowerCycle, paymentTypeOptions, preClosureInterestCalculationStrategyOptions, principalVariationsForBorrowerCycle, repaymentFrequencyType, repaymentFrequencyTypeOptions, repaymentStartDateTypeOptions, rescheduleStrategyTypeOptions, supportedInterestRefundTypes, supportedInterestRefundTypesOptions, transactionProcessingStrategyOptions, useBorrowerCycle, valueConditionTypeOptions, writeOffReasonOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoanProductsTemplateResponse {\n");
    sb.append("    accountingMappingOptions: ").append(toIndentedString(accountingMappingOptions)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    accountingRuleOptions: ").append(toIndentedString(accountingRuleOptions)).append("\n");
    sb.append("    advancedPaymentAllocationFutureInstallmentAllocationRules: ").append(toIndentedString(advancedPaymentAllocationFutureInstallmentAllocationRules)).append("\n");
    sb.append("    advancedPaymentAllocationTransactionTypes: ").append(toIndentedString(advancedPaymentAllocationTransactionTypes)).append("\n");
    sb.append("    advancedPaymentAllocationTypes: ").append(toIndentedString(advancedPaymentAllocationTypes)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    amortizationTypeOptions: ").append(toIndentedString(amortizationTypeOptions)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeCalculationTypeOptions: ").append(toIndentedString(buyDownFeeCalculationTypeOptions)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeIncomeTypeOptions: ").append(toIndentedString(buyDownFeeIncomeTypeOptions)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    buyDownFeeStrategyOptions: ").append(toIndentedString(buyDownFeeStrategyOptions)).append("\n");
    sb.append("    buydownFeeClassificationOptions: ").append(toIndentedString(buydownFeeClassificationOptions)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeCalculationTypeOptions: ").append(toIndentedString(capitalizedIncomeCalculationTypeOptions)).append("\n");
    sb.append("    capitalizedIncomeClassificationOptions: ").append(toIndentedString(capitalizedIncomeClassificationOptions)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeStrategyOptions: ").append(toIndentedString(capitalizedIncomeStrategyOptions)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    capitalizedIncomeTypeOptions: ").append(toIndentedString(capitalizedIncomeTypeOptions)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargeOffBehaviourOptions: ").append(toIndentedString(chargeOffBehaviourOptions)).append("\n");
    sb.append("    chargeOffReasonOptions: ").append(toIndentedString(chargeOffReasonOptions)).append("\n");
    sb.append("    chargeOptions: ").append(toIndentedString(chargeOptions)).append("\n");
    sb.append("    creditAllocationAllocationTypes: ").append(toIndentedString(creditAllocationAllocationTypes)).append("\n");
    sb.append("    creditAllocationTransactionTypes: ").append(toIndentedString(creditAllocationTransactionTypes)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currencyOptions: ").append(toIndentedString(currencyOptions)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInMonthTypeOptions: ").append(toIndentedString(daysInMonthTypeOptions)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    daysInYearTypeCustomStrategyOptions: ").append(toIndentedString(daysInYearTypeCustomStrategyOptions)).append("\n");
    sb.append("    daysInYearTypeOptions: ").append(toIndentedString(daysInYearTypeOptions)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestCalculationPeriodTypeOptions: ").append(toIndentedString(interestCalculationPeriodTypeOptions)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRateFrequencyTypeOptions: ").append(toIndentedString(interestRateFrequencyTypeOptions)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationCompoundingTypeOptions: ").append(toIndentedString(interestRecalculationCompoundingTypeOptions)).append("\n");
    sb.append("    interestRecalculationData: ").append(toIndentedString(interestRecalculationData)).append("\n");
    sb.append("    interestRecalculationFrequencyTypeOptions: ").append(toIndentedString(interestRecalculationFrequencyTypeOptions)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    interestTypeOptions: ").append(toIndentedString(interestTypeOptions)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    loanScheduleProcessingTypeOptions: ").append(toIndentedString(loanScheduleProcessingTypeOptions)).append("\n");
    sb.append("    loanScheduleTypeOptions: ").append(toIndentedString(loanScheduleTypeOptions)).append("\n");
    sb.append("    merchantBuyDownFee: ").append(toIndentedString(merchantBuyDownFee)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    paymentTypeOptions: ").append(toIndentedString(paymentTypeOptions)).append("\n");
    sb.append("    preClosureInterestCalculationStrategyOptions: ").append(toIndentedString(preClosureInterestCalculationStrategyOptions)).append("\n");
    sb.append("    principalVariationsForBorrowerCycle: ").append(toIndentedString(principalVariationsForBorrowerCycle)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentFrequencyTypeOptions: ").append(toIndentedString(repaymentFrequencyTypeOptions)).append("\n");
    sb.append("    repaymentStartDateTypeOptions: ").append(toIndentedString(repaymentStartDateTypeOptions)).append("\n");
    sb.append("    rescheduleStrategyTypeOptions: ").append(toIndentedString(rescheduleStrategyTypeOptions)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    supportedInterestRefundTypesOptions: ").append(toIndentedString(supportedInterestRefundTypesOptions)).append("\n");
    sb.append("    transactionProcessingStrategyOptions: ").append(toIndentedString(transactionProcessingStrategyOptions)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    valueConditionTypeOptions: ").append(toIndentedString(valueConditionTypeOptions)).append("\n");
    sb.append("    writeOffReasonOptions: ").append(toIndentedString(writeOffReasonOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

