/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.fineract.client.models.EnumOptionData;

/**
 * LoanProductBorrowerCycleVariationData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductBorrowerCycleVariationData {
  public static final String SERIALIZED_NAME_BORROWER_CYCLE_NUMBER = "borrowerCycleNumber";
  @SerializedName(SERIALIZED_NAME_BORROWER_CYCLE_NUMBER)
  private Integer borrowerCycleNumber;

  public static final String SERIALIZED_NAME_DEFAULT_VALUE = "defaultValue";
  @SerializedName(SERIALIZED_NAME_DEFAULT_VALUE)
  private BigDecimal defaultValue;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  /**
   * Gets or Sets loanProductParamType
   */
  @JsonAdapter(LoanProductParamTypeEnum.Adapter.class)
  public enum LoanProductParamTypeEnum {
    INVALID("INVALID"),
    
    PRINCIPAL("PRINCIPAL"),
    
    INTERESTRATE("INTERESTRATE"),
    
    REPAYMENT("REPAYMENT");

    private String value;

    LoanProductParamTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LoanProductParamTypeEnum fromValue(String value) {
      for (LoanProductParamTypeEnum b : LoanProductParamTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LoanProductParamTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LoanProductParamTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LoanProductParamTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LoanProductParamTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_PARAM_TYPE = "loanProductParamType";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_PARAM_TYPE)
  private LoanProductParamTypeEnum loanProductParamType;

  /**
   * Gets or Sets loanProductValueConditionType
   */
  @JsonAdapter(LoanProductValueConditionTypeEnum.Adapter.class)
  public enum LoanProductValueConditionTypeEnum {
    INVALID("INVALID"),
    
    EQUAL("EQUAL"),
    
    GREATERTHAN("GREATERTHAN");

    private String value;

    LoanProductValueConditionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LoanProductValueConditionTypeEnum fromValue(String value) {
      for (LoanProductValueConditionTypeEnum b : LoanProductValueConditionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LoanProductValueConditionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LoanProductValueConditionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LoanProductValueConditionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LoanProductValueConditionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_VALUE_CONDITION_TYPE = "loanProductValueConditionType";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_VALUE_CONDITION_TYPE)
  private LoanProductValueConditionTypeEnum loanProductValueConditionType;

  public static final String SERIALIZED_NAME_MAX_VALUE = "maxValue";
  @SerializedName(SERIALIZED_NAME_MAX_VALUE)
  private BigDecimal maxValue;

  public static final String SERIALIZED_NAME_MIN_VALUE = "minValue";
  @SerializedName(SERIALIZED_NAME_MIN_VALUE)
  private BigDecimal minValue;

  public static final String SERIALIZED_NAME_PARAM_TYPE = "paramType";
  @SerializedName(SERIALIZED_NAME_PARAM_TYPE)
  private EnumOptionData paramType;

  public static final String SERIALIZED_NAME_VALUE_CONDITION_TYPE = "valueConditionType";
  @SerializedName(SERIALIZED_NAME_VALUE_CONDITION_TYPE)
  private EnumOptionData valueConditionType;

  public LoanProductBorrowerCycleVariationData() {
  }

  public LoanProductBorrowerCycleVariationData borrowerCycleNumber(Integer borrowerCycleNumber) {
    
    this.borrowerCycleNumber = borrowerCycleNumber;
    return this;
  }

  /**
   * Get borrowerCycleNumber
   * @return borrowerCycleNumber
   */
  @javax.annotation.Nullable

  public Integer getBorrowerCycleNumber() {
    return borrowerCycleNumber;
  }


  public void setBorrowerCycleNumber(Integer borrowerCycleNumber) {
    this.borrowerCycleNumber = borrowerCycleNumber;
  }

  public LoanProductBorrowerCycleVariationData defaultValue(BigDecimal defaultValue) {
    
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Get defaultValue
   * @return defaultValue
   */
  @javax.annotation.Nullable

  public BigDecimal getDefaultValue() {
    return defaultValue;
  }


  public void setDefaultValue(BigDecimal defaultValue) {
    this.defaultValue = defaultValue;
  }

  public LoanProductBorrowerCycleVariationData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProductBorrowerCycleVariationData loanProductParamType(LoanProductParamTypeEnum loanProductParamType) {
    
    this.loanProductParamType = loanProductParamType;
    return this;
  }

  /**
   * Get loanProductParamType
   * @return loanProductParamType
   */
  @javax.annotation.Nullable

  public LoanProductParamTypeEnum getLoanProductParamType() {
    return loanProductParamType;
  }


  public void setLoanProductParamType(LoanProductParamTypeEnum loanProductParamType) {
    this.loanProductParamType = loanProductParamType;
  }

  public LoanProductBorrowerCycleVariationData loanProductValueConditionType(LoanProductValueConditionTypeEnum loanProductValueConditionType) {
    
    this.loanProductValueConditionType = loanProductValueConditionType;
    return this;
  }

  /**
   * Get loanProductValueConditionType
   * @return loanProductValueConditionType
   */
  @javax.annotation.Nullable

  public LoanProductValueConditionTypeEnum getLoanProductValueConditionType() {
    return loanProductValueConditionType;
  }


  public void setLoanProductValueConditionType(LoanProductValueConditionTypeEnum loanProductValueConditionType) {
    this.loanProductValueConditionType = loanProductValueConditionType;
  }

  public LoanProductBorrowerCycleVariationData maxValue(BigDecimal maxValue) {
    
    this.maxValue = maxValue;
    return this;
  }

  /**
   * Get maxValue
   * @return maxValue
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxValue() {
    return maxValue;
  }


  public void setMaxValue(BigDecimal maxValue) {
    this.maxValue = maxValue;
  }

  public LoanProductBorrowerCycleVariationData minValue(BigDecimal minValue) {
    
    this.minValue = minValue;
    return this;
  }

  /**
   * Get minValue
   * @return minValue
   */
  @javax.annotation.Nullable

  public BigDecimal getMinValue() {
    return minValue;
  }


  public void setMinValue(BigDecimal minValue) {
    this.minValue = minValue;
  }

  public LoanProductBorrowerCycleVariationData paramType(EnumOptionData paramType) {
    
    this.paramType = paramType;
    return this;
  }

  /**
   * Get paramType
   * @return paramType
   */
  @javax.annotation.Nullable

  public EnumOptionData getParamType() {
    return paramType;
  }


  public void setParamType(EnumOptionData paramType) {
    this.paramType = paramType;
  }

  public LoanProductBorrowerCycleVariationData valueConditionType(EnumOptionData valueConditionType) {
    
    this.valueConditionType = valueConditionType;
    return this;
  }

  /**
   * Get valueConditionType
   * @return valueConditionType
   */
  @javax.annotation.Nullable

  public EnumOptionData getValueConditionType() {
    return valueConditionType;
  }


  public void setValueConditionType(EnumOptionData valueConditionType) {
    this.valueConditionType = valueConditionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductBorrowerCycleVariationData loanProductBorrowerCycleVariationData = (LoanProductBorrowerCycleVariationData) o;
    return Objects.equals(this.borrowerCycleNumber, loanProductBorrowerCycleVariationData.borrowerCycleNumber) &&
        Objects.equals(this.defaultValue, loanProductBorrowerCycleVariationData.defaultValue) &&
        Objects.equals(this.id, loanProductBorrowerCycleVariationData.id) &&
        Objects.equals(this.loanProductParamType, loanProductBorrowerCycleVariationData.loanProductParamType) &&
        Objects.equals(this.loanProductValueConditionType, loanProductBorrowerCycleVariationData.loanProductValueConditionType) &&
        Objects.equals(this.maxValue, loanProductBorrowerCycleVariationData.maxValue) &&
        Objects.equals(this.minValue, loanProductBorrowerCycleVariationData.minValue) &&
        Objects.equals(this.paramType, loanProductBorrowerCycleVariationData.paramType) &&
        Objects.equals(this.valueConditionType, loanProductBorrowerCycleVariationData.valueConditionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(borrowerCycleNumber, defaultValue, id, loanProductParamType, loanProductValueConditionType, maxValue, minValue, paramType, valueConditionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductBorrowerCycleVariationData {\n");
    sb.append("    borrowerCycleNumber: ").append(toIndentedString(borrowerCycleNumber)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loanProductParamType: ").append(toIndentedString(loanProductParamType)).append("\n");
    sb.append("    loanProductValueConditionType: ").append(toIndentedString(loanProductValueConditionType)).append("\n");
    sb.append("    maxValue: ").append(toIndentedString(maxValue)).append("\n");
    sb.append("    minValue: ").append(toIndentedString(minValue)).append("\n");
    sb.append("    paramType: ").append(toIndentedString(paramType)).append("\n");
    sb.append("    valueConditionType: ").append(toIndentedString(valueConditionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

