/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.ChargeData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.SavingsAccountData;
import org.apache.fineract.client.models.ShareAccountApplicationTimelineData;
import org.apache.fineract.client.models.ShareAccountChargeData;
import org.apache.fineract.client.models.ShareAccountDividendData;
import org.apache.fineract.client.models.ShareAccountStatusEnumData;
import org.apache.fineract.client.models.ShareAccountSummaryData;
import org.apache.fineract.client.models.ShareAccountTransactionData;

/**
 * ShareAccountData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class ShareAccountData {
  public static final String SERIALIZED_NAME_ACCOUNT_NO = "accountNo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NO)
  private String accountNo;

  public static final String SERIALIZED_NAME_ALLOW_DIVIDEND_CALCULATION_FOR_INACTIVE_CLIENTS = "allowDividendCalculationForInactiveClients";
  @SerializedName(SERIALIZED_NAME_ALLOW_DIVIDEND_CALCULATION_FOR_INACTIVE_CLIENTS)
  private Boolean allowDividendCalculationForInactiveClients;

  public static final String SERIALIZED_NAME_APPLICATION_DATE = "applicationDate";
  @SerializedName(SERIALIZED_NAME_APPLICATION_DATE)
  private LocalDate applicationDate;

  public static final String SERIALIZED_NAME_CHARGE_OPTIONS = "chargeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OPTIONS)
  private List<ChargeData> chargeOptions;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<ShareAccountChargeData> charges;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_CLIENT_NAME = "clientName";
  @SerializedName(SERIALIZED_NAME_CLIENT_NAME)
  private String clientName;

  public static final String SERIALIZED_NAME_CLIENT_SAVINGS_ACCOUNTS = "clientSavingsAccounts";
  @SerializedName(SERIALIZED_NAME_CLIENT_SAVINGS_ACCOUNTS)
  private List<SavingsAccountData> clientSavingsAccounts;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_CURRENT_MARKET_PRICE = "currentMarketPrice";
  @SerializedName(SERIALIZED_NAME_CURRENT_MARKET_PRICE)
  private BigDecimal currentMarketPrice;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_DEFAULT_SHARES = "defaultShares";
  @SerializedName(SERIALIZED_NAME_DEFAULT_SHARES)
  private Long defaultShares;

  public static final String SERIALIZED_NAME_DIVIDENDS = "dividends";
  @SerializedName(SERIALIZED_NAME_DIVIDENDS)
  private List<ShareAccountDividendData> dividends;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_LOCK_PERIOD_TYPE_ENUM = "lockPeriodTypeEnum";
  @SerializedName(SERIALIZED_NAME_LOCK_PERIOD_TYPE_ENUM)
  private EnumOptionData lockPeriodTypeEnum;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD = "lockinPeriod";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD)
  private Integer lockinPeriod;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY = "lockinPeriodFrequency";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY)
  private Integer lockinPeriodFrequency;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE = "lockinPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE)
  private Integer lockinPeriodFrequencyType;

  public static final String SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_OPTIONS = "lockinPeriodFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_LOCKIN_PERIOD_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> lockinPeriodFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD = "minimumActivePeriod";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD)
  private Integer minimumActivePeriod;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE = "minimumActivePeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE)
  private Integer minimumActivePeriodFrequencyType;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE_OPTIONS = "minimumActivePeriodFrequencyTypeOptions";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_FREQUENCY_TYPE_OPTIONS)
  private List<EnumOptionData> minimumActivePeriodFrequencyTypeOptions;

  public static final String SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_TYPE_ENUM = "minimumActivePeriodTypeEnum";
  @SerializedName(SERIALIZED_NAME_MINIMUM_ACTIVE_PERIOD_TYPE_ENUM)
  private EnumOptionData minimumActivePeriodTypeEnum;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_PRODUCT_NAME = "productName";
  @SerializedName(SERIALIZED_NAME_PRODUCT_NAME)
  private String productName;

  public static final String SERIALIZED_NAME_PRODUCT_OPTIONS = "productOptions";
  @SerializedName(SERIALIZED_NAME_PRODUCT_OPTIONS)
  private List<Object> productOptions;

  public static final String SERIALIZED_NAME_PURCHASED_SHARES = "purchasedShares";
  @SerializedName(SERIALIZED_NAME_PURCHASED_SHARES)
  private List<ShareAccountTransactionData> purchasedShares;

  public static final String SERIALIZED_NAME_REQUESTED_SHARES = "requestedShares";
  @SerializedName(SERIALIZED_NAME_REQUESTED_SHARES)
  private Integer requestedShares;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_ID = "savingsAccountId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_ID)
  private Long savingsAccountId;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT_NUMBER = "savingsAccountNumber";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT_NUMBER)
  private String savingsAccountNumber;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private ShareAccountStatusEnumData status;

  public static final String SERIALIZED_NAME_SUBMITTED_DATE = "submittedDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_DATE)
  private LocalDate submittedDate;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private ShareAccountSummaryData summary;

  public static final String SERIALIZED_NAME_TIMELINE = "timeline";
  @SerializedName(SERIALIZED_NAME_TIMELINE)
  private ShareAccountApplicationTimelineData timeline;

  public ShareAccountData() {
  }

  public ShareAccountData accountNo(String accountNo) {
    
    this.accountNo = accountNo;
    return this;
  }

  /**
   * Get accountNo
   * @return accountNo
   */
  @javax.annotation.Nullable

  public String getAccountNo() {
    return accountNo;
  }


  public void setAccountNo(String accountNo) {
    this.accountNo = accountNo;
  }

  public ShareAccountData allowDividendCalculationForInactiveClients(Boolean allowDividendCalculationForInactiveClients) {
    
    this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
    return this;
  }

  /**
   * Get allowDividendCalculationForInactiveClients
   * @return allowDividendCalculationForInactiveClients
   */
  @javax.annotation.Nullable

  public Boolean getAllowDividendCalculationForInactiveClients() {
    return allowDividendCalculationForInactiveClients;
  }


  public void setAllowDividendCalculationForInactiveClients(Boolean allowDividendCalculationForInactiveClients) {
    this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
  }

  public ShareAccountData applicationDate(LocalDate applicationDate) {
    
    this.applicationDate = applicationDate;
    return this;
  }

  /**
   * Get applicationDate
   * @return applicationDate
   */
  @javax.annotation.Nullable

  public LocalDate getApplicationDate() {
    return applicationDate;
  }


  public void setApplicationDate(LocalDate applicationDate) {
    this.applicationDate = applicationDate;
  }

  public ShareAccountData chargeOptions(List<ChargeData> chargeOptions) {
    
    this.chargeOptions = chargeOptions;
    return this;
  }

  public ShareAccountData addChargeOptionsItem(ChargeData chargeOptionsItem) {
    if (this.chargeOptions == null) {
      this.chargeOptions = new ArrayList<>();
    }
    this.chargeOptions.add(chargeOptionsItem);
    return this;
  }

  /**
   * Get chargeOptions
   * @return chargeOptions
   */
  @javax.annotation.Nullable

  public List<ChargeData> getChargeOptions() {
    return chargeOptions;
  }


  public void setChargeOptions(List<ChargeData> chargeOptions) {
    this.chargeOptions = chargeOptions;
  }

  public ShareAccountData charges(List<ShareAccountChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public ShareAccountData addChargesItem(ShareAccountChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<ShareAccountChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<ShareAccountChargeData> charges) {
    this.charges = charges;
  }

  public ShareAccountData clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public ShareAccountData clientName(String clientName) {
    
    this.clientName = clientName;
    return this;
  }

  /**
   * Get clientName
   * @return clientName
   */
  @javax.annotation.Nullable

  public String getClientName() {
    return clientName;
  }


  public void setClientName(String clientName) {
    this.clientName = clientName;
  }

  public ShareAccountData clientSavingsAccounts(List<SavingsAccountData> clientSavingsAccounts) {
    
    this.clientSavingsAccounts = clientSavingsAccounts;
    return this;
  }

  public ShareAccountData addClientSavingsAccountsItem(SavingsAccountData clientSavingsAccountsItem) {
    if (this.clientSavingsAccounts == null) {
      this.clientSavingsAccounts = new ArrayList<>();
    }
    this.clientSavingsAccounts.add(clientSavingsAccountsItem);
    return this;
  }

  /**
   * Get clientSavingsAccounts
   * @return clientSavingsAccounts
   */
  @javax.annotation.Nullable

  public List<SavingsAccountData> getClientSavingsAccounts() {
    return clientSavingsAccounts;
  }


  public void setClientSavingsAccounts(List<SavingsAccountData> clientSavingsAccounts) {
    this.clientSavingsAccounts = clientSavingsAccounts;
  }

  public ShareAccountData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public ShareAccountData currentMarketPrice(BigDecimal currentMarketPrice) {
    
    this.currentMarketPrice = currentMarketPrice;
    return this;
  }

  /**
   * Get currentMarketPrice
   * @return currentMarketPrice
   */
  @javax.annotation.Nullable

  public BigDecimal getCurrentMarketPrice() {
    return currentMarketPrice;
  }


  public void setCurrentMarketPrice(BigDecimal currentMarketPrice) {
    this.currentMarketPrice = currentMarketPrice;
  }

  public ShareAccountData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public ShareAccountData defaultShares(Long defaultShares) {
    
    this.defaultShares = defaultShares;
    return this;
  }

  /**
   * Get defaultShares
   * @return defaultShares
   */
  @javax.annotation.Nullable

  public Long getDefaultShares() {
    return defaultShares;
  }


  public void setDefaultShares(Long defaultShares) {
    this.defaultShares = defaultShares;
  }

  public ShareAccountData dividends(List<ShareAccountDividendData> dividends) {
    
    this.dividends = dividends;
    return this;
  }

  public ShareAccountData addDividendsItem(ShareAccountDividendData dividendsItem) {
    if (this.dividends == null) {
      this.dividends = new ArrayList<>();
    }
    this.dividends.add(dividendsItem);
    return this;
  }

  /**
   * Get dividends
   * @return dividends
   */
  @javax.annotation.Nullable

  public List<ShareAccountDividendData> getDividends() {
    return dividends;
  }


  public void setDividends(List<ShareAccountDividendData> dividends) {
    this.dividends = dividends;
  }

  public ShareAccountData externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public ShareAccountData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public ShareAccountData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public ShareAccountData lockPeriodTypeEnum(EnumOptionData lockPeriodTypeEnum) {
    
    this.lockPeriodTypeEnum = lockPeriodTypeEnum;
    return this;
  }

  /**
   * Get lockPeriodTypeEnum
   * @return lockPeriodTypeEnum
   */
  @javax.annotation.Nullable

  public EnumOptionData getLockPeriodTypeEnum() {
    return lockPeriodTypeEnum;
  }


  public void setLockPeriodTypeEnum(EnumOptionData lockPeriodTypeEnum) {
    this.lockPeriodTypeEnum = lockPeriodTypeEnum;
  }

  public ShareAccountData lockinPeriod(Integer lockinPeriod) {
    
    this.lockinPeriod = lockinPeriod;
    return this;
  }

  /**
   * Get lockinPeriod
   * @return lockinPeriod
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriod() {
    return lockinPeriod;
  }


  public void setLockinPeriod(Integer lockinPeriod) {
    this.lockinPeriod = lockinPeriod;
  }

  public ShareAccountData lockinPeriodFrequency(Integer lockinPeriodFrequency) {
    
    this.lockinPeriodFrequency = lockinPeriodFrequency;
    return this;
  }

  /**
   * Get lockinPeriodFrequency
   * @return lockinPeriodFrequency
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriodFrequency() {
    return lockinPeriodFrequency;
  }


  public void setLockinPeriodFrequency(Integer lockinPeriodFrequency) {
    this.lockinPeriodFrequency = lockinPeriodFrequency;
  }

  public ShareAccountData lockinPeriodFrequencyType(Integer lockinPeriodFrequencyType) {
    
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
    return this;
  }

  /**
   * Get lockinPeriodFrequencyType
   * @return lockinPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getLockinPeriodFrequencyType() {
    return lockinPeriodFrequencyType;
  }


  public void setLockinPeriodFrequencyType(Integer lockinPeriodFrequencyType) {
    this.lockinPeriodFrequencyType = lockinPeriodFrequencyType;
  }

  public ShareAccountData lockinPeriodFrequencyTypeOptions(List<EnumOptionData> lockinPeriodFrequencyTypeOptions) {
    
    this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
    return this;
  }

  public ShareAccountData addLockinPeriodFrequencyTypeOptionsItem(EnumOptionData lockinPeriodFrequencyTypeOptionsItem) {
    if (this.lockinPeriodFrequencyTypeOptions == null) {
      this.lockinPeriodFrequencyTypeOptions = new ArrayList<>();
    }
    this.lockinPeriodFrequencyTypeOptions.add(lockinPeriodFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get lockinPeriodFrequencyTypeOptions
   * @return lockinPeriodFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getLockinPeriodFrequencyTypeOptions() {
    return lockinPeriodFrequencyTypeOptions;
  }


  public void setLockinPeriodFrequencyTypeOptions(List<EnumOptionData> lockinPeriodFrequencyTypeOptions) {
    this.lockinPeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions;
  }

  public ShareAccountData minimumActivePeriod(Integer minimumActivePeriod) {
    
    this.minimumActivePeriod = minimumActivePeriod;
    return this;
  }

  /**
   * Get minimumActivePeriod
   * @return minimumActivePeriod
   */
  @javax.annotation.Nullable

  public Integer getMinimumActivePeriod() {
    return minimumActivePeriod;
  }


  public void setMinimumActivePeriod(Integer minimumActivePeriod) {
    this.minimumActivePeriod = minimumActivePeriod;
  }

  public ShareAccountData minimumActivePeriodFrequencyType(Integer minimumActivePeriodFrequencyType) {
    
    this.minimumActivePeriodFrequencyType = minimumActivePeriodFrequencyType;
    return this;
  }

  /**
   * Get minimumActivePeriodFrequencyType
   * @return minimumActivePeriodFrequencyType
   */
  @javax.annotation.Nullable

  public Integer getMinimumActivePeriodFrequencyType() {
    return minimumActivePeriodFrequencyType;
  }


  public void setMinimumActivePeriodFrequencyType(Integer minimumActivePeriodFrequencyType) {
    this.minimumActivePeriodFrequencyType = minimumActivePeriodFrequencyType;
  }

  public ShareAccountData minimumActivePeriodFrequencyTypeOptions(List<EnumOptionData> minimumActivePeriodFrequencyTypeOptions) {
    
    this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOptions;
    return this;
  }

  public ShareAccountData addMinimumActivePeriodFrequencyTypeOptionsItem(EnumOptionData minimumActivePeriodFrequencyTypeOptionsItem) {
    if (this.minimumActivePeriodFrequencyTypeOptions == null) {
      this.minimumActivePeriodFrequencyTypeOptions = new ArrayList<>();
    }
    this.minimumActivePeriodFrequencyTypeOptions.add(minimumActivePeriodFrequencyTypeOptionsItem);
    return this;
  }

  /**
   * Get minimumActivePeriodFrequencyTypeOptions
   * @return minimumActivePeriodFrequencyTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getMinimumActivePeriodFrequencyTypeOptions() {
    return minimumActivePeriodFrequencyTypeOptions;
  }


  public void setMinimumActivePeriodFrequencyTypeOptions(List<EnumOptionData> minimumActivePeriodFrequencyTypeOptions) {
    this.minimumActivePeriodFrequencyTypeOptions = minimumActivePeriodFrequencyTypeOptions;
  }

  public ShareAccountData minimumActivePeriodTypeEnum(EnumOptionData minimumActivePeriodTypeEnum) {
    
    this.minimumActivePeriodTypeEnum = minimumActivePeriodTypeEnum;
    return this;
  }

  /**
   * Get minimumActivePeriodTypeEnum
   * @return minimumActivePeriodTypeEnum
   */
  @javax.annotation.Nullable

  public EnumOptionData getMinimumActivePeriodTypeEnum() {
    return minimumActivePeriodTypeEnum;
  }


  public void setMinimumActivePeriodTypeEnum(EnumOptionData minimumActivePeriodTypeEnum) {
    this.minimumActivePeriodTypeEnum = minimumActivePeriodTypeEnum;
  }

  public ShareAccountData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public ShareAccountData productName(String productName) {
    
    this.productName = productName;
    return this;
  }

  /**
   * Get productName
   * @return productName
   */
  @javax.annotation.Nullable

  public String getProductName() {
    return productName;
  }


  public void setProductName(String productName) {
    this.productName = productName;
  }

  public ShareAccountData productOptions(List<Object> productOptions) {
    
    this.productOptions = productOptions;
    return this;
  }

  public ShareAccountData addProductOptionsItem(Object productOptionsItem) {
    if (this.productOptions == null) {
      this.productOptions = new ArrayList<>();
    }
    this.productOptions.add(productOptionsItem);
    return this;
  }

  /**
   * Get productOptions
   * @return productOptions
   */
  @javax.annotation.Nullable

  public List<Object> getProductOptions() {
    return productOptions;
  }


  public void setProductOptions(List<Object> productOptions) {
    this.productOptions = productOptions;
  }

  public ShareAccountData purchasedShares(List<ShareAccountTransactionData> purchasedShares) {
    
    this.purchasedShares = purchasedShares;
    return this;
  }

  public ShareAccountData addPurchasedSharesItem(ShareAccountTransactionData purchasedSharesItem) {
    if (this.purchasedShares == null) {
      this.purchasedShares = new ArrayList<>();
    }
    this.purchasedShares.add(purchasedSharesItem);
    return this;
  }

  /**
   * Get purchasedShares
   * @return purchasedShares
   */
  @javax.annotation.Nullable

  public List<ShareAccountTransactionData> getPurchasedShares() {
    return purchasedShares;
  }


  public void setPurchasedShares(List<ShareAccountTransactionData> purchasedShares) {
    this.purchasedShares = purchasedShares;
  }

  public ShareAccountData requestedShares(Integer requestedShares) {
    
    this.requestedShares = requestedShares;
    return this;
  }

  /**
   * Get requestedShares
   * @return requestedShares
   */
  @javax.annotation.Nullable

  public Integer getRequestedShares() {
    return requestedShares;
  }


  public void setRequestedShares(Integer requestedShares) {
    this.requestedShares = requestedShares;
  }

  public ShareAccountData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public ShareAccountData savingsAccountId(Long savingsAccountId) {
    
    this.savingsAccountId = savingsAccountId;
    return this;
  }

  /**
   * Get savingsAccountId
   * @return savingsAccountId
   */
  @javax.annotation.Nullable

  public Long getSavingsAccountId() {
    return savingsAccountId;
  }


  public void setSavingsAccountId(Long savingsAccountId) {
    this.savingsAccountId = savingsAccountId;
  }

  public ShareAccountData savingsAccountNumber(String savingsAccountNumber) {
    
    this.savingsAccountNumber = savingsAccountNumber;
    return this;
  }

  /**
   * Get savingsAccountNumber
   * @return savingsAccountNumber
   */
  @javax.annotation.Nullable

  public String getSavingsAccountNumber() {
    return savingsAccountNumber;
  }


  public void setSavingsAccountNumber(String savingsAccountNumber) {
    this.savingsAccountNumber = savingsAccountNumber;
  }

  public ShareAccountData status(ShareAccountStatusEnumData status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public ShareAccountStatusEnumData getStatus() {
    return status;
  }


  public void setStatus(ShareAccountStatusEnumData status) {
    this.status = status;
  }

  public ShareAccountData submittedDate(LocalDate submittedDate) {
    
    this.submittedDate = submittedDate;
    return this;
  }

  /**
   * Get submittedDate
   * @return submittedDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedDate() {
    return submittedDate;
  }


  public void setSubmittedDate(LocalDate submittedDate) {
    this.submittedDate = submittedDate;
  }

  public ShareAccountData summary(ShareAccountSummaryData summary) {
    
    this.summary = summary;
    return this;
  }

  /**
   * Get summary
   * @return summary
   */
  @javax.annotation.Nullable

  public ShareAccountSummaryData getSummary() {
    return summary;
  }


  public void setSummary(ShareAccountSummaryData summary) {
    this.summary = summary;
  }

  public ShareAccountData timeline(ShareAccountApplicationTimelineData timeline) {
    
    this.timeline = timeline;
    return this;
  }

  /**
   * Get timeline
   * @return timeline
   */
  @javax.annotation.Nullable

  public ShareAccountApplicationTimelineData getTimeline() {
    return timeline;
  }


  public void setTimeline(ShareAccountApplicationTimelineData timeline) {
    this.timeline = timeline;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShareAccountData shareAccountData = (ShareAccountData) o;
    return Objects.equals(this.accountNo, shareAccountData.accountNo) &&
        Objects.equals(this.allowDividendCalculationForInactiveClients, shareAccountData.allowDividendCalculationForInactiveClients) &&
        Objects.equals(this.applicationDate, shareAccountData.applicationDate) &&
        Objects.equals(this.chargeOptions, shareAccountData.chargeOptions) &&
        Objects.equals(this.charges, shareAccountData.charges) &&
        Objects.equals(this.clientId, shareAccountData.clientId) &&
        Objects.equals(this.clientName, shareAccountData.clientName) &&
        Objects.equals(this.clientSavingsAccounts, shareAccountData.clientSavingsAccounts) &&
        Objects.equals(this.currency, shareAccountData.currency) &&
        Objects.equals(this.currentMarketPrice, shareAccountData.currentMarketPrice) &&
        Objects.equals(this.dateFormat, shareAccountData.dateFormat) &&
        Objects.equals(this.defaultShares, shareAccountData.defaultShares) &&
        Objects.equals(this.dividends, shareAccountData.dividends) &&
        Objects.equals(this.externalId, shareAccountData.externalId) &&
        Objects.equals(this.id, shareAccountData.id) &&
        Objects.equals(this.locale, shareAccountData.locale) &&
        Objects.equals(this.lockPeriodTypeEnum, shareAccountData.lockPeriodTypeEnum) &&
        Objects.equals(this.lockinPeriod, shareAccountData.lockinPeriod) &&
        Objects.equals(this.lockinPeriodFrequency, shareAccountData.lockinPeriodFrequency) &&
        Objects.equals(this.lockinPeriodFrequencyType, shareAccountData.lockinPeriodFrequencyType) &&
        Objects.equals(this.lockinPeriodFrequencyTypeOptions, shareAccountData.lockinPeriodFrequencyTypeOptions) &&
        Objects.equals(this.minimumActivePeriod, shareAccountData.minimumActivePeriod) &&
        Objects.equals(this.minimumActivePeriodFrequencyType, shareAccountData.minimumActivePeriodFrequencyType) &&
        Objects.equals(this.minimumActivePeriodFrequencyTypeOptions, shareAccountData.minimumActivePeriodFrequencyTypeOptions) &&
        Objects.equals(this.minimumActivePeriodTypeEnum, shareAccountData.minimumActivePeriodTypeEnum) &&
        Objects.equals(this.productId, shareAccountData.productId) &&
        Objects.equals(this.productName, shareAccountData.productName) &&
        Objects.equals(this.productOptions, shareAccountData.productOptions) &&
        Objects.equals(this.purchasedShares, shareAccountData.purchasedShares) &&
        Objects.equals(this.requestedShares, shareAccountData.requestedShares) &&
        Objects.equals(this.rowIndex, shareAccountData.rowIndex) &&
        Objects.equals(this.savingsAccountId, shareAccountData.savingsAccountId) &&
        Objects.equals(this.savingsAccountNumber, shareAccountData.savingsAccountNumber) &&
        Objects.equals(this.status, shareAccountData.status) &&
        Objects.equals(this.submittedDate, shareAccountData.submittedDate) &&
        Objects.equals(this.summary, shareAccountData.summary) &&
        Objects.equals(this.timeline, shareAccountData.timeline);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNo, allowDividendCalculationForInactiveClients, applicationDate, chargeOptions, charges, clientId, clientName, clientSavingsAccounts, currency, currentMarketPrice, dateFormat, defaultShares, dividends, externalId, id, locale, lockPeriodTypeEnum, lockinPeriod, lockinPeriodFrequency, lockinPeriodFrequencyType, lockinPeriodFrequencyTypeOptions, minimumActivePeriod, minimumActivePeriodFrequencyType, minimumActivePeriodFrequencyTypeOptions, minimumActivePeriodTypeEnum, productId, productName, productOptions, purchasedShares, requestedShares, rowIndex, savingsAccountId, savingsAccountNumber, status, submittedDate, summary, timeline);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShareAccountData {\n");
    sb.append("    accountNo: ").append(toIndentedString(accountNo)).append("\n");
    sb.append("    allowDividendCalculationForInactiveClients: ").append(toIndentedString(allowDividendCalculationForInactiveClients)).append("\n");
    sb.append("    applicationDate: ").append(toIndentedString(applicationDate)).append("\n");
    sb.append("    chargeOptions: ").append(toIndentedString(chargeOptions)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
    sb.append("    clientSavingsAccounts: ").append(toIndentedString(clientSavingsAccounts)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currentMarketPrice: ").append(toIndentedString(currentMarketPrice)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    defaultShares: ").append(toIndentedString(defaultShares)).append("\n");
    sb.append("    dividends: ").append(toIndentedString(dividends)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    lockPeriodTypeEnum: ").append(toIndentedString(lockPeriodTypeEnum)).append("\n");
    sb.append("    lockinPeriod: ").append(toIndentedString(lockinPeriod)).append("\n");
    sb.append("    lockinPeriodFrequency: ").append(toIndentedString(lockinPeriodFrequency)).append("\n");
    sb.append("    lockinPeriodFrequencyType: ").append(toIndentedString(lockinPeriodFrequencyType)).append("\n");
    sb.append("    lockinPeriodFrequencyTypeOptions: ").append(toIndentedString(lockinPeriodFrequencyTypeOptions)).append("\n");
    sb.append("    minimumActivePeriod: ").append(toIndentedString(minimumActivePeriod)).append("\n");
    sb.append("    minimumActivePeriodFrequencyType: ").append(toIndentedString(minimumActivePeriodFrequencyType)).append("\n");
    sb.append("    minimumActivePeriodFrequencyTypeOptions: ").append(toIndentedString(minimumActivePeriodFrequencyTypeOptions)).append("\n");
    sb.append("    minimumActivePeriodTypeEnum: ").append(toIndentedString(minimumActivePeriodTypeEnum)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    productName: ").append(toIndentedString(productName)).append("\n");
    sb.append("    productOptions: ").append(toIndentedString(productOptions)).append("\n");
    sb.append("    purchasedShares: ").append(toIndentedString(purchasedShares)).append("\n");
    sb.append("    requestedShares: ").append(toIndentedString(requestedShares)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    savingsAccountId: ").append(toIndentedString(savingsAccountId)).append("\n");
    sb.append("    savingsAccountNumber: ").append(toIndentedString(savingsAccountNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    submittedDate: ").append(toIndentedString(submittedDate)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    timeline: ").append(toIndentedString(timeline)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

