package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.ProgressiveLoanInterestScheduleModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ProgressiveLoanApi {
    /**
    * Fetch ProgressiveLoanInterestScheduleModel
    * DO NOT USE THIS IN PRODUCTION!
        * @param loanId loanId (required)
    * @return Call&lt;ProgressiveLoanInterestScheduleModel&gt;
    */
    @GET("v1/internal/loan/progressive/{loanId}/model")
    Call<ProgressiveLoanInterestScheduleModel> fetchModel(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Update and Save ProgressiveLoanInterestScheduleModel
    * DO NOT USE THIS IN PRODUCTION!
        * @param loanId loanId (required)
    * @return Call&lt;ProgressiveLoanInterestScheduleModel&gt;
    */
    @POST("v1/internal/loan/progressive/{loanId}/model")
    Call<ProgressiveLoanInterestScheduleModel> updateModel(@retrofit2.http.Path("loanId") Long loanId);



        /**
        * Fetch ProgressiveLoanInterestScheduleModel
        * DO NOT USE THIS IN PRODUCTION!
            * @param loanId loanId (required)
        * @return Call&lt;ProgressiveLoanInterestScheduleModel&gt;
        */
    @GET("v1/internal/loan/progressive/{loanId}/model")
    Call<ProgressiveLoanInterestScheduleModel> fetchModel(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Update and Save ProgressiveLoanInterestScheduleModel
        * DO NOT USE THIS IN PRODUCTION!
            * @param loanId loanId (required)
        * @return Call&lt;ProgressiveLoanInterestScheduleModel&gt;
        */
    @POST("v1/internal/loan/progressive/{loanId}/model")
    Call<ProgressiveLoanInterestScheduleModel> updateModel(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);


}
