/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.lang.reflect.Type;
import java.math.MathContext;
import java.util.ArrayList;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.loanproduct.calc.data.InterestPeriod;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.apache.fineract.portfolio.loanproduct.calc.data.RepaymentPeriod;
import org.apache.fineract.portfolio.loanproduct.domain.ILoanConfigurationDetails;

@Data
@RequiredArgsConstructor
public class InterestScheduleModelServiceGsonContext {

    private final MonetaryCurrency currency;
    private final MathContext mc;
    private final ILoanConfigurationDetails loanProductRelatedDetail;
    private RepaymentPeriod prev = null;
    private final Integer installmentAmountInMultipliesOf;

    public RepaymentPeriod createRepaymentPeriodInstance(Type type) {
        if (type == RepaymentPeriod.class) {

            setPrev(RepaymentPeriod.empty(getPrev(), getMc(), getLoanProductRelatedDetail()));
            return getPrev();
        }
        throw new IllegalArgumentException("Unsupported RepaymentPeriod type: " + type);
    }

    public InterestPeriod createInterestPeriodInstance(Type type) {
        if (type == InterestPeriod.class) {
            return InterestPeriod.empty(getPrev(), getMc());
        }
        throw new IllegalArgumentException("Unsupported InterestPeriod type: " + type);
    }

    public ProgressiveLoanInterestScheduleModel createProgressiveLoanInterestScheduleModelInstance(Type type) {
        if (type == ProgressiveLoanInterestScheduleModel.class) {
            setPrev(null);
            return new ProgressiveLoanInterestScheduleModel(new ArrayList<>(), getLoanProductRelatedDetail(),
                    installmentAmountInMultipliesOf, getMc());
        }
        throw new IllegalArgumentException("Unsupported ProgressiveLoanInterestScheduleModel type: " + type);
    }
}
