/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.socket;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;

public class SocketWindowWordCount {
    public static void main(String[] args) throws Exception {
        int port;
        String hostname;
        try {
            ParameterTool params = ParameterTool.fromArgs((String[])args);
            hostname = params.has("hostname") ? params.get("hostname") : "localhost";
            port = params.getInt("port");
        }
        catch (Exception e) {
            System.err.println("No port specified. Please run 'SocketWindowWordCount --hostname <hostname> --port <port>', where hostname (localhost by default) and port is the address of the text server");
            System.err.println("To start a simple text server, run 'netcat -l <port>' and type the input text into the command line");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource text = env.socketTextStream(hostname, port, "\n");
        SingleOutputStreamOperator windowCounts = text.flatMap((FlatMapFunction & Serializable)(value, out) -> {
            for (String word : value.split("\\s")) {
                out.collect((Object)new WordWithCount(word, 1L));
            }
        }, Types.POJO(WordWithCount.class)).keyBy((KeySelector & Serializable)value -> value.word).window((WindowAssigner)TumblingProcessingTimeWindows.of((Duration)Duration.ofSeconds(5L))).reduce((ReduceFunction & Serializable)(a, b) -> new WordWithCount(a.word, a.count + b.count)).returns(WordWithCount.class);
        windowCounts.print().setParallelism(1);
        env.execute("Socket Window WordCount");
    }

    public static class WordWithCount {
        public String word;
        public long count;

        public WordWithCount() {
        }

        public WordWithCount(String word, long count) {
            this.word = word;
            this.count = count;
        }

        public String toString() {
            return this.word + " : " + this.count;
        }
    }
}

