/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.FlinkSqlCallBinding;

@Internal
public final class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        FlinkSqlCallBinding callBinding = new FlinkSqlCallBinding(this.validator, this.scope, this.call);
        this.validator.deriveTypeImpl(this.scope, callBinding.permutedCall());
        if (!(operator instanceof SqlTableFunction)) {
            throw new IllegalArgumentException("Argument must be a table function: " + operator.getNameAsId());
        }
        if (operator instanceof SqlWindowTableFunction) {
            callBinding.permutedCall().validate(this.validator, this.scope);
        }
        SqlTableFunction tableFunction = (SqlTableFunction)((Object)operator);
        SqlReturnTypeInference rowTypeInference = tableFunction.getRowTypeInference();
        RelDataType rowRelDataType = Objects.requireNonNull(rowTypeInference.inferReturnType(callBinding), () -> "got null from inferReturnType for call " + callBinding.getCall());
        return this.toStruct(rowRelDataType, this.getNode());
    }

    @Override
    protected RelDataType toStruct(RelDataType type, SqlNode unnest) {
        if (type.isStruct()) {
            return this.validator.getTypeFactory().createTypeWithNullability(type, false);
        }
        return this.validator.getTypeFactory().builder().kind(type.getStructKind()).add(this.validator.deriveAlias(unnest, 0), type).build();
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }
}

