/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.MinibatchUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.MiniBatchStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.StreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.StreamingSemiAntiJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-join", version=1, producedTransformations={"join"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String JOIN_TRANSFORMATION = "join";
    public static final String LEFT_STATE_NAME = "leftState";
    public static final String RIGHT_STATE_NAME = "rightState";
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_LEFT_UPSERT_KEYS = "leftUpsertKeys";
    public static final String FIELD_NAME_RIGHT_UPSERT_KEYS = "rightUpsertKeys";
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="leftUpsertKeys")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final List<int[]> leftUpsertKeys;
    @JsonProperty(value="rightUpsertKeys")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final List<int[]> rightUpsertKeys;
    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;

    public StreamExecJoin(ReadableConfig tableConfig, JoinSpec joinSpec, List<int[]> leftUpsertKeys, List<int[]> rightUpsertKeys, InputProperty leftInputProperty, InputProperty rightInputProperty, Map<Integer, Long> stateTtlFromHint, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecJoin.class), ExecNodeContext.newPersistedConfig(StreamExecJoin.class, tableConfig), joinSpec, leftUpsertKeys, rightUpsertKeys, StateMetadata.getMultiInputOperatorDefaultMeta(stateTtlFromHint, tableConfig, LEFT_STATE_NAME, RIGHT_STATE_NAME), Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description);
    }

    @JsonCreator
    public StreamExecJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="leftUpsertKeys") List<int[]> leftUpsertKeys, @JsonProperty(value="rightUpsertKeys") List<int[]> rightUpsertKeys, @Nullable @JsonProperty(value="state") List<StateMetadata> stateMetadataList, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.leftUpsertKeys = leftUpsertKeys;
        this.rightUpsertKeys = rightUpsertKeys;
        this.stateMetadataList = stateMetadataList;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Object operator;
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        JoinUtil.validateJoinSpec(this.joinSpec, leftType, rightType, true);
        int[] leftJoinKey = this.joinSpec.getLeftKeys();
        int[] rightJoinKey = this.joinSpec.getRightKeys();
        InternalTypeInfo leftTypeInfo = InternalTypeInfo.of((RowType)leftType);
        JoinInputSideSpec leftInputSpec = JoinUtil.analyzeJoinInput(planner.getFlinkContext().getClassLoader(), (InternalTypeInfo<RowData>)leftTypeInfo, leftJoinKey, this.leftUpsertKeys);
        InternalTypeInfo rightTypeInfo = InternalTypeInfo.of((RowType)rightType);
        JoinInputSideSpec rightInputSpec = JoinUtil.analyzeJoinInput(planner.getFlinkContext().getClassLoader(), (InternalTypeInfo<RowData>)rightTypeInfo, rightJoinKey, this.rightUpsertKeys);
        GeneratedJoinCondition generatedCondition = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.joinSpec, (LogicalType)leftType, (LogicalType)rightType);
        List<Long> leftAndRightStateRetentionTime = StateMetadata.getStateTtlForMultiInputOperator(config, 2, this.stateMetadataList);
        long leftStateRetentionTime = leftAndRightStateRetentionTime.get(0);
        long rightStateRetentionTime = leftAndRightStateRetentionTime.get(1);
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        boolean isMiniBatchEnabled = MinibatchUtil.isMiniBatchEnabled(config);
        if (joinType == FlinkJoinType.ANTI || joinType == FlinkJoinType.SEMI) {
            operator = new StreamingSemiAntiJoinOperator(joinType == FlinkJoinType.ANTI, leftTypeInfo, rightTypeInfo, generatedCondition, leftInputSpec, rightInputSpec, this.joinSpec.getFilterNulls(), leftStateRetentionTime, rightStateRetentionTime);
        } else {
            boolean leftIsOuter = joinType == FlinkJoinType.LEFT || joinType == FlinkJoinType.FULL;
            boolean rightIsOuter = joinType == FlinkJoinType.RIGHT || joinType == FlinkJoinType.FULL;
            operator = isMiniBatchEnabled ? MiniBatchStreamingJoinOperator.newMiniBatchStreamJoinOperator((FlinkJoinType)joinType, (InternalTypeInfo)leftTypeInfo, (InternalTypeInfo)rightTypeInfo, (GeneratedJoinCondition)generatedCondition, (JoinInputSideSpec)leftInputSpec, (JoinInputSideSpec)rightInputSpec, (boolean)leftIsOuter, (boolean)rightIsOuter, (boolean[])this.joinSpec.getFilterNulls(), (long)leftStateRetentionTime, (long)rightStateRetentionTime, MinibatchUtil.createMiniBatchCoTrigger(config)) : new StreamingJoinOperator(leftTypeInfo, rightTypeInfo, generatedCondition, leftInputSpec, rightInputSpec, leftIsOuter, rightIsOuter, this.joinSpec.getFilterNulls(), leftStateRetentionTime, rightStateRetentionTime);
        }
        RowType returnType = (RowType)this.getOutputType();
        TwoInputTransformation transform = ExecNodeUtil.createTwoInputTransformation(leftTransform, rightTransform, this.createTransformationMeta(JOIN_TRANSFORMATION, config), operator, InternalTypeInfo.of((RowType)returnType), leftTransform.getParallelism(), false);
        RowDataKeySelector leftSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), leftJoinKey, (InternalTypeInfo<RowData>)leftTypeInfo);
        RowDataKeySelector rightSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), rightJoinKey, (InternalTypeInfo<RowData>)rightTypeInfo);
        transform.setStateKeySelectors((KeySelector)leftSelect, (KeySelector)rightSelect);
        transform.setStateKeyType((TypeInformation)leftSelect.getProducedType());
        return transform;
    }
}

