/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.BaseMappingExtractor;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;

@Internal
final class ProcedureMappingExtractor
extends BaseMappingExtractor {
    private final Class<? extends Procedure> procedure;

    ProcedureMappingExtractor(DataTypeFactory typeFactory, Class<? extends Procedure> procedure, String methodName, BaseMappingExtractor.SignatureExtraction signatureExtraction, BaseMappingExtractor.ResultExtraction outputExtraction, BaseMappingExtractor.MethodVerification verification) {
        super(typeFactory, methodName, signatureExtraction, outputExtraction, verification);
        this.procedure = procedure;
    }

    @Override
    protected Set<FunctionTemplate> extractGlobalFunctionTemplates() {
        return TemplateUtils.extractProcedureGlobalFunctionTemplates(this.typeFactory, this.procedure);
    }

    @Override
    protected Set<FunctionTemplate> extractLocalFunctionTemplates(Method method) {
        return TemplateUtils.extractProcedureLocalFunctionTemplates(this.typeFactory, method);
    }

    @Override
    protected List<Method> collectMethods(String methodName) {
        return ExtractionUtils.collectMethods(this.procedure, methodName);
    }

    @Override
    protected Class<?> getFunctionClass() {
        return this.procedure;
    }

    @Override
    protected String getHintType() {
        return "Procedure";
    }

    static BaseMappingExtractor.ResultExtraction createReturnTypeResultExtraction() {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromMethodOutput(extractor.typeFactory, extractor.getFunctionClass(), method, method.getReturnType().getComponentType());
            return FunctionResultTemplate.of(dataType);
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterAndReturnTypeVerification() {
        return (method, signature, result) -> {
            boolean isValid;
            Class[] parameters = (Class[])Stream.concat(Stream.of((Class)null), signature.stream()).toArray(Class[]::new);
            Class<?> returnType = method.getReturnType();
            boolean bl = isValid = ExtractionUtils.isInvokable(method, parameters) && returnType.isArray() && ExtractionUtils.isAssignable(result, returnType.getComponentType(), true);
            if (!isValid) {
                throw ProcedureMappingExtractor.createMethodNotFoundError(method.getName(), parameters, Array.newInstance(result, 0).getClass());
            }
        };
    }
}

