/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap();

    private static final void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className, false, ClassUtils.class.getClassLoader());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isAssignableOrConvertibleFrom(Class<?> clazz, Class<?> type) {
        if (type == null || clazz == null) {
            return false;
        }
        if (type.isPrimitive()) {
            Class<?> primitiveClass = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(type);
            if (primitiveClass == null) {
                return false;
            }
            return clazz.isAssignableFrom(primitiveClass);
        }
        if (type.isArray() && Iterable.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean getBooleanFromMap(String key, Map<?, ?> map) {
        if (map == null) {
            return false;
        }
        if (map.containsKey(key)) {
            Object o = map.get(key);
            if (o == null) {
                return false;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return false;
    }

    public static boolean isClassBelowPackage(Class<?> domainClazz, List packageList) {
        String classPackage = domainClazz.getPackage().getName();
        for (Object packageName : packageList) {
            if (packageName == null || !classPackage.startsWith(packageName.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultiTenant(Class clazz) {
        Class<?>[] allInterfacesForClass;
        for (Class<?> anInterface : allInterfacesForClass = org.springframework.util.ClassUtils.getAllInterfacesForClass(clazz)) {
            if (!anInterface.getSimpleName().equals("MultiTenant")) continue;
            return true;
        }
        return false;
    }

    static {
        ClassUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        ClassUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        ClassUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        ClassUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        ClassUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        ClassUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        ClassUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        ClassUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

