# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from mcp_server.client.factory import RESTClientFactory
from mcp_server.core.setting import Setting


class GravitinoContext:
    def __init__(self, setting: Setting):
        self.gravitino_client = RESTClientFactory.create_rest_client(
            setting.metalake, setting.gravitino_uri
        )

    def rest_client(self):
        return self.gravitino_client
