/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.S3FileIOAwsClientFactories;
import org.apache.iceberg.aws.s3.AnalyticsAcceleratorUtil;
import org.apache.iceberg.aws.s3.S3FileIOAwsClientFactory;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.CredentialSupplier;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.StorageCredential;
import org.apache.iceberg.io.SupportsRecoveryOperations;
import org.apache.iceberg.io.SupportsStorageCredentials;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.SetMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;

public class S3FileIO
implements CredentialSupplier,
DelegateFileIO,
SupportsRecoveryOperations,
SupportsStorageCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private static volatile ExecutorService executorService;
    private String credential = null;
    private SerializableSupplier<S3Client> s3;
    private SerializableSupplier<S3AsyncClient> s3Async;
    private S3FileIOProperties s3FileIOProperties;
    private SerializableMap<String, String> properties = null;
    private volatile transient S3Client client;
    private volatile transient S3AsyncClient asyncClient;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);
    private transient StackTraceElement[] createStack;
    private List<StorageCredential> storageCredentials = ImmutableList.of();

    public S3FileIO() {
    }

    public S3FileIO(SerializableSupplier<S3Client> s3) {
        this(s3, null, new S3FileIOProperties());
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, SerializableSupplier<S3AsyncClient> s3Async) {
        this(s3, s3Async, new S3FileIOProperties());
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, S3FileIOProperties s3FileIOProperties) {
        this(s3, null, s3FileIOProperties);
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, SerializableSupplier<S3AsyncClient> s3Async, S3FileIOProperties s3FileIOProperties) {
        this.s3 = s3;
        this.s3Async = s3Async;
        this.s3FileIOProperties = s3FileIOProperties;
        this.createStack = Thread.currentThread().getStackTrace();
    }

    public InputFile newInputFile(String path) {
        if (this.shouldUseAsyncClient()) {
            return S3InputFile.fromLocation(path, this.client(), this.asyncClient(), this.s3FileIOProperties, this.metrics);
        }
        return S3InputFile.fromLocation(path, this.client(), this.s3FileIOProperties, this.metrics);
    }

    public InputFile newInputFile(String path, long length) {
        if (this.shouldUseAsyncClient()) {
            return S3InputFile.fromLocation(path, length, this.client(), this.asyncClient(), this.s3FileIOProperties, this.metrics);
        }
        return S3InputFile.fromLocation(path, length, this.client(), this.s3FileIOProperties, this.metrics);
    }

    public OutputFile newOutputFile(String path) {
        if (this.shouldUseAsyncClient()) {
            return S3OutputFile.fromLocation(path, this.client(), this.asyncClient(), this.s3FileIOProperties, this.metrics);
        }
        return S3OutputFile.fromLocation(path, this.client(), this.s3FileIOProperties, this.metrics);
    }

    public void deleteFile(String path) {
        if (this.s3FileIOProperties.deleteTags() != null && !this.s3FileIOProperties.deleteTags().isEmpty()) {
            try {
                this.tagFileToDelete(path, this.s3FileIOProperties.deleteTags());
            }
            catch (S3Exception e) {
                LOG.warn("Failed to add delete tags: {} to {}", new Object[]{this.s3FileIOProperties.deleteTags(), path, e});
            }
        }
        if (!this.s3FileIOProperties.isDeleteEnabled()) {
            return;
        }
        S3URI location = new S3URI(path, this.s3FileIOProperties.bucketToAccessPointMapping());
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(location.bucket()).key(location.key()).build();
        this.client().deleteObject(deleteRequest);
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public void deleteFiles(Iterable<String> paths) throws BulkDeletionFailureException {
        if (this.s3FileIOProperties.deleteTags() != null && !this.s3FileIOProperties.deleteTags().isEmpty()) {
            Tasks.foreach(paths).noRetry().executeWith(this.executorService()).suppressFailureWhenFinished().onFailure((path, exc) -> LOG.warn("Failed to add delete tags: {} to {}", new Object[]{this.s3FileIOProperties.deleteTags(), path, exc})).run(path -> this.tagFileToDelete((String)path, this.s3FileIOProperties.deleteTags()));
        }
        if (this.s3FileIOProperties.isDeleteEnabled()) {
            SetMultimap bucketToObjects = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);
            ArrayList deletionTasks = Lists.newArrayList();
            for (String string : paths) {
                S3URI location = new S3URI(string, this.s3FileIOProperties.bucketToAccessPointMapping());
                String bucket = location.bucket();
                String objectKey = location.key();
                bucketToObjects.get((Object)bucket).add(objectKey);
                if (bucketToObjects.get((Object)bucket).size() != this.s3FileIOProperties.deleteBatchSize()) continue;
                HashSet keys = Sets.newHashSet((Iterable)bucketToObjects.get((Object)bucket));
                Future<List> deletionTask = this.executorService().submit(() -> this.deleteBatch(bucket, keys));
                deletionTasks.add(deletionTask);
                bucketToObjects.removeAll((Object)bucket);
            }
            for (Map.Entry entry : bucketToObjects.asMap().entrySet()) {
                String bucket = (String)entry.getKey();
                Collection keys = (Collection)entry.getValue();
                Future<List> deletionTask = this.executorService().submit(() -> this.deleteBatch(bucket, keys));
                deletionTasks.add(deletionTask);
            }
            int totalFailedDeletions = 0;
            for (Future deletionTask : deletionTasks) {
                try {
                    List failedDeletions = (List)deletionTask.get();
                    failedDeletions.forEach(path -> LOG.warn("Failed to delete object at path {}", path));
                    totalFailedDeletions += failedDeletions.size();
                }
                catch (ExecutionException e) {
                    LOG.warn("Caught unexpected exception during batch deletion: ", e.getCause());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    deletionTasks.stream().filter(task -> !task.isDone()).forEach(task -> task.cancel(true));
                    throw new RuntimeException("Interrupted when waiting for deletions to complete", e);
                }
            }
            if (totalFailedDeletions > 0) {
                throw new BulkDeletionFailureException(totalFailedDeletions);
            }
        }
    }

    private void tagFileToDelete(String path, Set<Tag> deleteTags) throws S3Exception {
        S3URI location = new S3URI(path, this.s3FileIOProperties.bucketToAccessPointMapping());
        String bucket = location.bucket();
        String objectKey = location.key();
        GetObjectTaggingRequest getObjectTaggingRequest = (GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(bucket).key(objectKey).build();
        GetObjectTaggingResponse getObjectTaggingResponse = this.client().getObjectTagging(getObjectTaggingRequest);
        HashSet tags = Sets.newHashSet();
        if (getObjectTaggingResponse.hasTagSet()) {
            tags.addAll(getObjectTaggingResponse.tagSet());
        }
        tags.addAll(deleteTags);
        PutObjectTaggingRequest putObjectTaggingRequest = (PutObjectTaggingRequest)PutObjectTaggingRequest.builder().bucket(bucket).key(objectKey).tagging((Tagging)Tagging.builder().tagSet((Collection)tags).build()).build();
        this.client().putObjectTagging(putObjectTaggingRequest);
    }

    private List<String> deleteBatch(String bucket, Collection<String> keysToDelete) {
        List objectIds = keysToDelete.stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).collect(Collectors.toList());
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects(objectIds).build()).build();
        ArrayList failures = Lists.newArrayList();
        try {
            DeleteObjectsResponse response = this.client().deleteObjects(request);
            if (response.hasErrors()) {
                failures.addAll(response.errors().stream().map(error -> String.format("s3://%s/%s", request.bucket(), error.key())).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            LOG.warn("Encountered failure when deleting batch", (Throwable)e);
            failures.addAll(request.delete().objects().stream().map(obj -> String.format("s3://%s/%s", request.bucket(), obj.key())).collect(Collectors.toList()));
        }
        return failures;
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        S3URI uri = new S3URI(prefix, this.s3FileIOProperties.bucketToAccessPointMapping());
        if (uri.useS3DirectoryBucket() && this.s3FileIOProperties.isS3DirectoryBucketListPrefixAsDirectory()) {
            uri = uri.toDirectoryPath();
        }
        S3URI s3uri = uri;
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(s3uri.bucket()).prefix(s3uri.key()).build();
        return () -> this.client().listObjectsV2Paginator(request).stream().flatMap(r -> r.contents().stream()).map(o -> new FileInfo(String.format("%s://%s/%s", s3uri.scheme(), s3uri.bucket(), o.key()), o.size().longValue(), o.lastModified().toEpochMilli())).iterator();
    }

    public void deletePrefix(String prefix) {
        this.deleteFiles(() -> Streams.stream(this.listPrefix(prefix)).map(FileInfo::location).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Client client() {
        if (this.client == null) {
            S3FileIO s3FileIO = this;
            synchronized (s3FileIO) {
                if (this.client == null) {
                    this.client = (S3Client)this.s3.get();
                }
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3AsyncClient asyncClient() {
        if (this.asyncClient == null) {
            S3FileIO s3FileIO = this;
            synchronized (s3FileIO) {
                if (this.asyncClient == null) {
                    this.asyncClient = (S3AsyncClient)this.s3Async.get();
                }
            }
        }
        return this.asyncClient;
    }

    private boolean shouldUseAsyncClient() {
        return this.s3FileIOProperties.isS3AnalyticsAcceleratorEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService executorService() {
        if (executorService != null) return executorService;
        Class<S3FileIO> clazz = S3FileIO.class;
        synchronized (S3FileIO.class) {
            if (executorService != null) return executorService;
            executorService = ThreadPools.newExitingWorkerPool((String)"iceberg-s3fileio-delete", (int)this.s3FileIOProperties.deleteThreads());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public void initialize(Map<String, String> props) {
        Object clientFactory;
        this.properties = SerializableMap.copyOf(props);
        ImmutableMap propertiesWithCredentials = ImmutableMap.builder().putAll(this.properties).putAll(this.storageCredentialConfig()).buildKeepingLast();
        this.s3FileIOProperties = new S3FileIOProperties((Map<String, String>)propertiesWithCredentials);
        StackTraceElement[] stackTraceElementArray = this.createStack = PropertyUtil.propertyAsBoolean(props, (String)"init-creation-stacktrace", (boolean)true) ? Thread.currentThread().getStackTrace() : null;
        if (this.s3 == null) {
            clientFactory = S3FileIOAwsClientFactories.initialize(props);
            if (clientFactory instanceof S3FileIOAwsClientFactory) {
                this.s3 = ((S3FileIOAwsClientFactory)clientFactory)::s3;
            }
            if (clientFactory instanceof AwsClientFactory) {
                this.s3 = ((AwsClientFactory)clientFactory)::s3;
            }
            if (clientFactory instanceof CredentialSupplier) {
                this.credential = ((CredentialSupplier)clientFactory).getCredential();
            }
            if (this.s3FileIOProperties.isPreloadClientEnabled()) {
                this.client();
            }
        }
        if (this.s3Async == null) {
            clientFactory = S3FileIOAwsClientFactories.initialize(props);
            if (clientFactory instanceof S3FileIOAwsClientFactory) {
                this.s3Async = ((S3FileIOAwsClientFactory)clientFactory)::s3Async;
            }
            if (clientFactory instanceof AwsClientFactory) {
                this.s3Async = ((AwsClientFactory)clientFactory)::s3Async;
            }
        }
        this.initMetrics((Map<String, String>)this.properties);
    }

    private void initMetrics(Map<String, String> props) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, new Class[]{String.class}).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance(new Object[]{"s3"});
            context.initialize(props);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true)) {
            if (this.client != null) {
                this.client.close();
            }
            if (this.asyncClient != null) {
                AnalyticsAcceleratorUtil.cleanupCache(this.asyncClient, this.s3FileIOProperties);
                this.asyncClient.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isResourceClosed.get()) {
            this.close();
            if (null != this.createStack) {
                String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed S3FileIO instance created by:\n\t{}", (Object)trace);
            }
        }
    }

    public boolean recoverFile(String path) {
        S3URI location = new S3URI(path, this.s3FileIOProperties.bucketToAccessPointMapping());
        ListObjectVersionsIterable response = this.client().listObjectVersionsPaginator(builder -> builder.bucket(location.bucket()).prefix(location.key()));
        Optional<ObjectVersion> recoverVersion = response.versions().stream().max(Comparator.comparing(ObjectVersion::lastModified));
        return recoverVersion.map(version -> this.recoverObject((ObjectVersion)version, location.bucket())).orElse(false);
    }

    private boolean recoverObject(ObjectVersion version, String bucket) {
        if (version.isLatest().booleanValue()) {
            return true;
        }
        LOG.info("Attempting to recover object {}", (Object)version.key());
        try {
            this.client().copyObject(builder -> builder.sourceBucket(bucket).sourceKey(version.key()).sourceVersionId(version.versionId()).destinationBucket(bucket).destinationKey(version.key()));
        }
        catch (SdkException e) {
            LOG.warn("Failed to recover object {}", (Object)version.key(), (Object)e);
            return false;
        }
        return true;
    }

    public void setCredentials(List<StorageCredential> credentials) {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"Invalid storage credentials: null");
        this.storageCredentials = Lists.newArrayList(credentials);
    }

    public List<StorageCredential> credentials() {
        return ImmutableList.copyOf(this.storageCredentials);
    }

    private Map<String, String> storageCredentialConfig() {
        List s3Credentials = this.storageCredentials.stream().filter(c -> c.prefix().startsWith("s3")).collect(Collectors.toList());
        Preconditions.checkState((s3Credentials.size() <= 1 ? 1 : 0) != 0, (Object)"Invalid S3 Credentials: only one S3 credential should exist");
        return s3Credentials.isEmpty() ? Map.of() : ((StorageCredential)s3Credentials.get(0)).config();
    }
}

