/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class JournalInfo {
    private final int layoutVersion;
    private final String clusterId;
    private final int namespaceId;

    public JournalInfo(int lv, String clusterId, int nsId) {
        this.layoutVersion = lv;
        this.clusterId = clusterId;
        this.namespaceId = nsId;
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public int getNamespaceId() {
        return this.namespaceId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lv=").append(this.layoutVersion).append(";cid=").append(this.clusterId).append(";nsid=").append(this.namespaceId);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JournalInfo)) {
            return false;
        }
        JournalInfo jInfo = (JournalInfo)o;
        return jInfo.clusterId.equals(this.clusterId) && jInfo.namespaceId == this.namespaceId && jInfo.layoutVersion == this.layoutVersion;
    }

    public int hashCode() {
        return this.namespaceId ^ this.layoutVersion ^ this.clusterId.hashCode();
    }
}

