/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionedWritable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Permission
extends VersionedWritable {
    protected static final byte VERSION = 0;
    private static final Log LOG = LogFactory.getLog(Permission.class);
    protected static final Map<Byte, Action> ACTION_BY_CODE = Maps.newHashMap();
    protected Action[] actions;

    public Permission() {
    }

    public Permission(Action ... assigned) {
        if (assigned != null && assigned.length > 0) {
            this.actions = Arrays.copyOf(assigned, assigned.length);
        }
    }

    public Permission(byte[] actionCodes) {
        if (actionCodes != null) {
            Action[] acts = new Action[actionCodes.length];
            int j = 0;
            for (int i = 0; i < actionCodes.length; ++i) {
                byte b = actionCodes[i];
                Action a = ACTION_BY_CODE.get(b);
                if (a == null) {
                    LOG.error((Object)("Ignoring unknown action code '" + Bytes.toStringBinary((byte[])new byte[]{b}) + "'"));
                    continue;
                }
                acts[j++] = a;
            }
            this.actions = Arrays.copyOf(acts, j);
        }
    }

    public Action[] getActions() {
        return this.actions;
    }

    public boolean implies(Action action) {
        if (this.actions != null) {
            for (Action a : this.actions) {
                if (a != action) continue;
                return true;
            }
        }
        return false;
    }

    public void setActions(Action[] assigned) {
        if (assigned != null && assigned.length > 0) {
            this.actions = Arrays.copyOf(assigned, assigned.length);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)((Object)obj);
        if (this.actions == null && other.getActions() == null) {
            return true;
        }
        if (this.actions != null && other.getActions() != null) {
            Action[] otherActions = other.getActions();
            if (this.actions.length != otherActions.length) {
                return false;
            }
            block0: for (Action a : this.actions) {
                for (Action oa : otherActions) {
                    if (a == oa) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 37;
        int result = 23;
        for (Action a : this.actions) {
            result = 37 * result + a.code();
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[Permission: ").append("actions=");
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                if (this.actions[i] != null) {
                    str.append(this.actions[i].toString());
                    continue;
                }
                str.append("NULL");
            }
        }
        str.append("]");
        return str.toString();
    }

    public byte getVersion() {
        return 0;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int length = in.readByte();
        if (length > 0) {
            this.actions = new Action[length];
            for (int i = 0; i < length; ++i) {
                byte b = in.readByte();
                Action a = ACTION_BY_CODE.get(b);
                if (a == null) {
                    throw new IOException("Unknown action code '" + Bytes.toStringBinary((byte[])new byte[]{b}) + "' in input");
                }
                this.actions[i] = a;
            }
        } else {
            this.actions = new Action[0];
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeByte(this.actions != null ? this.actions.length : 0);
        if (this.actions != null) {
            for (Action a : this.actions) {
                out.writeByte(a.code());
            }
        }
    }

    static {
        for (Action a : Action.values()) {
            ACTION_BY_CODE.put(a.code(), a);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Action {
        READ('R'),
        WRITE('W'),
        EXEC('X'),
        CREATE('C'),
        ADMIN('A');

        private final byte code;

        private Action(char code) {
            this.code = (byte)code;
        }

        public byte code() {
            return this.code;
        }
    }
}

