/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TeraScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(TeraScheduler.class);
    private Split[] splits;
    private List<Host> hosts = new ArrayList<Host>();
    private int slotsPerHost;
    private int remainingSplits = 0;
    private FileSplit[] realSplits = null;

    List<String> readFile(String filename) throws IOException {
        ArrayList<String> result = new ArrayList<String>(10000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charsets.UTF_8));){
            String line = in.readLine();
            while (line != null) {
                result.add(line);
                line = in.readLine();
            }
        }
        return result;
    }

    public TeraScheduler(String splitFilename, String nodeFilename) throws IOException {
        this.slotsPerHost = 4;
        HashMap<String, Host> hostIds = new HashMap<String, Host>();
        for (String hostName : this.readFile(nodeFilename)) {
            Host host = new Host(hostName);
            this.hosts.add(host);
            hostIds.put(hostName, host);
        }
        List<String> splitLines = this.readFile(splitFilename);
        this.splits = new Split[splitLines.size()];
        this.remainingSplits = 0;
        for (String line : splitLines) {
            StringTokenizer itr = new StringTokenizer(line);
            Split newSplit = new Split(itr.nextToken());
            this.splits[this.remainingSplits++] = newSplit;
            while (itr.hasMoreTokens()) {
                Host host = (Host)hostIds.get(itr.nextToken());
                newSplit.locations.add(host);
                host.splits.add(newSplit);
            }
        }
    }

    public TeraScheduler(FileSplit[] realSplits, Configuration conf) throws IOException {
        this.realSplits = realSplits;
        this.slotsPerHost = conf.getInt("mapreduce.tasktracker.map.tasks.maximum", 4);
        HashMap<String, Host> hostTable = new HashMap<String, Host>();
        this.splits = new Split[realSplits.length];
        for (FileSplit realSplit : realSplits) {
            Split split = new Split(realSplit.getPath().toString());
            this.splits[this.remainingSplits++] = split;
            for (String hostname : realSplit.getLocations()) {
                Host host = (Host)hostTable.get(hostname);
                if (host == null) {
                    host = new Host(hostname);
                    hostTable.put(hostname, host);
                    this.hosts.add(host);
                }
                host.splits.add(split);
                split.locations.add(host);
            }
        }
    }

    Host pickBestHost() {
        Host result = null;
        int splits = Integer.MAX_VALUE;
        for (Host host : this.hosts) {
            if (host.splits.size() >= splits) continue;
            result = host;
            splits = host.splits.size();
        }
        if (result != null) {
            this.hosts.remove(result);
            LOG.debug("picking " + result);
        }
        return result;
    }

    void pickBestSplits(Host host) {
        int tasksToPick = Math.min(this.slotsPerHost, (int)Math.ceil((double)this.remainingSplits / (double)this.hosts.size()));
        Split[] best = new Split[tasksToPick];
        for (Split cur : host.splits) {
            int i;
            LOG.debug("  examine: " + cur.filename + " " + cur.locations.size());
            for (i = 0; i < tasksToPick && best[i] != null && best[i].locations.size() <= cur.locations.size(); ++i) {
            }
            if (i >= tasksToPick) continue;
            for (int j = tasksToPick - 1; j > i; --j) {
                best[j] = best[j - 1];
            }
            best[i] = cur;
        }
        for (int i = 0; i < tasksToPick; ++i) {
            if (best[i] == null) continue;
            LOG.debug(" best: " + best[i].filename);
            for (Host other : best[i].locations) {
                other.splits.remove(best[i]);
            }
            best[i].locations.clear();
            best[i].locations.add(host);
            best[i].isAssigned = true;
            --this.remainingSplits;
        }
        for (Split cur : host.splits) {
            if (cur.isAssigned) continue;
            cur.locations.remove(host);
        }
    }

    void solve() throws IOException {
        Host host = this.pickBestHost();
        while (host != null) {
            this.pickBestSplits(host);
            host = this.pickBestHost();
        }
    }

    public List<InputSplit> getNewFileSplits() throws IOException {
        this.solve();
        FileSplit[] result = new FileSplit[this.realSplits.length];
        int left = 0;
        int right = this.realSplits.length - 1;
        for (int i = 0; i < this.splits.length; ++i) {
            if (this.splits[i].isAssigned) {
                String[] newLocations = new String[]{this.splits[i].locations.get((int)0).hostname};
                this.realSplits[i] = new FileSplit(this.realSplits[i].getPath(), this.realSplits[i].getStart(), this.realSplits[i].getLength(), newLocations);
                result[left++] = this.realSplits[i];
                continue;
            }
            result[right--] = this.realSplits[i];
        }
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>();
        for (FileSplit fs : result) {
            ret.add((InputSplit)fs);
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        TeraScheduler problem = new TeraScheduler("block-loc.txt", "nodes");
        for (Host host : problem.hosts) {
            System.out.println(host);
        }
        LOG.info("starting solve");
        problem.solve();
        ArrayList<Split> leftOvers = new ArrayList<Split>();
        for (int i = 0; i < problem.splits.length; ++i) {
            if (problem.splits[i].isAssigned) {
                System.out.println("sched: " + problem.splits[i]);
                continue;
            }
            leftOvers.add(problem.splits[i]);
        }
        for (Split cur : leftOvers) {
            System.out.println("left: " + cur);
        }
        System.out.println("left over: " + leftOvers.size());
        LOG.info("done");
    }

    static class Host {
        String hostname;
        List<Split> splits = new ArrayList<Split>();

        Host(String hostname) {
            this.hostname = hostname;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.splits.size());
            result.append(" ");
            result.append(this.hostname);
            return result.toString();
        }
    }

    static class Split {
        String filename;
        boolean isAssigned = false;
        List<Host> locations = new ArrayList<Host>();

        Split(String filename) {
            this.filename = filename;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.filename);
            result.append(" on ");
            for (Host host : this.locations) {
                result.append(host.hostname);
                result.append(", ");
            }
            return result.toString();
        }
    }
}

