/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.contract.hdfs.HDFSContract;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.junit.Assert;

public class RouterHDFSContract
extends HDFSContract {
    public static final int BLOCK_SIZE = 1024;
    private static MiniRouterDFSCluster cluster;

    public RouterHDFSContract(Configuration conf) {
        super(conf);
    }

    public static void createCluster() throws IOException {
        try {
            cluster = new MiniRouterDFSCluster(true, 2);
            cluster.startCluster();
            cluster.startRouters();
            cluster.registerNamenodes();
            cluster.waitNamenodeRegistration();
            cluster.installMockLocations();
            if (cluster.isHighAvailability()) {
                for (String ns : cluster.getNameservices()) {
                    cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                    cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
                }
            }
            cluster.waitActiveNamespaces();
        }
        catch (Exception e) {
            RouterHDFSContract.destroyCluster();
            throw new IOException("Cannot start federated cluster", e);
        }
    }

    public static void destroyCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    public static MiniDFSCluster getCluster() {
        return cluster.getCluster();
    }

    public static FileSystem getFileSystem() throws IOException {
        Assert.assertNotNull((String)"cluster not created", (Object)cluster);
        return cluster.getRandomRouter().getFileSystem();
    }

    public FileSystem getTestFileSystem() throws IOException {
        return RouterHDFSContract.getFileSystem();
    }
}

