/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterPermissionChecker;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MountTableStoreImpl
extends MountTableStore {
    public MountTableStoreImpl(StateStoreDriver driver) {
        super(driver);
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        RouterPermissionChecker pc;
        MountTable mountTable = request.getEntry();
        if (mountTable != null && (pc = RouterAdminServer.getPermissionChecker()) != null) {
            pc.checkPermission(mountTable, FsAction.WRITE);
        }
        boolean status = this.getDriver().put(mountTable, false, true);
        AddMountTableEntryResponse response = AddMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        RouterPermissionChecker pc;
        MountTable mountTable = request.getEntry();
        if (mountTable != null && (pc = RouterAdminServer.getPermissionChecker()) != null) {
            pc.checkPermission(mountTable, FsAction.WRITE);
        }
        boolean status = this.getDriver().put(mountTable, true, true);
        UpdateMountTableEntryResponse response = UpdateMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        String srcPath = request.getSrcPath();
        MountTable partial = MountTable.newInstance();
        partial.setSourcePath(srcPath);
        Query<MountTable> query = new Query<MountTable>(partial);
        MountTable deleteEntry = this.getDriver().get(this.getRecordClass(), query);
        boolean status = false;
        if (deleteEntry != null) {
            RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
            if (pc != null) {
                pc.checkPermission(deleteEntry, FsAction.WRITE);
            }
            status = this.getDriver().remove(deleteEntry);
        }
        RemoveMountTableEntryResponse response = RemoveMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
        List<MountTable> records = this.getCachedRecords();
        Collections.sort(records, MountTable.SOURCE_COMPARATOR);
        String reqSrcPath = request.getSrcPath();
        if (reqSrcPath != null && !reqSrcPath.isEmpty()) {
            Iterator it = records.iterator();
            while (it.hasNext()) {
                MountTable record = (MountTable)it.next();
                String srcPath = record.getSourcePath();
                if (!srcPath.startsWith(reqSrcPath)) {
                    it.remove();
                    continue;
                }
                if (pc == null) continue;
                try {
                    pc.checkPermission(record, FsAction.READ);
                }
                catch (AccessControlException ignored) {
                    it.remove();
                }
            }
        }
        GetMountTableEntriesResponse response = GetMountTableEntriesResponse.newInstance();
        response.setEntries(records);
        response.setTimestamp(Time.now());
        return response;
    }
}

