/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.AbstractDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class RowIndexSeekerV1
extends AbstractDataBlockEncoder.AbstractEncodedSeeker {
    private ByteBuffer currentBuffer;
    private SeekerState current = new SeekerState();
    private SeekerState previous = new SeekerState();
    private int rowNumber;
    private ByteBuffer rowOffsets = null;

    public RowIndexSeekerV1(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        super(comparator, decodingCtx);
    }

    @Override
    public void setCurrentBuffer(ByteBuffer buffer) {
        int onDiskSize = Bytes.toIntUnsafe(buffer.array(), buffer.arrayOffset() + buffer.limit() - 4);
        ByteBuffer dup = buffer.duplicate();
        dup.position(buffer.position());
        dup.limit(buffer.position() + onDiskSize);
        this.current.currentBuffer = this.currentBuffer = dup.slice();
        ByteBufferUtils.skip(buffer, onDiskSize);
        this.rowNumber = buffer.getInt();
        int totalRowOffsetsLength = this.rowNumber << 2;
        ByteBuffer rowDup = buffer.duplicate();
        rowDup.position(buffer.position());
        rowDup.limit(buffer.position() + totalRowOffsetsLength);
        this.rowOffsets = rowDup.slice();
        this.decodeFirst();
    }

    @Override
    public ByteBuffer getKeyDeepCopy() {
        ByteBuffer keyBuffer = ByteBuffer.allocate(this.current.keyLength);
        keyBuffer.put(this.current.keyBuffer.getBytes(), this.current.keyBuffer.getOffset(), this.current.keyLength);
        keyBuffer.rewind();
        return keyBuffer;
    }

    @Override
    public ByteBuffer getValueShallowCopy() {
        ByteBuffer dup = this.currentBuffer.duplicate();
        dup.position(this.current.valueOffset);
        dup.limit(this.current.valueOffset + this.current.valueLength);
        return dup.slice();
    }

    ByteBuffer getKeyValueBuffer() {
        ByteBuffer kvBuffer = this.createKVBuffer();
        kvBuffer.putInt(this.current.keyLength);
        kvBuffer.putInt(this.current.valueLength);
        kvBuffer.put(this.current.keyBuffer.getBytes(), this.current.keyBuffer.getOffset(), this.current.keyLength);
        ByteBufferUtils.copyFromBufferToBuffer(kvBuffer, this.currentBuffer, this.current.valueOffset, this.current.valueLength);
        if (this.current.tagsLength > 0) {
            kvBuffer.put((byte)(this.current.tagsLength >> 8 & 0xFF));
            kvBuffer.put((byte)(this.current.tagsLength & 0xFF));
            if (this.current.tagsOffset != -1) {
                ByteBufferUtils.copyFromBufferToBuffer(kvBuffer, this.currentBuffer, this.current.tagsOffset, this.current.tagsLength);
            }
        }
        if (this.includesMvcc()) {
            ByteBufferUtils.writeVLong(kvBuffer, this.current.getSequenceId());
        }
        kvBuffer.rewind();
        return kvBuffer;
    }

    protected ByteBuffer createKVBuffer() {
        int kvBufSize = (int)KeyValue.getKeyValueDataStructureSize(this.current.keyLength, this.current.valueLength, this.current.tagsLength);
        if (this.includesMvcc()) {
            kvBufSize += WritableUtils.getVIntSize((long)this.current.getSequenceId());
        }
        ByteBuffer kvBuffer = ByteBuffer.allocate(kvBufSize);
        return kvBuffer;
    }

    @Override
    public Cell getKeyValue() {
        return this.current.toCell();
    }

    @Override
    public void rewind() {
        this.currentBuffer.rewind();
        this.decodeFirst();
    }

    @Override
    public boolean next() {
        if (!this.currentBuffer.hasRemaining()) {
            return false;
        }
        this.decodeNext();
        this.previous.invalidate();
        return true;
    }

    @Override
    public int seekToKeyInBlock(byte[] key, int offset, int length, boolean seekBefore) {
        return this.seekToKeyInBlock(new KeyValue.KeyOnlyKeyValue(key, offset, length), seekBefore);
    }

    private int binarySearch(Cell seekCell, boolean seekBefore) {
        int low = 0;
        int high = this.rowNumber - 1;
        int mid = low + high >>> 1;
        int comp = 0;
        SimpleMutableByteRange row = new SimpleMutableByteRange();
        while (low <= high) {
            mid = low + high >>> 1;
            this.getRow(mid, row);
            comp = this.comparator.compareRows(row.getBytes(), row.getOffset(), row.getLength(), seekCell.getRowArray(), seekCell.getRowOffset(), seekCell.getRowLength());
            if (comp < 0) {
                low = mid + 1;
                continue;
            }
            if (comp > 0) {
                high = mid - 1;
                continue;
            }
            if (seekBefore) {
                return mid - 1;
            }
            return mid;
        }
        if (comp > 0) {
            return mid - 1;
        }
        return mid;
    }

    private void getRow(int index, SimpleMutableByteRange row) {
        int offset = Bytes.toIntUnsafe(this.rowOffsets.array(), this.rowOffsets.arrayOffset() + (index << 2));
        int position = this.currentBuffer.arrayOffset() + offset + 8;
        short rowLen = Bytes.toShortUnsafe(this.currentBuffer.array(), position);
        row.set(this.currentBuffer.array(), position + 2, rowLen);
    }

    @Override
    public int seekToKeyInBlock(Cell seekCell, boolean seekBefore) {
        this.previous.invalidate();
        int index = this.binarySearch(seekCell, seekBefore);
        if (index < 0) {
            return -2;
        }
        int offset = Bytes.toIntUnsafe(this.rowOffsets.array(), this.rowOffsets.arrayOffset() + (index << 2));
        if (offset != 0) {
            this.decodeAtPosition(offset);
        }
        while (true) {
            int comp;
            if ((comp = this.comparator.compareOnlyKeyPortion(seekCell, this.current.currentKey)) == 0) {
                if (seekBefore) {
                    if (!this.previous.isValid()) {
                        throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(seekCell.getRowArray()));
                    }
                    this.moveToPrevious();
                    return 1;
                }
                return 0;
            }
            if (comp < 0) {
                if (!this.previous.isValid()) {
                    return -2;
                }
                this.moveToPrevious();
                return 1;
            }
            if (!this.currentBuffer.hasRemaining()) break;
            this.previous.copyFromNext(this.current);
            this.decodeNext();
        }
        return 1;
    }

    private void moveToPrevious() {
        if (!this.previous.isValid()) {
            throw new IllegalStateException("Can move back only once and not in first key in the block.");
        }
        SeekerState tmp = this.previous;
        this.previous = this.current;
        this.current = tmp;
        this.currentBuffer.position(this.current.nextKvOffset);
        this.previous.invalidate();
    }

    @Override
    public int compareKey(KeyValue.KVComparator comparator, byte[] key, int offset, int length) {
        return comparator.compareFlatKey(key, offset, length, this.current.keyBuffer.getBytes(), this.current.keyBuffer.getOffset(), this.current.keyBuffer.getLength());
    }

    @Override
    public int compareKey(KeyValue.KVComparator comparator, Cell key) {
        return comparator.compareOnlyKeyPortion(key, new KeyValue.KeyOnlyKeyValue(this.current.keyBuffer.getBytes(), this.current.keyBuffer.getOffset(), this.current.keyBuffer.getLength()));
    }

    protected void decodeFirst() {
        this.decodeNext();
        this.previous.invalidate();
    }

    protected void decodeAtPosition(int position) {
        this.currentBuffer.position(position);
        this.decodeNext();
        this.previous.invalidate();
    }

    protected void decodeNext() {
        this.current.startOffset = this.currentBuffer.position();
        int p = this.currentBuffer.position() + this.currentBuffer.arrayOffset();
        long ll = Bytes.toLong(this.currentBuffer.array(), p);
        this.current.keyLength = (int)(ll >> 32);
        this.current.valueLength = (int)(0xFFFFFFFF00000000L ^ ll);
        ByteBufferUtils.skip(this.currentBuffer, 8);
        this.current.keyBuffer.set(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + this.currentBuffer.position(), this.current.keyLength);
        ByteBufferUtils.skip(this.currentBuffer, this.current.keyLength);
        this.current.valueOffset = this.currentBuffer.position();
        ByteBufferUtils.skip(this.currentBuffer, this.current.valueLength);
        if (this.includesTags()) {
            this.decodeTags();
        }
        this.current.memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
        this.current.nextKvOffset = this.currentBuffer.position();
        this.current.setKey(this.current.keyBuffer.getBytes(), this.current.keyBuffer.getOffset(), this.current.keyBuffer.getLength());
    }

    protected void decodeTags() {
        this.current.tagsLength = this.currentBuffer.getShort();
        this.current.tagsOffset = this.currentBuffer.position();
        ByteBufferUtils.skip(this.currentBuffer, this.current.tagsLength);
    }

    protected class SeekerState {
        public static final int KEY_VALUE_LEN_SIZE = 8;
        protected ByteBuffer currentBuffer;
        protected int startOffset = -1;
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int tagsLength = 0;
        protected int tagsOffset = -1;
        protected SimpleMutableByteRange keyBuffer = new SimpleMutableByteRange();
        protected long memstoreTS;
        protected int nextKvOffset;
        protected KeyValue.KeyOnlyKeyValue currentKey = new KeyValue.KeyOnlyKeyValue();

        protected SeekerState() {
        }

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
            this.currentKey = new KeyValue.KeyOnlyKeyValue();
            this.currentBuffer = null;
        }

        protected void setKey(byte[] key, int offset, int length) {
            this.currentKey.setKey(key, offset, length);
        }

        protected long getSequenceId() {
            return this.memstoreTS;
        }

        protected void copyFromNext(SeekerState nextState) {
            this.keyBuffer.set(nextState.keyBuffer.getBytes(), nextState.keyBuffer.getOffset(), nextState.keyBuffer.getLength());
            this.currentKey.setKey(nextState.keyBuffer.getBytes(), nextState.keyBuffer.getOffset(), nextState.keyBuffer.getLength());
            this.startOffset = nextState.startOffset;
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
            this.currentBuffer = nextState.currentBuffer;
            this.tagsOffset = nextState.tagsOffset;
            this.tagsLength = nextState.tagsLength;
        }

        public String toString() {
            return CellUtil.getCellKeyAsString(this.toCell());
        }

        protected int getCellBufSize() {
            int kvBufSize = 8 + this.keyLength + this.valueLength;
            if (RowIndexSeekerV1.this.includesTags() && this.tagsLength > 0) {
                kvBufSize += 2 + this.tagsLength;
            }
            return kvBufSize;
        }

        protected Cell formNoTagsKeyValue() {
            NoTagsKeyValue ret = new NoTagsKeyValue(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + this.startOffset, this.getCellBufSize());
            if (RowIndexSeekerV1.this.includesMvcc()) {
                ret.setSequenceId(this.memstoreTS);
            }
            return ret;
        }

        public Cell toCell() {
            if (this.tagsOffset > 0) {
                KeyValue ret = new KeyValue(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + this.startOffset, this.getCellBufSize());
                if (RowIndexSeekerV1.this.includesMvcc()) {
                    ret.setSequenceId(this.memstoreTS);
                }
                return ret;
            }
            return this.formNoTagsKeyValue();
        }
    }
}

