/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import org.apache.hadoop.fs.aliyun.oss.AliyunOSSCopyFileContext;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSCopyFileTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(AliyunOSSCopyFileTask.class);
    private AliyunOSSFileSystemStore store;
    private String srcKey;
    private long srcLen;
    private String dstKey;
    private AliyunOSSCopyFileContext copyFileContext;

    public AliyunOSSCopyFileTask(AliyunOSSFileSystemStore store, String srcKey, long srcLen, String dstKey, AliyunOSSCopyFileContext copyFileContext) {
        this.store = store;
        this.srcKey = srcKey;
        this.srcLen = srcLen;
        this.dstKey = dstKey;
        this.copyFileContext = copyFileContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean fail = false;
        try {
            fail = !this.store.copyFile(this.srcKey, this.srcLen, this.dstKey);
        }
        catch (Exception e) {
            LOG.warn("Exception thrown when copy from " + this.srcKey + " to " + this.dstKey + ", exception: " + e);
            fail = true;
        }
        finally {
            this.copyFileContext.lock();
            if (fail) {
                this.copyFileContext.setCopyFailure(fail);
            }
            this.copyFileContext.incCopiesFinish();
            this.copyFileContext.signalAll();
            this.copyFileContext.unlock();
        }
    }
}

