/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto.query;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;

@Schema(description="Metric Query Data")
public class DatasourceQueryData {
    @Schema(title="Ref Id, unique id for the query")
    private String refId;
    @Schema(title="query status code, 200 for success, other for error")
    private Integer status;
    @Schema(title="query error message")
    private String msg;
    @Schema(title="query result data frames")
    private List<SchemaData> frames;

    public static DatasourceQueryDataBuilder builder() {
        return new DatasourceQueryDataBuilder();
    }

    public String getRefId() {
        return this.refId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getMsg() {
        return this.msg;
    }

    public List<SchemaData> getFrames() {
        return this.frames;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setFrames(List<SchemaData> frames) {
        this.frames = frames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasourceQueryData)) {
            return false;
        }
        DatasourceQueryData other = (DatasourceQueryData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$refId = this.getRefId();
        String other$refId = other.getRefId();
        if (this$refId == null ? other$refId != null : !this$refId.equals(other$refId)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        List<SchemaData> this$frames = this.getFrames();
        List<SchemaData> other$frames = other.getFrames();
        return !(this$frames == null ? other$frames != null : !((Object)this$frames).equals(other$frames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatasourceQueryData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $refId = this.getRefId();
        result = result * 59 + ($refId == null ? 43 : $refId.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        List<SchemaData> $frames = this.getFrames();
        result = result * 59 + ($frames == null ? 43 : ((Object)$frames).hashCode());
        return result;
    }

    public String toString() {
        return "DatasourceQueryData(refId=" + this.getRefId() + ", status=" + this.getStatus() + ", msg=" + this.getMsg() + ", frames=" + this.getFrames() + ")";
    }

    public DatasourceQueryData(String refId, Integer status, String msg, List<SchemaData> frames) {
        this.refId = refId;
        this.status = status;
        this.msg = msg;
        this.frames = frames;
    }

    public DatasourceQueryData() {
    }

    public static class DatasourceQueryDataBuilder {
        private String refId;
        private Integer status;
        private String msg;
        private List<SchemaData> frames;

        DatasourceQueryDataBuilder() {
        }

        public DatasourceQueryDataBuilder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public DatasourceQueryDataBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public DatasourceQueryDataBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public DatasourceQueryDataBuilder frames(List<SchemaData> frames) {
            this.frames = frames;
            return this;
        }

        public DatasourceQueryData build() {
            return new DatasourceQueryData(this.refId, this.status, this.msg, this.frames);
        }

        public String toString() {
            return "DatasourceQueryData.DatasourceQueryDataBuilder(refId=" + this.refId + ", status=" + this.status + ", msg=" + this.msg + ", frames=" + this.frames + ")";
        }
    }

    public static final class MetricField {
        @Schema(title="Metric Field Name")
        private String name;
        @Schema(title="Field Type: number, string, time, bool")
        private String type;
        @Schema(title="Field Unit: %, Mb, Kbps etc.")
        private String unit;

        public static MetricFieldBuilder builder() {
            return new MetricFieldBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricField)) {
                return false;
            }
            MetricField other = (MetricField)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "DatasourceQueryData.MetricField(name=" + this.getName() + ", type=" + this.getType() + ", unit=" + this.getUnit() + ")";
        }

        public MetricField(String name, String type, String unit) {
            this.name = name;
            this.type = type;
            this.unit = unit;
        }

        public MetricField() {
        }

        public static class MetricFieldBuilder {
            private String name;
            private String type;
            private String unit;

            MetricFieldBuilder() {
            }

            public MetricFieldBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MetricFieldBuilder type(String type) {
                this.type = type;
                return this;
            }

            public MetricFieldBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public MetricField build() {
                return new MetricField(this.name, this.type, this.unit);
            }

            public String toString() {
                return "DatasourceQueryData.MetricField.MetricFieldBuilder(name=" + this.name + ", type=" + this.type + ", unit=" + this.unit + ")";
            }
        }
    }

    public static final class MetricSchema {
        @Schema(title="Metrics Field")
        private List<MetricField> fields;
        @Schema(title="This frame labels")
        private Map<String, String> labels;
        @Schema(title="Meta Information")
        private Map<String, String> meta;

        public static MetricSchemaBuilder builder() {
            return new MetricSchemaBuilder();
        }

        public List<MetricField> getFields() {
            return this.fields;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setFields(List<MetricField> fields) {
            this.fields = fields;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricSchema)) {
                return false;
            }
            MetricSchema other = (MetricSchema)o;
            List<MetricField> this$fields = this.getFields();
            List<MetricField> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            Map<String, String> this$labels = this.getLabels();
            Map<String, String> other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
                return false;
            }
            Map<String, String> this$meta = this.getMeta();
            Map<String, String> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MetricField> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            Map<String, String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            Map<String, String> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        public String toString() {
            return "DatasourceQueryData.MetricSchema(fields=" + this.getFields() + ", labels=" + this.getLabels() + ", meta=" + this.getMeta() + ")";
        }

        public MetricSchema(List<MetricField> fields, Map<String, String> labels, Map<String, String> meta) {
            this.fields = fields;
            this.labels = labels;
            this.meta = meta;
        }

        public MetricSchema() {
        }

        public static class MetricSchemaBuilder {
            private List<MetricField> fields;
            private Map<String, String> labels;
            private Map<String, String> meta;

            MetricSchemaBuilder() {
            }

            public MetricSchemaBuilder fields(List<MetricField> fields) {
                this.fields = fields;
                return this;
            }

            public MetricSchemaBuilder labels(Map<String, String> labels) {
                this.labels = labels;
                return this;
            }

            public MetricSchemaBuilder meta(Map<String, String> meta) {
                this.meta = meta;
                return this;
            }

            public MetricSchema build() {
                return new MetricSchema(this.fields, this.labels, this.meta);
            }

            public String toString() {
                return "DatasourceQueryData.MetricSchema.MetricSchemaBuilder(fields=" + this.fields + ", labels=" + this.labels + ", meta=" + this.meta + ")";
            }
        }
    }

    public static final class SchemaData {
        @Schema(title="Metric Schema")
        private MetricSchema schema;
        @Schema(title="metrics row values, first is the timestamp-ts", example="[[29,32,44],[32,34,true]]")
        private List<Object[]> data;

        public static SchemaDataBuilder builder() {
            return new SchemaDataBuilder();
        }

        public MetricSchema getSchema() {
            return this.schema;
        }

        public List<Object[]> getData() {
            return this.data;
        }

        public void setSchema(MetricSchema schema) {
            this.schema = schema;
        }

        public void setData(List<Object[]> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaData)) {
                return false;
            }
            SchemaData other = (SchemaData)o;
            MetricSchema this$schema = this.getSchema();
            MetricSchema other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
                return false;
            }
            List<Object[]> this$data = this.getData();
            List<Object[]> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MetricSchema $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
            List<Object[]> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "DatasourceQueryData.SchemaData(schema=" + this.getSchema() + ", data=" + this.getData() + ")";
        }

        public SchemaData(MetricSchema schema, List<Object[]> data) {
            this.schema = schema;
            this.data = data;
        }

        public SchemaData() {
        }

        public static class SchemaDataBuilder {
            private MetricSchema schema;
            private List<Object[]> data;

            SchemaDataBuilder() {
            }

            public SchemaDataBuilder schema(MetricSchema schema) {
                this.schema = schema;
                return this;
            }

            public SchemaDataBuilder data(List<Object[]> data) {
                this.data = data;
                return this;
            }

            public SchemaData build() {
                return new SchemaData(this.schema, this.data);
            }

            public String toString() {
                return "DatasourceQueryData.SchemaData.SchemaDataBuilder(schema=" + this.schema + ", data=" + this.data + ")";
            }
        }
    }
}

