/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.map.Unordered2Map;
import io.questdb.cairo.map.Unordered4Map;
import io.questdb.cairo.map.Unordered8Map;
import io.questdb.cairo.map.UnorderedVarcharMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapFactory {
    public static Map createOrderedMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        int keyCapacity = configuration.getSqlSmallMapKeyCapacity();
        long pageSize = configuration.getSqlSmallMapPageSize();
        return new OrderedMap(pageSize, keyTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
    }

    public static Map createOrderedMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        int keyCapacity = configuration.getSqlSmallMapKeyCapacity();
        long pageSize = configuration.getSqlSmallMapPageSize();
        return new OrderedMap(pageSize, keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
    }

    public static Map createUnorderedMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        int keyCapacity = configuration.getSqlSmallMapKeyCapacity();
        long pageSize = configuration.getSqlSmallMapPageSize();
        return MapFactory.createUnorderedMap(configuration, keyTypes, valueTypes, keyCapacity, pageSize);
    }

    public static Map createUnorderedMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, long pageSize) {
        int maxEntrySize = configuration.getSqlUnorderedMapMaxEntrySize();
        int keySize = MapFactory.totalSize(keyTypes);
        int valueSize = MapFactory.totalSize(valueTypes);
        if (keySize > 0) {
            if (keySize == 2 && valueSize <= maxEntrySize) {
                return new Unordered2Map(keyTypes, valueTypes);
            }
            if (keySize == 4 && 4 + valueSize <= maxEntrySize) {
                return new Unordered4Map(keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
            }
            if (keySize == 8 && 8 + valueSize <= maxEntrySize) {
                return new Unordered8Map(keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
            }
        }
        if (keyTypes.getColumnCount() == 1 && keyTypes.getColumnType(0) == 26 && 16 + valueSize <= maxEntrySize) {
            return new UnorderedVarcharMap(valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes(), configuration.getGroupByAllocatorDefaultChunkSize(), configuration.getGroupByAllocatorMaxChunkSize());
        }
        return new OrderedMap(pageSize, keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
    }

    private static int totalSize(ColumnTypes types) {
        if (types == null) {
            return 0;
        }
        int totalSize = 0;
        int n = types.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int columnType = types.getColumnType(i);
            int size = ColumnType.sizeOf(columnType);
            if (size > 0) {
                totalSize += size;
                continue;
            }
            return -1;
        }
        return totalSize;
    }
}

