/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.ReadableBlock;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewStateReader
implements Mutable {
    private final StringSink invalidationReason = new StringSink();
    private final LongList refreshIntervals = new LongList();
    private boolean invalid;
    private long lastPeriodHi = Long.MIN_VALUE;
    private long lastRefreshBaseTxn = -1L;
    private long lastRefreshTimestamp = Long.MIN_VALUE;
    private long refreshIntervalsBaseTxn = -1L;

    @Override
    public void clear() {
        this.invalid = false;
        this.invalidationReason.clear();
        this.lastRefreshBaseTxn = -1L;
        this.lastRefreshTimestamp = Long.MIN_VALUE;
        this.lastPeriodHi = Long.MIN_VALUE;
        this.refreshIntervalsBaseTxn = -1L;
        this.refreshIntervals.clear();
    }

    @Nullable
    public CharSequence getInvalidationReason() {
        return this.invalidationReason.length() > 0 ? this.invalidationReason : null;
    }

    public long getLastPeriodHi() {
        return this.lastPeriodHi;
    }

    public long getLastRefreshBaseTxn() {
        return this.lastRefreshBaseTxn;
    }

    public long getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public LongList getRefreshIntervals() {
        return this.refreshIntervals;
    }

    public long getRefreshIntervalsBaseTxn() {
        return this.refreshIntervalsBaseTxn;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public MatViewStateReader of(@NotNull WalEventCursor.MatViewDataInfo info) {
        this.invalid = false;
        this.invalidationReason.clear();
        this.lastRefreshBaseTxn = info.getLastRefreshBaseTableTxn();
        this.lastRefreshTimestamp = info.getLastRefreshTimestamp();
        this.lastPeriodHi = info.getLastPeriodHi();
        this.refreshIntervalsBaseTxn = -1L;
        this.refreshIntervals.clear();
        return this;
    }

    public MatViewStateReader of(@NotNull WalEventCursor.MatViewInvalidationInfo info) {
        this.invalid = info.isInvalid();
        this.invalidationReason.clear();
        this.invalidationReason.put(info.getInvalidationReason());
        this.lastRefreshBaseTxn = info.getLastRefreshBaseTableTxn();
        this.lastRefreshTimestamp = info.getLastRefreshTimestamp();
        this.lastPeriodHi = info.getLastPeriodHi();
        this.refreshIntervalsBaseTxn = info.getRefreshIntervalsBaseTxn();
        this.refreshIntervals.clear();
        this.refreshIntervals.addAll(info.getRefreshIntervals());
        return this;
    }

    public MatViewStateReader of(@NotNull BlockFileReader reader, @NotNull TableToken matViewToken) {
        boolean matViewStateBlockFound = false;
        BlockFileReader.BlockCursor cursor = reader.getCursor();
        while (cursor.hasNext()) {
            ReadableBlock block = cursor.next();
            if (block.type() == 0) {
                matViewStateBlockFound = true;
                this.invalid = block.getBool(0L);
                this.lastRefreshBaseTxn = block.getLong(1L);
                this.invalidationReason.clear();
                this.invalidationReason.put(block.getStr(9L));
                this.lastRefreshTimestamp = Long.MIN_VALUE;
                continue;
            }
            if (block.type() == 1) {
                this.lastRefreshTimestamp = block.getLong(0L);
                continue;
            }
            if (block.type() == 2) {
                this.lastPeriodHi = block.getLong(0L);
                continue;
            }
            if (block.type() != 3) continue;
            long offset = 0L;
            this.refreshIntervalsBaseTxn = block.getLong(offset);
            int intervalsLen = block.getInt(offset += 8L);
            offset += 4L;
            this.refreshIntervals.clear();
            for (int i = 0; i < intervalsLen; ++i) {
                this.refreshIntervals.add(block.getLong(offset));
                offset += 8L;
            }
            return this;
        }
        if (!matViewStateBlockFound) {
            throw CairoException.critical(0).put("cannot read materialized view state, block not found [view=").put(matViewToken.getTableName()).put(']');
        }
        return this;
    }
}

