/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectUtf8Sequence;

public final class IPv4Adapter
extends AbstractTypeAdapter {
    public static final IPv4Adapter INSTANCE = new IPv4Adapter();

    private IPv4Adapter() {
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        if (text.size() < 7) {
            return false;
        }
        if (Numbers.notDigit(text.byteAt(0)) && text.byteAt(0) != 46) {
            return false;
        }
        try {
            Numbers.parseIPv4(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        row.putIPv4(column, SqlKeywords.isNullKeyword(value) ? 0 : this.parseIPv4(value));
    }

    private int parseIPv4(DirectUtf8Sequence value) throws NumericException {
        return Numbers.parseIPv4(value);
    }
}

