/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToByteFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToByteFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Db)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToByteFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public byte getByte(Record rec) {
            double value = this.arg.getDouble(rec);
            return Numbers.isNull(value) || value > 127.0 || value < -128.0 ? (byte)0 : (byte)value;
        }
    }
}

