/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.ObjList;
import java.util.function.IntFunction;

public class InformationSchemaColumnsFunctionFactory
implements FunctionFactory {
    public static final RecordMetadata METADATA;
    public static final String SIGNATURE = "information_schema.columns()";
    private static final IntObjHashMap<String> OID_TO_TYPE_NAME;
    public static IntFunction<String> TYPE_TO_NAME;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new ColumnsCursorFactory(TYPE_TO_NAME));
    }

    static {
        OID_TO_TYPE_NAME = new IntObjHashMap();
        TYPE_TO_NAME = columnType -> {
            int typeOid = PGOids.getTypeOid(columnType);
            String sqlStdName = OID_TO_TYPE_NAME.get(typeOid);
            if (sqlStdName != null) {
                return sqlStdName;
            }
            return "unknown";
        };
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("table_catalog", 11));
        metadata.add(new TableColumnMetadata("table_schema", 11));
        metadata.add(new TableColumnMetadata("table_name", 11));
        metadata.add(new TableColumnMetadata("column_name", 11));
        metadata.add(new TableColumnMetadata("ordinal_position", 5));
        metadata.add(new TableColumnMetadata("column_default", 11));
        metadata.add(new TableColumnMetadata("is_nullable", 11));
        metadata.add(new TableColumnMetadata("data_type", 11));
        METADATA = metadata;
        OID_TO_TYPE_NAME.put(1043, "character varying");
        OID_TO_TYPE_NAME.put(1114, "timestamp without time zone");
        OID_TO_TYPE_NAME.put(701, "double precision");
        OID_TO_TYPE_NAME.put(700, "real");
        OID_TO_TYPE_NAME.put(23, "integer");
        OID_TO_TYPE_NAME.put(21, "smallint");
        OID_TO_TYPE_NAME.put(1042, "character");
        OID_TO_TYPE_NAME.put(20, "bigint");
        OID_TO_TYPE_NAME.put(16, "boolean");
        OID_TO_TYPE_NAME.put(17, "bytea");
        OID_TO_TYPE_NAME.put(1082, "date");
        OID_TO_TYPE_NAME.put(2950, "character varying");
        OID_TO_TYPE_NAME.put(2281, "internal");
        OID_TO_TYPE_NAME.put(26, "integer");
    }

    static class ColumnsCursorFactory
    extends AbstractRecordCursorFactory {
        private final ColumnRecordCursor cursor;
        private final CharSequenceObjHashMap<CairoTable> tableCache = new CharSequenceObjHashMap();
        private long tableCacheVersion = -1L;

        ColumnsCursorFactory(IntFunction<String> typeToName) {
            super(METADATA);
            this.cursor = new ColumnRecordCursor(this.tableCache, typeToName);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            CairoEngine engine = executionContext.getCairoEngine();
            try (MetadataCacheReader metadataRO = engine.getMetadataCache().readLock();){
                this.tableCacheVersion = metadataRO.snapshot(this.tableCache, this.tableCacheVersion);
            }
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(InformationSchemaColumnsFunctionFactory.SIGNATURE);
        }

        private static class ColumnRecordCursor
        implements NoRandomAccessRecordCursor {
            private final ColumnsRecord record = new ColumnsRecord();
            private final CharSequenceObjHashMap<CairoTable> tableCache;
            private final IntFunction<String> typeToName;
            private int columnIdx;
            private int iteratorIdx;
            private CairoTable table;

            private ColumnRecordCursor(CharSequenceObjHashMap<CairoTable> tableCache, IntFunction<String> typeToName) {
                this.tableCache = tableCache;
                this.typeToName = typeToName;
            }

            @Override
            public void close() {
                this.columnIdx = -1;
                this.iteratorIdx = -1;
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                while (this.table != null || this.nextTable()) {
                    if (this.columnIdx < this.table.getColumnCount() - 1) {
                        ++this.columnIdx;
                        CairoColumn column = this.table.getColumnQuiet(this.columnIdx);
                        this.record.of(this.table.getTableName(), this.columnIdx, column.getName(), this.typeToName.apply(column.getType()));
                        return true;
                    }
                    this.columnIdx = -1;
                    this.table = null;
                }
                return false;
            }

            public boolean nextTable() {
                assert (this.table == null);
                if (this.iteratorIdx < this.tableCache.size() - 1) {
                    this.table = this.tableCache.getAt(++this.iteratorIdx);
                    return true;
                }
                return false;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.columnIdx = -1;
                this.table = null;
                this.iteratorIdx = -1;
            }

            private static class ColumnsRecord
            implements Record {
                private CharSequence columnName;
                private CharSequence dataType;
                private int ordinalPosition;
                private CharSequence tableName;

                private ColumnsRecord() {
                }

                @Override
                public int getInt(int col) {
                    return this.ordinalPosition;
                }

                @Override
                public CharSequence getStrA(int col) {
                    switch (col) {
                        case 0: {
                            return "qdb";
                        }
                        case 1: {
                            return "public";
                        }
                        case 2: {
                            return this.tableName;
                        }
                        case 3: {
                            return this.columnName;
                        }
                        case 5: {
                            return null;
                        }
                        case 6: {
                            return "yes";
                        }
                        case 7: {
                            return this.dataType;
                        }
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }

                private void of(CharSequence tableName, int ordinalPosition, CharSequence columnName, CharSequence dataType) {
                    this.tableName = tableName;
                    this.ordinalPosition = ordinalPosition;
                    this.columnName = columnName;
                    this.dataType = dataType;
                }
            }
        }
    }
}

