/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.CastBooleanToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToCharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToDateFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToDateFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToDateFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIPv4ToIntFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIPv4ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIPv4ToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToIPv4FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToDateFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToIPv4FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastStrToUuidFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastUuidToVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToIPv4FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastVarcharToUuidFunctionFactory;
import io.questdb.griffin.engine.functions.conditional.ArrayCaseFunction;
import io.questdb.griffin.engine.functions.conditional.BinCaseFunction;
import io.questdb.griffin.engine.functions.conditional.BooleanCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ByteCaseFunction;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionConstructor;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.conditional.CharCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DateCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DoubleCaseFunction;
import io.questdb.griffin.engine.functions.conditional.FloatCaseFunction;
import io.questdb.griffin.engine.functions.conditional.GeoByteCaseFunction;
import io.questdb.griffin.engine.functions.conditional.GeoIntCaseFunction;
import io.questdb.griffin.engine.functions.conditional.GeoLongCaseFunction;
import io.questdb.griffin.engine.functions.conditional.GeoShortCaseFunction;
import io.questdb.griffin.engine.functions.conditional.IPv4CaseFunction;
import io.questdb.griffin.engine.functions.conditional.IntCaseFunction;
import io.questdb.griffin.engine.functions.conditional.Long128CaseFunction;
import io.questdb.griffin.engine.functions.conditional.Long256CaseFunction;
import io.questdb.griffin.engine.functions.conditional.LongCaseFunction;
import io.questdb.griffin.engine.functions.conditional.NullCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ShortCaseFunction;
import io.questdb.griffin.engine.functions.conditional.StrCaseFunction;
import io.questdb.griffin.engine.functions.conditional.TimestampCaseFunction;
import io.questdb.griffin.engine.functions.conditional.UuidCaseFunction;
import io.questdb.griffin.engine.functions.conditional.VarcharCaseFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import org.jetbrains.annotations.NotNull;

public class CaseCommon {
    private static final LongObjHashMap<FunctionFactory> castFactories = new LongObjHashMap();
    private static final ObjList<CaseFunctionConstructor> constructors = new ObjList(34);
    private static final ThreadLocal<IntList> tlArgPositions = new ThreadLocal<IntList>(IntList::new);
    private static final ThreadLocal<ObjList<Function>> tlArgs = new ThreadLocal<ObjList>(ObjList::new);
    private static final LongIntHashMap typeEscalationMap = new LongIntHashMap();

    public static Function getCastFunction(Function arg, int argPosition, int toType, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int argType = arg.getType();
        if (ColumnType.isNull(argType)) {
            return Constants.getNullConstant(toType);
        }
        if (ColumnType.isArray(argType)) {
            assert (argType == toType);
            return arg;
        }
        int keyIndex = castFactories.keyIndex(Numbers.encodeLowHighInts(argType, toType));
        if (keyIndex < 0) {
            FunctionFactory factory = castFactories.valueAt(keyIndex);
            ObjList<Function> args = tlArgs.get();
            args.clear();
            args.add(arg);
            IntList argPositions = tlArgPositions.get();
            argPositions.clear();
            argPositions.add(argPosition);
            return factory.newInstance(0, args, argPositions, configuration, sqlExecutionContext);
        }
        return arg;
    }

    public static int getCommonType(int commonType, int valueType, int valuePos, String undefinedErrorMsg) throws SqlException {
        if (ColumnType.isUndefined(valueType)) {
            throw SqlException.$(valuePos, undefinedErrorMsg);
        }
        if (commonType == -1 || ColumnType.isNull(commonType) || commonType == 0) {
            return valueType;
        }
        if (ColumnType.isNull(valueType)) {
            return commonType;
        }
        boolean arrayCommonType = ColumnType.isArray(commonType);
        boolean arrayValueType = ColumnType.isArray(valueType);
        if (arrayCommonType && arrayValueType) {
            if (commonType == valueType) {
                return commonType;
            }
            throw SqlException.inconvertibleTypes(valuePos, valueType, ColumnType.nameOf(valueType), commonType, ColumnType.nameOf(commonType));
        }
        int type = typeEscalationMap.get(Numbers.encodeLowHighInts(commonType, valueType));
        if (type == -1) {
            throw SqlException.inconvertibleTypes(valuePos, valueType, ColumnType.nameOf(valueType), commonType, ColumnType.nameOf(commonType));
        }
        return type;
    }

    @NotNull
    private static CaseFunctionConstructor getCaseFunctionConstructor(int position, int returnType) throws SqlException {
        CaseFunctionConstructor constructor = constructors.getQuick(returnType);
        if (constructor == null) {
            throw SqlException.$(position, "unsupported CASE value type '").put(ColumnType.nameOf(returnType)).put('\'');
        }
        return constructor;
    }

    static Function getCaseFunction(int position, int returnType, CaseFunctionPicker picker, ObjList<Function> args) throws SqlException {
        if (ColumnType.isGeoHash(returnType)) {
            switch (ColumnType.tagOf(returnType)) {
                case 14: {
                    return new GeoByteCaseFunction(returnType, picker, args);
                }
                case 15: {
                    return new GeoShortCaseFunction(returnType, picker, args);
                }
                case 16: {
                    return new GeoIntCaseFunction(returnType, picker, args);
                }
            }
            return new GeoLongCaseFunction(returnType, picker, args);
        }
        if (ColumnType.isArray(returnType)) {
            return new ArrayCaseFunction(returnType, picker, args);
        }
        return CaseCommon.getCaseFunctionConstructor(position, returnType).getInstance(position, picker, args);
    }

    static {
        castFactories.put(Numbers.encodeLowHighInts(2, 13), new CastByteToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 11), new CastByteToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 26), new CastByteToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 12), new CastByteToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 4), new CastByteToCharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 7), new CastByteToDateFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 8), new CastByteToTimestampFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 13), new CastCharToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 11), new CastCharToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 26), new CastCharToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 12), new CastCharToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 7), new CastCharToDateFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 8), new CastCharToTimestampFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 13), new CastShortToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 11), new CastShortToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 26), new CastShortToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 12), new CastShortToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 7), new CastShortToDateFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 8), new CastShortToTimestampFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 13), new CastIntToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 11), new CastIntToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 26), new CastIntToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(25, 11), new CastIPv4ToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(25, 26), new CastIPv4ToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(11, 25), new CastStrToIPv4FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(26, 25), new CastVarcharToIPv4FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 25), new CastIntToIPv4FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(25, 5), new CastIPv4ToIntFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 12), new CastIntToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 13), new CastLongToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 11), new CastLongToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 26), new CastLongToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 12), new CastLongToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 13), new CastFloatToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 11), new CastFloatToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 26), new CastFloatToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 12), new CastFloatToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 7), new CastFloatToDateFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 13), new CastDoubleToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 11), new CastDoubleToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 26), new CastDoubleToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 12), new CastDoubleToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 13), new CastDateToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 11), new CastDateToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 26), new CastDateToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 12), new CastDateToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 13), new CastTimestampToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 11), new CastTimestampToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 26), new CastTimestampToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 12), new CastTimestampToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(1, 13), new CastBooleanToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(13, 11), new CastLong256ToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(13, 26), new CastLong256ToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(13, 12), new CastLong256ToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(19, 11), new CastUuidToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(19, 26), new CastUuidToVarcharFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(11, 19), new CastStrToUuidFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(26, 19), new CastVarcharToUuidFunctionFactory());
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 26), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 2), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 2), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 3), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(25, 25), 25);
        typeEscalationMap.put(Numbers.encodeLowHighInts(25, 11), 25);
        typeEscalationMap.put(Numbers.encodeLowHighInts(25, 26), 25);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 2), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 3), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 5), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 2), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 3), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 5), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 6), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 2), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 3), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 5), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 6), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 9), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 12), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 26), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 4), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 19), 19);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 25), 25);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 11), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 26), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 12), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 4), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 19), 19);
        typeEscalationMap.put(Numbers.encodeLowHighInts(26, 25), 25);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 26), 26);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 4), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 1), 1);
        typeEscalationMap.put(Numbers.encodeLowHighInts(19, 19), 19);
        typeEscalationMap.put(Numbers.encodeLowHighInts(19, 11), 19);
        typeEscalationMap.put(Numbers.encodeLowHighInts(19, 26), 19);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(18, 18), 18);
        constructors.set(0, 34, null);
        constructors.extendAndSet(11, (position, picker, args) -> new StrCaseFunction(picker, args));
        constructors.extendAndSet(5, (position, picker, args) -> new IntCaseFunction(picker, args));
        constructors.extendAndSet(6, (position, picker, args) -> new LongCaseFunction(picker, args));
        constructors.extendAndSet(2, (position, picker, args) -> new ByteCaseFunction(picker, args));
        constructors.extendAndSet(1, (position, picker, args) -> new BooleanCaseFunction(picker, args));
        constructors.extendAndSet(3, (position, picker, args) -> new ShortCaseFunction(picker, args));
        constructors.extendAndSet(4, (position, picker, args) -> new CharCaseFunction(picker, args));
        constructors.extendAndSet(9, (position, picker, args) -> new FloatCaseFunction(picker, args));
        constructors.extendAndSet(10, (position, picker, args) -> new DoubleCaseFunction(picker, args));
        constructors.extendAndSet(13, (position, picker, args) -> new Long256CaseFunction(picker, args));
        constructors.extendAndSet(12, (position, picker, args) -> new StrCaseFunction(picker, args));
        constructors.extendAndSet(7, (position, picker, args) -> new DateCaseFunction(picker, args));
        constructors.extendAndSet(8, (position, picker, args) -> new TimestampCaseFunction(picker, args));
        constructors.extendAndSet(18, (position, picker, args) -> new BinCaseFunction(picker, args));
        constructors.extendAndSet(24, (position, picker, args) -> new Long128CaseFunction(picker, args));
        constructors.extendAndSet(19, (position, picker, args) -> new UuidCaseFunction(picker, args));
        constructors.extendAndSet(25, (position, picker, args) -> new IPv4CaseFunction(picker, args));
        constructors.extendAndSet(26, (position, picker, args) -> new VarcharCaseFunction(picker, args));
        constructors.extendAndSet(33, (position, picker, args) -> new NullCaseFunction(args));
        constructors.setPos(34);
    }
}

