/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import org.jetbrains.annotations.Nullable;

public class SymbolConstant
extends SymbolFunction
implements ConstantFunction {
    public static final SymbolConstant FALSE = new SymbolConstant("false", 0);
    public static final SymbolConstant NULL = new SymbolConstant(null, Integer.MIN_VALUE);
    public static final SymbolConstant TRUE = new SymbolConstant("true", 0);
    private final int index;
    private final Utf8String utf8Value;
    private final String value;

    public SymbolConstant(CharSequence value, int index) {
        if (value == null) {
            this.value = null;
            this.utf8Value = null;
            this.index = Integer.MIN_VALUE;
        } else {
            this.value = Chars.startsWith(value, '\'') && Chars.endsWith(value, '\'') && value.length() > 1 ? Chars.toString(value, 1, value.length() - 1) : Chars.toString(value);
            this.utf8Value = new Utf8String(this.value);
            this.index = index;
        }
    }

    public static SymbolConstant newInstance(CharSequence value) {
        if (value == null) {
            return NULL;
        }
        if (SqlKeywords.isTrueKeyword(value)) {
            return TRUE;
        }
        if (SqlKeywords.isFalseKeyword(value)) {
            return FALSE;
        }
        return new SymbolConstant(Chars.toString(value), 0);
    }

    @Override
    public int getInt(Record rec) {
        return this.index;
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.value;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        return this.utf8Value;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.utf8Value;
    }

    @Override
    public boolean isNullConstant() {
        return this.index == Integer.MIN_VALUE;
    }

    @Override
    public boolean isSymbolTableStatic() {
        return false;
    }

    @Override
    @Nullable
    public SymbolTable newSymbolTable() {
        return this;
    }

    @Override
    public boolean supportsParallelism() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (this.value == null) {
            sink.val("null::symbol");
        } else {
            sink.val('\'').val(this.value).val('\'');
        }
    }

    @Override
    public CharSequence valueBOf(int key) {
        return this.value;
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.value;
    }
}

