/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionByte;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionInt;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionLong;
import io.questdb.griffin.engine.functions.groupby.FirstGeoHashGroupByFunctionShort;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LastNotNullGeoHashGroupByFunctionFactory
implements FunctionFactory {
    public static final String NAME = "last_not_null";

    @Override
    public String getSignature() {
        return "last_not_null(G)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function function = args.getQuick(0);
        int type = function.getType();
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new LastNotNullGeoHashGroupByFunctionByte(type, function);
            }
            case 15: {
                return new LastNotNullGeoHashGroupByFunctionShort(type, function);
            }
            case 16: {
                return new LastNotNullGeoHashGroupByFunctionInt(type, function);
            }
        }
        return new LastNotNullGeoHashGroupByFunctionLong(type, function);
    }

    private static class LastNotNullGeoHashGroupByFunctionByte
    extends FirstGeoHashGroupByFunctionByte {
        public LastNotNullGeoHashGroupByFunctionByte(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (this.arg.getGeoByte(record) != -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return LastNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            byte srcVal = srcValue.getGeoByte(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putByte(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class LastNotNullGeoHashGroupByFunctionShort
    extends FirstGeoHashGroupByFunctionShort {
        public LastNotNullGeoHashGroupByFunctionShort(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (this.arg.getGeoShort(record) != -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return LastNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            short srcVal = srcValue.getGeoShort(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putShort(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class LastNotNullGeoHashGroupByFunctionInt
    extends FirstGeoHashGroupByFunctionInt {
        public LastNotNullGeoHashGroupByFunctionInt(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (this.arg.getGeoInt(record) != -1) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return LastNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            int srcVal = srcValue.getGeoInt(this.valueIndex + 1);
            if (srcVal == -1) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putInt(this.valueIndex + 1, srcVal);
            }
        }
    }

    private static class LastNotNullGeoHashGroupByFunctionLong
    extends FirstGeoHashGroupByFunctionLong {
        public LastNotNullGeoHashGroupByFunctionLong(int type, Function function) {
            super(type, function);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (this.arg.getGeoLong(record) != -1L) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return LastNotNullGeoHashGroupByFunctionFactory.NAME;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            long srcVal = srcValue.getGeoLong(this.valueIndex + 1);
            if (srcVal == -1L) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putLong(this.valueIndex + 1, srcVal);
            }
        }
    }
}

