/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SignDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sign(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.get(0));
    }

    static class Func
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;

        Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double d = this.arg.getDouble(rec);
            if (d == -0.0) {
                return 0.0;
            }
            return Math.signum(d);
        }

        @Override
        public String getName() {
            return "sign";
        }
    }
}

