/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.EqVarcharFunctionFactory;
import io.questdb.griffin.engine.functions.regex.AbstractLikeStrFunctionFactory;
import io.questdb.griffin.engine.functions.str.StartsWithVarcharFunctionFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.SwarUtils;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.regex.Pattern;

public abstract class AbstractLikeVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        if (pattern.isConstant()) {
            int len;
            CharSequence likeSeq = pattern.getStrA(null);
            if (likeSeq != null && (len = likeSeq.length()) > 0) {
                if (AbstractLikeStrFunctionFactory.countChar(likeSeq, '_') == 0 && AbstractLikeStrFunctionFactory.countChar(likeSeq, '\\') == 0) {
                    int anyCount = AbstractLikeStrFunctionFactory.countChar(likeSeq, '%');
                    if (anyCount == 1) {
                        if (len == 1) {
                            EqVarcharFunctionFactory.NullCheckFunc notNullFunc = new EqVarcharFunctionFactory.NullCheckFunc(value);
                            notNullFunc.setNegated();
                            return notNullFunc;
                        }
                        if (likeSeq.charAt(0) == '%') {
                            CharSequence subPattern = likeSeq.subSequence(1, len);
                            if (this.isCaseInsensitive()) {
                                if (Chars.isAscii(subPattern)) {
                                    return new ConstIEndsWithAsciiFunction(value, subPattern);
                                }
                                return new AbstractLikeStrFunctionFactory.ConstIEndsWithStrFunction(value, subPattern.toString());
                            }
                            return new ConstEndsWithVarcharFunction(value, subPattern);
                        }
                        if (likeSeq.charAt(len - 1) == '%') {
                            CharSequence subPattern = likeSeq.subSequence(0, len - 1);
                            if (this.isCaseInsensitive()) {
                                if (Chars.isAscii(subPattern)) {
                                    return new ConstIStartsWithAsciiFunction(value, subPattern);
                                }
                                return new AbstractLikeStrFunctionFactory.ConstIStartsWithStrFunction(value, subPattern.toString());
                            }
                            return new ConstStartsWithVarcharFunction(value, subPattern);
                        }
                    } else if (anyCount == 2) {
                        if (len == 2) {
                            EqVarcharFunctionFactory.NullCheckFunc notNullFunc = new EqVarcharFunctionFactory.NullCheckFunc(value);
                            notNullFunc.setNegated();
                            return notNullFunc;
                        }
                        if (likeSeq.charAt(0) == '%' && likeSeq.charAt(len - 1) == '%') {
                            CharSequence subPattern = likeSeq.subSequence(1, len - 1);
                            if (this.isCaseInsensitive()) {
                                if (Chars.isAscii(subPattern)) {
                                    return new ConstIContainsAsciiFunction(value, subPattern);
                                }
                                return new AbstractLikeStrFunctionFactory.ConstIContainsStrFunction(value, subPattern.toString());
                            }
                            Utf8String u8subPattern = new Utf8String(subPattern);
                            if (u8subPattern.size() <= 8) {
                                return new ConstContainsSwarVarcharFunction(value, u8subPattern);
                            }
                            return new ConstContainsVarcharFunction(value, u8subPattern);
                        }
                    }
                }
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(likeSeq, null);
                assert (p != null);
                int flags = 32;
                if (this.isCaseInsensitive()) {
                    flags |= 2;
                    p = p.toLowerCase();
                }
                return new AbstractLikeStrFunctionFactory.ConstLikeStrFunction(value, Pattern.compile(p, flags).matcher(""));
            }
            return BooleanConstant.FALSE;
        }
        if (pattern.isRuntimeConstant()) {
            return new AbstractLikeStrFunctionFactory.BindLikeStrFunction(value, pattern, this.isCaseInsensitive());
        }
        throw SqlException.$(argPositions.getQuick(1), "use constant or bind variable");
    }

    protected abstract boolean isCaseInsensitive();

    private static class ConstIEndsWithAsciiFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Utf8String pattern;
        private final Function value;

        public ConstIEndsWithAsciiFunction(Function value, CharSequence pattern) {
            this.value = value;
            this.pattern = new Utf8String(pattern.toString().toLowerCase());
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.endsWithLowerCaseAscii(us, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
        }
    }

    private static class ConstEndsWithVarcharFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Utf8String pattern;
        private final Function value;

        public ConstEndsWithVarcharFunction(Function value, CharSequence pattern) {
            this.value = value;
            this.pattern = new Utf8String(pattern);
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.endsWith(us, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
        }
    }

    private static class ConstIStartsWithAsciiFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Utf8String pattern;
        private final Function value;

        public ConstIStartsWithAsciiFunction(Function value, CharSequence pattern) {
            this.value = value;
            this.pattern = new Utf8String(pattern.toString().toLowerCase());
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.startsWithLowerCaseAscii(us, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    private static class ConstStartsWithVarcharFunction
    extends StartsWithVarcharFunctionFactory.ConstFunc {
        ConstStartsWithVarcharFunction(Function value, CharSequence startsWith) {
            super(value, startsWith);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val(this.startsWith);
            sink.val('%');
        }
    }

    private static class ConstIContainsAsciiFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Utf8String pattern;
        private final Function value;

        public ConstIContainsAsciiFunction(Function value, CharSequence pattern) {
            this.value = value;
            this.pattern = new Utf8String(pattern.toString().toLowerCase());
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.containsLowerCaseAscii(us, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    private static class ConstContainsSwarVarcharFunction
    extends BooleanFunction
    implements UnaryFunction {
        private static final int MAX_SIZE = 8;
        private final Utf8Sequence pattern;
        private final long patternMask;
        private final int patternSize;
        private final long patternWord;
        private final byte searchFirstByte;
        private final long searchWord;
        private final Function value;

        public ConstContainsSwarVarcharFunction(Function value, Utf8Sequence pattern) {
            assert (pattern.size() > 0 && pattern.size() <= 8);
            this.value = value;
            this.patternSize = pattern.size();
            this.patternMask = this.patternSize == 8 ? -1L : (1L << 8 * pattern.size()) - 1L;
            long patternWord = 0L;
            int n = pattern.size();
            for (int i = 0; i < n; ++i) {
                patternWord |= (long)(pattern.byteAt(i) & 0xFF) << 8 * i;
            }
            this.patternWord = patternWord;
            this.searchFirstByte = pattern.byteAt(0);
            this.searchWord = SwarUtils.broadcast(pattern.byteAt(0));
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            int i;
            Utf8Sequence us = this.value.getVarcharA(rec);
            if (us == null || us.size() < this.patternSize) {
                return false;
            }
            int size = us.size();
            int n = size - 7 - this.patternSize + 1;
            for (i = 0; i < n; i += 8) {
                for (long zeroBytesWord = SwarUtils.markZeroBytes(us.longAt(i) ^ this.searchWord); zeroBytesWord != 0L; zeroBytesWord &= zeroBytesWord - 1L) {
                    int pos = SwarUtils.indexOfFirstMarkedByte(zeroBytesWord);
                    if (!(size - i - pos > 7 ? (us.longAt(i + pos) & this.patternMask) == this.patternWord : (this.tailWord(us, i + pos) & this.patternMask) == this.patternWord)) continue;
                    return true;
                }
            }
            n = size - this.patternSize + 1;
            while (i < n) {
                if (us.byteAt(i) == this.searchFirstByte && (this.tailWord(us, i) & this.patternMask) == this.patternWord) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
        }

        private long tailWord(Utf8Sequence us, int i) {
            long tailWord = 0L;
            for (int j = 0; j < this.patternSize; ++j) {
                tailWord |= ((long)us.byteAt(i + j) & 0xFFL) << 8 * j;
            }
            return tailWord;
        }
    }

    private static class ConstContainsVarcharFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Utf8String pattern;
        private final Function value;

        public ConstContainsVarcharFunction(Function value, Utf8String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.contains(us, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
        }
    }
}

