/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillNoneRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final RecordSink keyMapSink;
    private final Map map;
    private final RecordCursor mapCursor;
    private boolean hasNextPending;
    private boolean isMapBuildPending;
    private boolean isOpen;
    private long rowId;

    public SampleByFillNoneRecordCursor(CairoConfiguration configuration, Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(configuration, recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.record.of(map.getRecord());
        this.mapCursor = map.getCursor();
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.map.close();
            super.close();
            this.isOpen = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.initTimestamps();
        if (this.mapCursor.hasNext()) {
            return true;
        }
        if (this.baseRecord == null) {
            return false;
        }
        this.buildMap();
        return this.mapCursor.hasNext();
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        super.of(base, executionContext);
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
        this.rowId = 0L;
        this.hasNextPending = false;
        this.isMapBuildPending = true;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.rowId = 0L;
        this.hasNextPending = false;
        this.isMapBuildPending = true;
    }

    private void buildMap() {
        if (this.isMapBuildPending) {
            this.map.clear();
            this.sampleLocalEpoch = this.localEpoch;
            this.isMapBuildPending = false;
        }
        long next = this.timestampSampler.nextTimestamp(this.localEpoch);
        boolean baseHasNext = true;
        while (baseHasNext) {
            if (!this.hasNextPending) {
                long timestamp = this.getBaseRecordTimestamp();
                if (timestamp < next) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    this.adjustDstInFlight(timestamp - this.tzOffset);
                    MapKey key = this.map.withKey();
                    this.keyMapSink.copy(this.baseRecord, key);
                    MapValue value = key.createValue();
                    if (value.isNew()) {
                        this.groupByFunctionsUpdater.updateNew(value, this.baseRecord, this.rowId++);
                    } else {
                        this.groupByFunctionsUpdater.updateExisting(value, this.baseRecord, this.rowId++);
                    }
                } else if ((timestamp = this.adjustDst(timestamp, null, next)) != Long.MIN_VALUE) {
                    this.nextSamplePeriod(timestamp);
                    this.map.getCursor();
                    this.isMapBuildPending = true;
                    return;
                }
            }
            this.hasNextPending = true;
            baseHasNext = this.baseCursor.hasNext();
            this.hasNextPending = false;
        }
        this.baseRecord = null;
        this.map.getCursor();
        this.isMapBuildPending = true;
    }

    @Override
    protected void updateValueWhenClockMovesBack(MapValue value) {
        MapKey key = this.map.withKey();
        this.keyMapSink.copy(this.baseRecord, key);
        super.updateValueWhenClockMovesBack(key.createValue());
    }
}

