/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillPrevRecordCursor
extends AbstractVirtualRecordSampleByCursor
implements Reopenable {
    private final RecordSink keyMapSink;
    private final Map map;
    private final RecordCursor mapCursor;
    private boolean hasNextPending;
    private boolean isMapBuildPending;
    private boolean isMapInitialized;
    private boolean isOpen;
    private long rowId;

    public SampleByFillPrevRecordCursor(CairoConfiguration configuration, Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(configuration, recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.mapCursor = map.getCursor();
        this.record.of(map.getRecord());
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.map.close();
            super.close();
            this.isOpen = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.initializeMap();
        this.initTimestamps();
        if (this.mapCursor.hasNext()) {
            return true;
        }
        if (this.baseRecord == null) {
            return false;
        }
        this.buildMap();
        return this.map.getCursor().hasNext();
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        super.of(baseCursor, executionContext);
        this.rowId = 0L;
        this.hasNextPending = false;
        this.isMapBuildPending = true;
        this.isMapInitialized = false;
    }

    @Override
    public void reopen() {
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
    }

    @Override
    public void toTop() {
        super.toTop();
        this.map.clear();
        this.rowId = 0L;
        this.hasNextPending = false;
        this.isMapBuildPending = true;
        this.isMapInitialized = false;
    }

    private void buildMap() {
        block8: {
            long timestamp;
            if (this.isMapBuildPending) {
                long expectedLocalEpoch = this.timestampSampler.nextTimestamp(this.nextSampleLocalEpoch);
                if (expectedLocalEpoch < this.localEpoch) {
                    this.sampleLocalEpoch = expectedLocalEpoch;
                    this.nextSampleLocalEpoch = expectedLocalEpoch;
                    this.isMapBuildPending = true;
                    return;
                }
                this.sampleLocalEpoch = this.localEpoch;
                this.nextSampleLocalEpoch = this.localEpoch;
                this.isMapBuildPending = false;
            }
            long next = this.timestampSampler.nextTimestamp(this.localEpoch);
            while ((timestamp = this.getBaseRecordTimestamp()) < next) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                if (!this.hasNextPending) {
                    this.adjustDstInFlight(timestamp - this.tzOffset);
                    MapKey key = this.map.withKey();
                    this.keyMapSink.copy(this.baseRecord, key);
                    MapValue value = key.findValue();
                    assert (value != null);
                    if (value.getLong(0) != this.localEpoch) {
                        value.putLong(0, this.localEpoch);
                        this.groupByFunctionsUpdater.updateNew(value, this.baseRecord, this.rowId++);
                    } else {
                        this.groupByFunctionsUpdater.updateExisting(value, this.baseRecord, this.rowId++);
                    }
                }
                this.hasNextPending = true;
                boolean baseHasNext = this.baseCursor.hasNext();
                this.hasNextPending = false;
                if (baseHasNext) continue;
                this.baseRecord = null;
                break block8;
            }
            if ((timestamp = this.adjustDst(timestamp, null, next)) != Long.MIN_VALUE) {
                this.nextSamplePeriod(timestamp);
            }
        }
        this.isMapBuildPending = true;
    }

    private void initializeMap() {
        if (this.isMapInitialized) {
            return;
        }
        int n = this.groupByFunctions.size();
        while (this.baseCursor.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = this.map.withKey();
            this.keyMapSink.copy(this.baseRecord, key);
            MapValue value = key.createValue();
            if (!value.isNew()) continue;
            value.putLong(0, Long.MIN_VALUE);
            for (int i = 0; i < n; ++i) {
                ((GroupByFunction)this.groupByFunctions.getQuick(i)).setNull(value);
            }
        }
        this.baseCursor.toTop();
        this.isMapInitialized = true;
    }

    @Override
    protected void updateValueWhenClockMovesBack(MapValue value) {
        MapKey key = this.map.withKey();
        this.keyMapSink.copy(this.baseRecord, key);
        super.updateValueWhenClockMovesBack(key.createValue());
    }
}

