/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.DynamicLimitCursor;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.std.Misc;

public class LimitedSizePartiallySortedLightRecordCursor
implements DelegatingRecordCursor,
DynamicLimitCursor {
    private final LimitedSizeLongTreeChain chain;
    private final LimitedSizeLongTreeChain.TreeCursor chainCursor;
    private final RecordComparator comparator;
    private final int timestampIndex;
    private RecordCursor baseCursor;
    private Record baseRecord;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private long groupTimestamp;
    private boolean isChainBuilt;
    private boolean isOpen;
    private long limit;
    private long rowsInGroup;
    private long rowsLeft;
    private long rowsSoFar;
    private long skipFirst;
    private long skipLast;
    private boolean timestampInitialized;

    public LimitedSizePartiallySortedLightRecordCursor(LimitedSizeLongTreeChain chain, RecordComparator comparator, int timestampIndex) {
        this.chain = chain;
        this.comparator = comparator;
        this.chainCursor = chain.getCursor();
        this.isOpen = true;
        this.timestampIndex = timestampIndex;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.baseCursor = Misc.free(this.baseCursor);
            Misc.free(this.chain);
            this.isOpen = false;
        }
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public Record getRecordB() {
        return this.baseCursor.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.baseCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
        if (this.rowsLeft-- > 0L && this.chainCursor.hasNext()) {
            this.baseCursor.recordAt(this.baseRecord, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.baseCursor.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) {
        this.baseCursor = baseCursor;
        this.baseRecord = baseCursor.getRecord();
        if (!this.isOpen) {
            this.isOpen = true;
            this.chain.reopen();
        }
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isChainBuilt = false;
        this.rowsInGroup = 0L;
        this.rowsSoFar = 0L;
        this.groupTimestamp = Long.MIN_VALUE;
        this.timestampInitialized = false;
        this.chain.clear();
    }

    @Override
    public long preComputedStateSize() {
        return this.isChainBuilt ? 1L : 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.isChainBuilt ? Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L) : -1L;
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
        long skipLeft = this.skipFirst;
        while (skipLeft-- > 0L && this.chainCursor.hasNext()) {
            this.chainCursor.next();
        }
        this.rowsLeft = Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L);
    }

    @Override
    public void updateLimits(long limit, long skipFirst, long skipLast) {
        this.limit = limit;
        this.skipFirst = skipFirst;
        this.skipLast = skipLast;
    }

    private void buildChain() {
        Record placeHolderRecord = this.baseCursor.getRecordB();
        if (this.limit != 0L) {
            if (!this.timestampInitialized && this.baseCursor.hasNext()) {
                this.chain.put(this.baseRecord, this.baseCursor, placeHolderRecord, this.comparator);
                this.groupTimestamp = this.baseRecord.getTimestamp(this.timestampIndex);
                this.rowsInGroup = 1L;
                this.timestampInitialized = true;
            }
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                long currentTimestamp = this.baseRecord.getTimestamp(this.timestampIndex);
                if (this.groupTimestamp == currentTimestamp) {
                    ++this.rowsInGroup;
                } else {
                    this.rowsSoFar += this.rowsInGroup;
                    if (this.rowsSoFar > this.limit) break;
                    this.groupTimestamp = currentTimestamp;
                    this.rowsInGroup = 1L;
                }
                this.chain.put(this.baseRecord, this.baseCursor, placeHolderRecord, this.comparator);
            }
        }
        this.toTop();
    }
}

