/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDescendingRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesRecordCursor
extends AbstractDescendingRecordListCursor {
    private final int columnIndex;
    private final IntHashSet deferredSymbolKeys;
    private final IntIntHashMap map;
    private final IntHashSet symbolKeys;
    private boolean isMapPrepared;

    public LatestByValuesRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, DirectLongList rows, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys) {
        super(configuration, metadata, rows);
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
        this.map = new IntIntHashMap(Numbers.ceilPow2(symbolKeys.size()));
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.isMapPrepared = false;
        super.of(pageFrameCursor, executionContext);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan").meta("on").putColumnName(this.columnIndex);
    }

    private void prepareMap() {
        int i;
        int n;
        if (this.deferredSymbolKeys != null) {
            this.map.clear();
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                this.map.put(this.deferredSymbolKeys.get(i), 0);
            }
        }
        n = this.symbolKeys.size();
        for (i = 0; i < n; ++i) {
            this.map.put(this.symbolKeys.get(i), 0);
        }
    }

    @Override
    protected void buildTreeMap() {
        PageFrame frame;
        if (!this.isMapPrepared) {
            this.prepareMap();
            this.isMapPrepared = true;
        }
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = TableUtils.toIndexKey(this.recordA.getInt(this.columnIndex));
                int index = this.map.keyIndex(key);
                if (index >= 0 || this.map.valueAt(index) != 0) continue;
                this.rows.add(Rows.toRowID(frameIndex, row));
                this.map.putAt(index, key, 1);
            }
        }
    }
}

