/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.PageFrameBwdRowCursor;
import io.questdb.griffin.engine.table.PageFrameFwdRowCursor;

public class PageFrameRowCursorFactory
implements RowCursorFactory {
    private final int baseOrder;
    private PageFrameBwdRowCursor bwdCursor;
    private PageFrameFwdRowCursor fwdCursor;

    public PageFrameRowCursorFactory(int order) {
        this.baseOrder = order;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        if (this.baseOrder == 0 || this.baseOrder == 2) {
            if (this.fwdCursor == null) {
                this.fwdCursor = new PageFrameFwdRowCursor();
            }
            return this.fwdCursor.of(pageFrame);
        }
        if (this.bwdCursor == null) {
            this.bwdCursor = new PageFrameBwdRowCursor();
        }
        return this.bwdCursor.of(pageFrame);
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order = sink.getOrder();
        if (order == 2 || order < 0) {
            order = this.baseOrder;
        }
        if (order == 1) {
            sink.type("Row backward scan");
        } else {
            sink.type("Row forward scan");
        }
    }
}

