/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.Reopenable;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;

public class RowGroupBuffers
implements QuietCloseable,
Reopenable {
    private static final long CHUNKS_PTR_OFFSET;
    private static final long CHUNK_AUX_PTR_OFFSET;
    private static final long CHUNK_AUX_SIZE_OFFSET;
    private static final long CHUNK_DATA_PTR_OFFSET;
    private static final long CHUNK_DATA_SIZE_OFFSET;
    private static final long CHUNK_STRUCT_SIZE;
    private final int memoryTag;
    private long ptr;

    public RowGroupBuffers(int memoryTag) {
        this.memoryTag = memoryTag;
        this.ptr = RowGroupBuffers.create(Unsafe.getNativeAllocator(memoryTag));
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            RowGroupBuffers.destroy(this.ptr);
            this.ptr = 0L;
        }
    }

    public long getChunkAuxPtr(int columnIndex) {
        long chunksPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNKS_PTR_OFFSET);
        assert (chunksPtr != 0L);
        return Unsafe.getUnsafe().getLong(chunksPtr + (long)columnIndex * CHUNK_STRUCT_SIZE + CHUNK_AUX_PTR_OFFSET);
    }

    public long getChunkAuxSize(int columnIndex) {
        long chunksPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNKS_PTR_OFFSET);
        assert (chunksPtr != 0L);
        return Unsafe.getUnsafe().getLong(chunksPtr + (long)columnIndex * CHUNK_STRUCT_SIZE + CHUNK_AUX_SIZE_OFFSET);
    }

    public long getChunkDataPtr(int columnIndex) {
        long chunksPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNKS_PTR_OFFSET);
        assert (chunksPtr != 0L);
        return Unsafe.getUnsafe().getLong(chunksPtr + (long)columnIndex * CHUNK_STRUCT_SIZE + CHUNK_DATA_PTR_OFFSET);
    }

    public long getChunkDataSize(int columnIndex) {
        long chunksPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNKS_PTR_OFFSET);
        assert (chunksPtr != 0L);
        return Unsafe.getUnsafe().getLong(chunksPtr + (long)columnIndex * CHUNK_STRUCT_SIZE + CHUNK_DATA_SIZE_OFFSET);
    }

    public long ptr() {
        return this.ptr;
    }

    @Override
    public void reopen() {
        if (this.ptr == 0L) {
            this.ptr = RowGroupBuffers.create(Unsafe.getNativeAllocator(this.memoryTag));
        }
    }

    private static native long chunkAuxPtrOffset();

    private static native long chunkAuxSizeOffset();

    private static native long chunkDataPtrOffset();

    private static native long chunkDataSizeOffset();

    private static native long columnBuffersPtrOffset();

    private static native long columnChunkBuffersSize();

    private static native long create(long var0);

    private static native void destroy(long var0);

    static {
        Os.init();
        CHUNKS_PTR_OFFSET = RowGroupBuffers.columnBuffersPtrOffset();
        CHUNK_STRUCT_SIZE = RowGroupBuffers.columnChunkBuffersSize();
        CHUNK_DATA_PTR_OFFSET = RowGroupBuffers.chunkDataPtrOffset();
        CHUNK_DATA_SIZE_OFFSET = RowGroupBuffers.chunkDataSizeOffset();
        CHUNK_AUX_PTR_OFFSET = RowGroupBuffers.chunkAuxPtrOffset();
        CHUNK_AUX_SIZE_OFFSET = RowGroupBuffers.chunkAuxSizeOffset();
    }
}

