/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.LongGauge;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.str.BorrowableUtf8Sink;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

abstract class AbstractLongGauge
implements LongGauge {
    private final CharSequence name;

    AbstractLongGauge(CharSequence name) {
        this.name = name;
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    @Override
    public void scrapeIntoPrometheus(@NotNull BorrowableUtf8Sink sink) {
        this.appendType(sink);
        this.appendMetricName(sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.getValue());
        PrometheusFormatUtils.appendNewLine(sink);
    }

    private void appendMetricName(CharSink<?> sink) {
        sink.putAscii(PrometheusFormatUtils.METRIC_NAME_PREFIX);
        sink.put(this.name);
    }

    private void appendType(CharSink<?> sink) {
        sink.putAscii(PrometheusFormatUtils.TYPE_PREFIX);
        sink.put(this.name);
        sink.putAscii(" gauge\n");
    }
}

