/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class CompactIntHashSet
extends AbstractIntHashSet {
    public CompactIntHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.clear();
    }

    public boolean add(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, int key) {
        this.keys[index] = key;
        if (--this.free < 1) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        int[] oldKeys = this.keys;
        this.keys = new int[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            int key = oldKeys[i];
            if (key == this.noEntryKeyValue) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }
}

