/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Os;
import io.questdb.std.Unsafe;

public final class Vect {
    public static final int BIN_SEARCH_SCAN_DOWN = 1;
    public static final int BIN_SEARCH_SCAN_UP = -1;
    public static final byte DEDUP_INDEX_FORMAT = 1;
    public static final byte SHUFFLE_INDEX_FORMAT = 2;

    public static native double avgDoubleAcc(long var0, long var2, long var4);

    public static native double avgIntAcc(long var0, long var2, long var4);

    public static native double avgLongAcc(long var0, long var2, long var4);

    public static native double avgShortAcc(long var0, long var2, long var4);

    public static native long binarySearch64Bit(long var0, long var2, long var4, long var6, int var8);

    public static native long binarySearchIndexT(long var0, long var2, long var4, long var6, int var8);

    public static long boundedBinarySearch64Bit(long pData, long value, long low, long high, int scanDirection) {
        long index = Vect.binarySearch64Bit(pData, value, low, high, scanDirection);
        if (index < 0L) {
            return -index - 1L - (long)(scanDirection == -1 ? 0 : 1);
        }
        return index;
    }

    public static long boundedBinarySearchIndexT(long pData, long value, long low, long high, int scanDirection) {
        if (value < 0L) {
            return low - 1L;
        }
        long index = Vect.binarySearchIndexT(pData, value, low, high, scanDirection);
        if (index < 0L) {
            return -index - 1L - 1L;
        }
        return index;
    }

    public static native void copyFromTimestampIndex(long var0, long var2, long var4, long var6);

    public static native long countDouble(long var0, long var2);

    public static native long countInt(long var0, long var2);

    public static native long countLong(long var0, long var2);

    public static native long dedupMergeArrayColumnSize(long var0, long var2, long var4, long var6);

    public static native long dedupMergeStrBinColumnSize(long var0, long var2, long var4, long var6);

    public static native long dedupMergeVarcharColumnSize(long var0, long var2, long var4, long var6);

    public static native long dedupSortedTimestampIndex(long var0, long var2, long var4, long var6, int var8, long var9);

    public static long dedupSortedTimestampIndexIntKeysChecked(long inIndexAddr, long count, long outIndexAddr, long indexAddrTemp, int dedupColumnCount, long dedupColumnData) {
        long dedupCount = Vect.dedupSortedTimestampIndex(inIndexAddr, count, outIndexAddr, indexAddrTemp, dedupColumnCount, dedupColumnData);
        assert (dedupCount != -1L) : "unsorted data passed to deduplication";
        return dedupCount;
    }

    public static native long dedupSortedTimestampIndexManyAddresses(long var0, long var2, long var4, int var6, long var7);

    public static native void flattenIndex(long var0, long var2);

    public static native long getPerformanceCounter(int var0);

    public static native int getPerformanceCountersCount();

    public static native int getSupportedInstructionSet();

    public static String getSupportedInstructionSetName() {
        int inst = Vect.getSupportedInstructionSet();
        String base = inst >= 10 ? "AVX512" : (inst >= 8 ? "AVX2" : (inst >= 5 ? "SSE4.1" : (inst >= 2 ? "SSE2" : "Vanilla")));
        return " [" + base + "," + Vect.getSupportedInstructionSet() + "]";
    }

    public static native void indexReshuffle128Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle16Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle256Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle32Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle64Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle8Bit(long var0, long var2, long var4, long var6);

    public static boolean isIndexSuccess(long indexFormat) {
        long f = indexFormat >>> 56;
        return f > 0L && f < 4L;
    }

    public static native double maxDouble(long var0, long var2);

    public static native int maxInt(long var0, long var2);

    public static native long maxLong(long var0, long var2);

    public static native int maxShort(long var0, long var2);

    public static void memcpy(long dst, long src, long len) {
        if (len < 4096L) {
            Unsafe.getUnsafe().copyMemory(src, dst, len);
        } else {
            Vect.memcpy0(src, dst, len);
        }
    }

    public static boolean memeq(long a, long b, long len) {
        if (len < 128L) {
            return Vect.memeq0(a, b, len);
        }
        return Vect.memcmp(a, b, len) == 0;
    }

    public static native void memmove(long var0, long var2, long var4);

    public static native void memset(long var0, long var2, int var4);

    public static native long mergeDedupTimestampWithLongIndexAsc(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static native long mergeDedupTimestampWithLongIndexIntKeys(long var0, long var2, long var4, long var6, long var8, long var10, long var12, int var14, long var15);

    public static void mergeLongIndexesAsc(long pIndexStructArray, int count, long mergedIndexAddr) {
        if (count < 2) {
            throw new IllegalArgumentException("Count of indexes to merge should at least be 2.");
        }
        Vect.mergeLongIndexesAscInner(pIndexStructArray, count, mergedIndexAddr);
    }

    public static native void mergeShuffle128Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle16Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle256Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle32Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle64Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle8Bit(long var0, long var2, long var4, long var6, long var8);

    public static native long mergeShuffleArrayColumnFromManyAddresses(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static native long mergeShuffleFixedColumnFromManyAddresses(int var0, long var1, long var3, long var5, long var7, long var9, long var11);

    public static native long mergeShuffleStringColumnFromManyAddresses(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public static native long mergeShuffleSymbolColumnFromManyAddresses(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static native long mergeShuffleVarcharColumnFromManyAddresses(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static native long mergeTwoLongIndexesAsc(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native double minDouble(long var0, long var2);

    public static native int minInt(long var0, long var2);

    public static native long minLong(long var0, long var2);

    public static native int minShort(long var0, long var2);

    public static native void oooCopyIndex(long var0, long var2, long var4);

    public static native void oooMergeCopyArrayColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void oooMergeCopyBinColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void oooMergeCopyStrColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void oooMergeCopyVarcharColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void quickSortLongIndexAscInPlace(long var0, long var2);

    public static native long radixSortABLongIndexAsc(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static void radixSortLongIndexAscChecked(long pLongData, long count, long pCpy, long min, long max) {
        long resultCount = Vect.radixSortLongIndexAsc(pLongData, count, pCpy, min, max);
        assert (resultCount == count) : "radix sort error result =" + resultCount + ", expected=" + count;
    }

    public static native void radixSortLongIndexAscInPlace(long var0, long var2, long var4);

    public static native long radixSortManySegmentsIndexAsc(long var0, long var2, long var4, int var6, long var7, long var9, long var11, long var13, long var15, long var17, long var19, long var21, byte var23);

    public static long readIndexResultRowCount(long indexFormat) {
        return indexFormat & 0xFFFFFFFFFFFFL;
    }

    public static native long remapSymbolColumnFromManyAddresses(long var0, long var2, long var4, long var6, long var8);

    public static native void resetPerformanceCounters();

    public static native void setArrayColumnNullRefs(long var0, long var2, long var4);

    public static native void setBinaryColumnNullRefs(long var0, long var2, long var4);

    public static native void setMemoryDouble(long var0, double var2, long var4);

    public static native void setMemoryFloat(long var0, float var2, long var3);

    public static native void setMemoryInt(long var0, int var2, long var3);

    public static native void setMemoryLong(long var0, long var2, long var4);

    public static native void setMemoryShort(long var0, short var2, long var3);

    public static native void setStringColumnNullRefs(long var0, long var2, long var4);

    public static native void setVarcharColumnNullRefs(long var0, long var2, long var4);

    public static native void shiftCopyArrayColumnAux(long var0, long var2, long var4, long var6, long var8);

    public static native void shiftCopyFixedSizeColumnData(long var0, long var2, long var4, long var6, long var8);

    public static native void shiftCopyVarcharColumnAux(long var0, long var2, long var4, long var6, long var8);

    public static native long shiftTimestampIndex(long var0, long var2, long var4);

    public static native long shuffleSymbolColumnByReverseIndex(long var0, long var2, long var4, long var6);

    public static native void sort128BitAscInPlace(long var0, long var2);

    public static native void sort3LongAscInPlace(long var0, long var2);

    public static native long sortArrayColumn(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native void sortLongIndexAscInPlace(long var0, long var2);

    public static native long sortStringColumn(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native void sortULongAscInPlace(long var0, long var2);

    public static native long sortVarcharColumn(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native double sumDouble(long var0, long var2);

    public static native double sumDoubleKahan(long var0, long var2);

    public static native double sumDoubleNeumaier(long var0, long var2);

    public static native long sumInt(long var0, long var2);

    public static native long sumLong(long var0, long var2);

    public static native long sumShort(long var0, long var2);

    private static native int memcmp(long var0, long var2, long var4);

    private static native void memcpy0(long var0, long var2, long var4);

    private static boolean memeq0(long a, long b, long len) {
        long i = 0L;
        while (i + 7L < len) {
            if (Unsafe.getUnsafe().getLong(a + i) != Unsafe.getUnsafe().getLong(b + i)) {
                return false;
            }
            i += 8L;
        }
        if (i + 3L < len) {
            if (Unsafe.getUnsafe().getInt(a + i) != Unsafe.getUnsafe().getInt(b + i)) {
                return false;
            }
            i += 4L;
        }
        while (i < len) {
            if (Unsafe.getUnsafe().getByte(a + i) != Unsafe.getUnsafe().getByte(b + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static native void mergeLongIndexesAscInner(long var0, int var2, long var3);

    private static native long radixSortLongIndexAsc(long var0, long var2, long var4, long var6, long var8);

    static {
        Os.init();
    }
}

