/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.AfterQueryCallbackInvoker;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.ProxyConfig;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.QueriesExecutionContext;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ProxyEventType;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.spi.Result;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class ResultInvocationSubscriber
implements CoreSubscriber<Object>,
Subscription,
Scannable,
Fuseable.QueueSubscription<Object> {
    private static final AtomicIntegerFieldUpdater<ResultInvocationSubscriber> RESULT_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(ResultInvocationSubscriber.class, "resultCount");
    private final CoreSubscriber<Object> delegate;
    private final MutableQueryExecutionInfo executionInfo;
    private final ProxyExecutionListener listener;
    private final QueriesExecutionContext queriesExecutionContext;
    private final AfterQueryCallbackInvoker afterQueryCallbackInvoker;
    private volatile int resultCount;
    private Subscription subscription;

    public ResultInvocationSubscriber(CoreSubscriber<Object> delegate, MutableQueryExecutionInfo executionInfo, ProxyConfig proxyConfig, QueriesExecutionContext queriesExecutionContext) {
        this.delegate = delegate;
        this.executionInfo = executionInfo;
        this.listener = proxyConfig.getListeners();
        this.queriesExecutionContext = queriesExecutionContext;
        this.afterQueryCallbackInvoker = new AfterQueryCallbackInvoker(this.executionInfo, this.queriesExecutionContext, this.listener);
    }

    public Context currentContext() {
        return this.delegate.currentContext();
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.delegate.onSubscribe((Subscription)this);
    }

    public void onNext(Object mappedResult) {
        this.eachQueryResult(mappedResult, null);
        this.delegate.onNext(mappedResult);
    }

    public void onError(Throwable t) {
        this.eachQueryResult(null, t);
        this.queriesExecutionContext.incrementConsumedCount();
        if (this.queriesExecutionContext.isQueryFinished()) {
            this.afterQuery();
        }
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.queriesExecutionContext.incrementConsumedCount();
        if (this.queriesExecutionContext.isQueryFinished()) {
            this.afterQuery();
        }
        this.delegate.onComplete();
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.queriesExecutionContext.incrementConsumedCount();
        if (this.queriesExecutionContext.isQueryFinished()) {
            this.afterQuery();
        }
        this.subscription.cancel();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL) {
            return this.delegate;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        return null;
    }

    public int requestFusion(int requestedMode) {
        return 0;
    }

    public Result poll() {
        return null;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public void clear() {
    }

    private void afterQuery() {
        this.afterQueryCallbackInvoker.afterQuery();
    }

    private void eachQueryResult(@Nullable Object mappedResult, @Nullable Throwable throwable) {
        this.executionInfo.setProxyEventType(ProxyEventType.EACH_QUERY_RESULT);
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setCurrentResultCount(RESULT_COUNT_INCREMENTER.incrementAndGet(this));
        this.executionInfo.setCurrentMappedResult(mappedResult);
        if (throwable != null) {
            this.executionInfo.setThrowable(throwable);
            this.executionInfo.setSuccess(false);
        } else {
            this.executionInfo.setThrowable(null);
            this.executionInfo.setSuccess(true);
        }
        this.listener.eachQueryResult(this.executionInfo);
    }
}

