/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;

public class QueryCompilationSummaryHook
implements QueryLifeTimeHook {
    private static final String OPERATION_SUMMARY = "%-84s %9s";
    private static final String QUERY_COMPILATION_SUMMARY = "Query Compilation Summary";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String TOTAL_COMPILATION_TIME = "Total Compilation Time";
    private static final List<CompileStep> compileSteps = new ArrayList<CompileStep>();
    private static final String SEPARATOR = new String(new char[94]).replace("\u0000", "-");

    private String format(String value, long number) {
        return String.format(OPERATION_SUMMARY, value, number + "ms");
    }

    @Override
    public void beforeCompile(QueryLifeTimeHookContext ctx) {
    }

    @Override
    public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
        this.printCompileSummary();
    }

    @Override
    public void beforeExecution(QueryLifeTimeHookContext ctx) {
    }

    @Override
    public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
    }

    public void printCompileSummary() {
        StringBuilder compileSummary = new StringBuilder();
        compileSummary.append(QUERY_COMPILATION_SUMMARY);
        compileSummary.append(System.getProperty(LINE_SEPARATOR));
        compileSummary.append(SEPARATOR);
        compileSummary.append(System.getProperty(LINE_SEPARATOR));
        PerfLogger perfLogger = SessionState.getPerfLogger();
        this.appendCompileSteps(compileSummary, perfLogger, "", compileSteps);
        compileSummary.append(this.format(TOTAL_COMPILATION_TIME, perfLogger.getDuration("compile")));
        compileSummary.append(System.getProperty(LINE_SEPARATOR));
        compileSummary.append(SEPARATOR);
        SessionState.getConsole().printInfo(compileSummary.toString(), false);
    }

    public void appendCompileSteps(StringBuilder compileSummary, PerfLogger perfLogger, String prefix, List<CompileStep> currentLevelCompileSteps) {
        int counter = 1;
        for (CompileStep compileStep : currentLevelCompileSteps) {
            compileSummary.append(this.format("Compile Step - " + prefix + counter + " " + compileStep.name, perfLogger.getDuration(compileStep.name)));
            compileSummary.append(System.getProperty(LINE_SEPARATOR));
            this.appendCompileSteps(compileSummary, perfLogger, prefix + counter + ".", compileStep.getSubSteps());
            ++counter;
        }
    }

    static {
        compileSteps.add(new CompileStep("parse"));
        compileSteps.add(new CompileStep("Generate Resolved ParseTree"));
        CompileStep logicalPlanAndOpTree = new CompileStep("Logical Plan and hive Operator Tree");
        CompileStep logicalPlan = new CompileStep("Generate Logical Plan");
        logicalPlanAndOpTree.addSubStep(logicalPlan);
        logicalPlan.addSubStep(new CompileStep("Calcite: Plan generation"));
        logicalPlan.addSubStep(new CompileStep("MV Rewrite and Field Trimmer"));
        logicalPlan.addSubStep(new CompileStep("Removing SubQuery"));
        logicalPlan.addSubStep(new CompileStep("Decorrelation"));
        logicalPlan.addSubStep(new CompileStep("Validate Query Materialization"));
        logicalPlan.addSubStep(new CompileStep("Calcite: Prejoin ordering transformation"));
        logicalPlan.addSubStep(new CompileStep("MV Rewriting"));
        logicalPlan.addSubStep(new CompileStep("Calcite: Join Reordering"));
        logicalPlan.addSubStep(new CompileStep("Calcite: Postjoin ordering transformation"));
        logicalPlan.addSubStep(new CompileStep("Hive Sort Predicates"));
        logicalPlanAndOpTree.addSubStep(new CompileStep("Generate Operator Tree"));
        compileSteps.add(logicalPlanAndOpTree);
        compileSteps.add(new CompileStep("Deduce ResultsetSchema"));
        compileSteps.add(new CompileStep("Parse Context generation"));
        compileSteps.add(new CompileStep("Save and Validate View Creation"));
        compileSteps.add(new CompileStep("Logical Optimization"));
        compileSteps.add(new CompileStep("Physical Optimization"));
        compileSteps.add(new CompileStep("Post Processing"));
    }

    private static final class CompileStep {
        private final String name;
        private final List<CompileStep> subSteps;

        public CompileStep(String name) {
            this.name = name;
            this.subSteps = new ArrayList<CompileStep>();
        }

        public void addSubStep(CompileStep subStep) {
            this.subSteps.add(subStep);
        }

        public List<CompileStep> getSubSteps() {
            return this.subSteps;
        }
    }
}

