/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;

public class ResourceDeclaration {
    private final WorkerResourceSpec spec;
    private final int numNeeded;
    private final Collection<InstanceID> unwantedWorkers;

    public ResourceDeclaration(WorkerResourceSpec spec, int numNeeded, Collection<InstanceID> unwantedWorkers) {
        this.spec = spec;
        this.numNeeded = numNeeded;
        this.unwantedWorkers = Collections.unmodifiableCollection(unwantedWorkers);
    }

    public WorkerResourceSpec getSpec() {
        return this.spec;
    }

    public int getNumNeeded() {
        return this.numNeeded;
    }

    public Collection<InstanceID> getUnwantedWorkers() {
        return this.unwantedWorkers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDeclaration that = (ResourceDeclaration)o;
        return this.numNeeded == that.numNeeded && Objects.equals(this.spec, that.spec) && Objects.equals(this.unwantedWorkers, that.unwantedWorkers);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.numNeeded, this.unwantedWorkers);
    }

    public String toString() {
        return "ResourceDeclaration{spec=" + this.spec + ", numNeeded=" + this.numNeeded + ", unwantedWorkers=" + this.unwantedWorkers + '}';
    }
}

