/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.internal.ValidationUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CommonSettings {
    private String operationId;
    private String logComment;
    protected Map<String, Object> settings = new HashMap<String, Object>();

    public Object getOption(String option) {
        return this.settings.get(option);
    }

    public Object getOption(String option, Object defaultValue) {
        return this.settings.getOrDefault(option, defaultValue);
    }

    public boolean hasOption(String option) {
        return this.settings.containsKey(option);
    }

    public CommonSettings setOption(String option, Object value) {
        this.settings.put(option, value);
        if (option.equals(ClientConfigProperties.PRODUCT_NAME.getKey())) {
            this.settings.put(ClientConfigProperties.CLIENT_NAME.getKey(), value);
        }
        return this;
    }

    public CommonSettings resetOption(String option) {
        this.settings.remove(option);
        return this;
    }

    public Map<String, Object> getAllSettings() {
        return this.settings;
    }

    public String getQueryId() {
        return (String)this.settings.get(ClientConfigProperties.QUERY_ID.getKey());
    }

    public CommonSettings setQueryId(String queryId) {
        this.settings.put(ClientConfigProperties.QUERY_ID.getKey(), queryId);
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public CommonSettings setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public CommonSettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, ClientConfigProperties.DATABASE.getKey());
        this.settings.put(ClientConfigProperties.DATABASE.getKey(), database);
        return this;
    }

    public String getDatabase() {
        return (String)this.settings.get(ClientConfigProperties.DATABASE.getKey());
    }

    public CommonSettings httpHeader(String key, String value) {
        this.settings.put(ClientConfigProperties.httpHeader(key), value);
        return this;
    }

    public CommonSettings httpHeader(String key, Collection<String> values) {
        this.settings.put(ClientConfigProperties.httpHeader(key), ClientConfigProperties.commaSeparated(values));
        return this;
    }

    public CommonSettings httpHeaders(Map<String, String> headers) {
        headers.forEach(this::httpHeader);
        return this;
    }

    public CommonSettings serverSetting(String name, String value) {
        this.settings.put(ClientConfigProperties.serverSetting(name), value);
        return this;
    }

    public CommonSettings serverSetting(String name, Collection<String> values) {
        this.settings.put(ClientConfigProperties.serverSetting(name), ClientConfigProperties.commaSeparated(values));
        return this;
    }

    public CommonSettings setDBRoles(Collection<String> dbRoles) {
        this.settings.put(ClientConfigProperties.SESSION_DB_ROLES.getKey(), dbRoles);
        return this;
    }

    public Collection<String> getDBRoles() {
        return (Collection)this.settings.get(ClientConfigProperties.SESSION_DB_ROLES.getKey());
    }

    public CommonSettings logComment(String logComment) {
        this.logComment = logComment;
        if (logComment != null && !logComment.isEmpty()) {
            this.settings.put(ClientConfigProperties.SETTING_LOG_COMMENT.getKey(), logComment);
        }
        return this;
    }

    public String getLogComment() {
        return this.logComment;
    }

    public void setNetworkTimeout(long timeout, ChronoUnit unit) {
        this.settings.put(ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getKey(), Duration.of(timeout, unit).toMillis());
    }

    public Long getNetworkTimeout() {
        return (Long)this.getOption(ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getKey(), ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getDefaultValue());
    }

    public CommonSettings copyAndMerge(CommonSettings override) {
        CommonSettings copy = new CommonSettings();
        copy.settings.putAll(this.settings);
        copy.logComment = this.logComment;
        copy.settings.putAll(override.settings);
        return copy;
    }
}

