/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mysqlbulkloader;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mysqlbulkloader.MySqlBulkLoader;
import org.apache.hop.pipeline.transforms.mysqlbulkloader.MySqlBulkLoaderData;
import org.w3c.dom.Node;

@Transform(id="MySqlBulkLoader", image="mysqlbulkloader.svg", name="i18n::MySqlBulkLoader.Name", description="i18n::MySqlBulkLoader.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", keywords={"i18n::MySqlBulkLoader.keyword"}, documentationUrl="/pipeline/transforms/mysqlbulkloader.html", isIncludeJdbcDrivers=true, classLoaderGroup="mysql-db")
public class MySqlBulkLoaderMeta
extends BaseTransformMeta<MySqlBulkLoader, MySqlBulkLoaderData> {
    private static final Class<?> PKG = MySqlBulkLoaderMeta.class;
    public static final int FIELD_FORMAT_TYPE_OK = 0;
    public static final int FIELD_FORMAT_TYPE_DATE = 1;
    public static final int FIELD_FORMAT_TYPE_TIMESTAMP = 2;
    public static final int FIELD_FORMAT_TYPE_NUMBER = 3;
    public static final int FIELD_FORMAT_TYPE_STRING_ESCAPE = 4;
    private static final String[] fieldFormatTypeCodes = new String[]{"OK", "DATE", "TIMESTAMP", "NUMBER", "STRING_ESC"};
    private static final String[] fieldFormatTypeDescriptions = new String[]{BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.OK.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.Date.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.Timestamp.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.Number.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.FieldFormatType.StringEscape.Description", (String[])new String[0])};
    @HopMetadataProperty(key="schema")
    private String schemaName;
    @HopMetadataProperty(key="table")
    private String tableName;
    @HopMetadataProperty(key="fifo_file_name")
    private String fifoFileName;
    @HopMetadataProperty(key="connection")
    private String connection;
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<Field> fields;
    @HopMetadataProperty(key="encoding")
    private String encoding;
    @HopMetadataProperty(key="loadCharSet")
    private String loadCharSet;
    @HopMetadataProperty(key="replace")
    private boolean replacingData;
    @HopMetadataProperty(key="ignore")
    private boolean ignoringErrors;
    @HopMetadataProperty(key="local")
    private boolean localFile;
    @HopMetadataProperty(key="delimiter")
    private String delimiter;
    @HopMetadataProperty(key="enclosure")
    private String enclosure;
    @HopMetadataProperty(key="escape_char")
    private String escapeChar;
    @HopMetadataProperty(key="bulk_size")
    private String bulkSize;

    @Deprecated(since="2.13")
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        try {
            int nrvalues = XmlHandler.countNodes((Node)transformNode, (String)"mapping");
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)"mapping", (int)i);
                Field field = new Field();
                field.setFieldStream(XmlHandler.getTagValue((Node)vnode, (String)"field_name"));
                field.setFieldTable(XmlHandler.getTagValue((Node)vnode, (String)"stream_name"));
                field.setFieldFormatType(XmlHandler.getTagValue((Node)vnode, (String)"field_format_ok"));
                this.fields.add(field);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.Exception.UnableToReadTransformInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.connection = "";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.encoding = "UTF8";
        this.loadCharSet = "UTF8MB4";
        this.fifoFileName = "/tmp/fifo";
        this.delimiter = "\t";
        this.enclosure = "\"";
        this.escapeChar = "\\";
        this.replacingData = false;
        this.ignoringErrors = false;
        this.localFile = true;
        this.bulkSize = null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (this.connection != null) {
            DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
            try (Database db = new Database(loggingObject, variables, databaseMeta);){
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, variables.resolve(this.schemaName), variables.resolve(this.tableName));
                    IRowMeta r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (int i = 0; i < this.fields.size(); ++i) {
                            String field = this.fields.get(i).getFieldTable();
                            IValueMeta v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && !prev.isEmpty()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (int i = 0; i < this.fields.size(); ++i) {
                        IValueMeta v = prev.searchValueMeta(this.fields.get(i).getFieldStream());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + this.fields.get(i).getFieldStream() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block11: {
            DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
            retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
            if (databaseMeta != null) {
                if (prev != null && !prev.isEmpty()) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fields.size(); ++i) {
                        IValueMeta v = prev.searchValueMeta(this.fields.get(i).getFieldStream());
                        if (v == null) {
                            throw new HopTransformException("Unable to find field [" + this.fields.get(i).getFieldStream() + "] in the input rows");
                        }
                        IValueMeta tableField = v.clone();
                        tableField.setName(this.fields.get(i).getFieldStream());
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, variables, databaseMeta);
                        try {
                            String crTable;
                            db.connect();
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, variables.resolve(this.schemaName), variables.resolve(this.tableName));
                            String sql = crTable = db.getDDL(schemaTable, (IRowMeta)tableFields, null, false, null, true);
                            if (sql.isEmpty()) {
                                retval.setSql(null);
                                break block11;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (db.checkTableExists(realSchemaName, schemaTable)) {
                IRowMeta iRowMeta = db.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public static String[] getFieldFormatTypeDescriptions() {
        return fieldFormatTypeDescriptions;
    }

    public static String getFieldFormatTypeCode(int type) {
        return fieldFormatTypeCodes[type];
    }

    public static String getFieldFormatTypeDescription(int type) {
        return fieldFormatTypeDescriptions[type];
    }

    public static int getFieldFormatType(String codeOrDescription) {
        int i;
        for (i = 0; i < fieldFormatTypeCodes.length; ++i) {
            if (!fieldFormatTypeCodes[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        for (i = 0; i < fieldFormatTypeDescriptions.length; ++i) {
            if (!fieldFormatTypeDescriptions[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        return 0;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getFifoFileName() {
        return this.fifoFileName;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public List<Field> getFields() {
        return this.fields;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getLoadCharSet() {
        return this.loadCharSet;
    }

    @Generated
    public boolean isReplacingData() {
        return this.replacingData;
    }

    @Generated
    public boolean isIgnoringErrors() {
        return this.ignoringErrors;
    }

    @Generated
    public boolean isLocalFile() {
        return this.localFile;
    }

    @Generated
    public String getDelimiter() {
        return this.delimiter;
    }

    @Generated
    public String getEnclosure() {
        return this.enclosure;
    }

    @Generated
    public String getEscapeChar() {
        return this.escapeChar;
    }

    @Generated
    public String getBulkSize() {
        return this.bulkSize;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setFifoFileName(String fifoFileName) {
        this.fifoFileName = fifoFileName;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setLoadCharSet(String loadCharSet) {
        this.loadCharSet = loadCharSet;
    }

    @Generated
    public void setReplacingData(boolean replacingData) {
        this.replacingData = replacingData;
    }

    @Generated
    public void setIgnoringErrors(boolean ignoringErrors) {
        this.ignoringErrors = ignoringErrors;
    }

    @Generated
    public void setLocalFile(boolean localFile) {
        this.localFile = localFile;
    }

    @Generated
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Generated
    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    @Generated
    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Generated
    public void setBulkSize(String bulkSize) {
        this.bulkSize = bulkSize;
    }

    public static final class Field {
        @HopMetadataProperty(key="stream_name")
        private String fieldTable;
        @HopMetadataProperty(key="field_name")
        private String fieldStream;
        @HopMetadataProperty(key="field_format_ok")
        private String fieldFormatType;

        @Generated
        public String getFieldTable() {
            return this.fieldTable;
        }

        @Generated
        public String getFieldStream() {
            return this.fieldStream;
        }

        @Generated
        public String getFieldFormatType() {
            return this.fieldFormatType;
        }

        @Generated
        public void setFieldTable(String fieldTable) {
            this.fieldTable = fieldTable;
        }

        @Generated
        public void setFieldStream(String fieldStream) {
            this.fieldStream = fieldStream;
        }

        @Generated
        public void setFieldFormatType(String fieldFormatType) {
            this.fieldFormatType = fieldFormatType;
        }
    }
}

