/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.textfileoutput;

import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileField;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutput;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="TextFileOutput", image="textfileoutput.svg", name="i18n::TextFileOutput.Name", description="i18n::TextFileOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::TextFileOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/textfileoutput.html")
@InjectionSupported(localizationPrefix="TextFileOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class TextFileOutputMeta
extends BaseTransformMeta<TextFileOutput, TextFileOutputData> {
    private static final Class<?> PKG = TextFileOutputMeta.class;
    protected static final int FILE_COMPRESSION_TYPE_NONE = 0;
    protected static final int FILE_COMPRESSION_TYPE_ZIP = 1;
    protected static final String[] fileCompressionTypeCodes = new String[]{"None", "Zip"};
    public static final String[] formatMapperLineTerminator = new String[]{"DOS", "UNIX", "CR", "None"};
    public static final String CONST_FORMAT = "format";
    public static final String CONST_FIELD = "field";
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    @Injection(name="INC_TRANSFORMNR_IN_FILENAME")
    protected boolean transformNrInFilename;
    @Injection(name="INC_PARTNR_IN_FILENAME")
    protected boolean partNrInFilename;
    @Injection(name="INC_DATE_IN_FILENAME")
    protected boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    protected boolean timeInFilename;
    @Injection(name="EXTENSION")
    protected String extension;
    @Injection(name="FILENAME")
    protected String fileName;
    @Injection(name="RUN_AS_COMMAND")
    private boolean fileAsCommand;
    @Injection(name="SPECIFY_DATE_FORMAT")
    private boolean specifyingFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="COMPRESSION")
    private String fileCompression;
    @Injection(name="PASS_TO_SERVLET")
    private boolean servletOutput;
    @Injection(name="CREATE_PARENT_FOLDER")
    private boolean createparentfolder = true;
    @Injection(name="SEPARATOR")
    private String separator;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="FORCE_ENCLOSURE")
    private boolean enclosureForced;
    @Injection(name="DISABLE_ENCLOSURE_FIX")
    private boolean disableEnclosureFix;
    @Injection(name="HEADER")
    private boolean headerEnabled;
    @Injection(name="FOOTER")
    private boolean footerEnabled;
    private String fileFormat;
    @Injection(name="SPLIT_EVERY")
    private String splitEveryRows;
    @Injection(name="APPEND")
    private boolean fileAppended;
    @Injection(name="RIGHT_PAD_FIELDS")
    private boolean padded;
    @Injection(name="FAST_DATA_DUMP")
    private boolean fastDump;
    @InjectionDeep
    private TextFileField[] outputFields;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="ADD_ENDING_LINE")
    private String endedLine;
    @Injection(name="FILENAME_IN_FIELD")
    private boolean fileNameInField;
    @Injection(name="FILENAME_FIELD")
    private String fileNameField;
    @Injection(name="NEW_LINE")
    private String newline;
    @Injection(name="ADD_TO_RESULT")
    private boolean addToResultFilenames;
    @Injection(name="DO_NOT_CREATE_FILE_AT_STARTUP")
    private boolean doNotOpenNewFileInit;
    @Injection(name="SCHEMA_DEFINITION")
    private String schemaDefinition;
    @Injection(name="IGNORE_FIELDS")
    public boolean ignoreFields;

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public boolean isEnclosureFixDisabled() {
        return this.disableEnclosureFix;
    }

    public void setEnclosureFixDisabled(boolean disableEnclosureFix) {
        this.disableEnclosureFix = disableEnclosureFix;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    @Injection(name="FORMAT")
    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        this.newline = this.getNewLine(fileFormat);
    }

    @Deprecated(since="2.0")
    public int getSplitEvery() {
        return Const.toInt((String)this.splitEveryRows, (int)0);
    }

    public int getSplitEvery(IVariables varSpace) {
        return Const.toInt((String)(varSpace == null ? this.splitEveryRows : varSpace.resolve(this.splitEveryRows)), (int)0);
    }

    public int getFooterShift() {
        return this.isFooterEnabled() ? 1 : 0;
    }

    @Deprecated(since="2.0")
    public void setSplitEvery(int splitEvery) {
        this.splitEveryRows = Integer.toString(splitEvery);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrFields) {
        this.outputFields = new TextFileField[nrFields];
    }

    public Object clone() {
        TextFileOutputMeta retval = (TextFileOutputMeta)((Object)super.clone());
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (TextFileField)this.outputFields[i].clone();
        }
        return retval;
    }

    protected void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            if (this.separator == null) {
                this.separator = "";
            }
            this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            if (this.enclosure == null) {
                this.enclosure = "";
            }
            this.enclosureForced = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_forced"));
            String sDisableEnclosureFix = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_fix_disabled");
            this.disableEnclosureFix = sDisableEnclosureFix == null ? true : "Y".equalsIgnoreCase(sDisableEnclosureFix);
            String createParentFolderTagValue = XmlHandler.getTagValue((Node)transformNode, (String)"create_parent_folder");
            this.createparentfolder = createParentFolderTagValue == null ? true : "Y".equalsIgnoreCase(createParentFolderTagValue);
            this.headerEnabled = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"footer"));
            this.fileFormat = XmlHandler.getTagValue((Node)transformNode, (String)CONST_FORMAT);
            this.setFileCompression(XmlHandler.getTagValue((Node)transformNode, (String)"compression"));
            if (this.getFileCompression() == null) {
                if ("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"zipped"))) {
                    this.setFileCompression(fileCompressionTypeCodes[1]);
                } else {
                    this.setFileCompression(fileCompressionTypeCodes[0]);
                }
            }
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.schemaDefinition = XmlHandler.getTagValue((Node)transformNode, (String)"schema_definition");
            this.ignoreFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignore_fields"));
            this.endedLine = XmlHandler.getTagValue((Node)transformNode, (String)"endedLine");
            if (this.endedLine == null) {
                this.endedLine = "";
            }
            this.fileName = this.loadSource(transformNode, metadataProvider);
            this.servletOutput = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"servlet_output"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"do_not_open_new_file_init"));
            this.extension = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention"), (String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extension"));
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"append"));
            this.transformNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_time"));
            this.setSpecifyingFormat("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"SpecifyFormat")));
            this.setDateTimeFormat(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"date_time_format"));
            String addToResultFiles = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_to_result_filenames");
            this.addToResultFilenames = Utils.isEmpty((CharSequence)addToResultFiles) ? true : "Y".equalsIgnoreCase(addToResultFiles);
            this.padded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"pad"));
            this.fastDump = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"fast_dump"));
            this.splitEveryRows = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"splitevery");
            this.newline = this.getNewLine(this.fileFormat);
            this.fileNameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"fileNameInField"));
            this.fileNameField = XmlHandler.getTagValue((Node)transformNode, (String)"fileNameField");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)CONST_FORMAT));
                this.outputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                this.outputFields[i].setRoundingType(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"roundingType"), (String)"half_even"));
                this.outputFields[i].setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void readData(Node transformNode) throws HopXmlException {
        this.readData(transformNode, null);
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            } else if (fformat.equalsIgnoreCase("CR")) {
                nl = "\r";
            } else if (fformat.equalsIgnoreCase("None")) {
                nl = "";
            }
        }
        return nl;
    }

    public void setDefault() {
        this.createparentfolder = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.setSpecifyingFormat(false);
        this.setDateTimeFormat(null);
        this.enclosureForced = false;
        this.disableEnclosureFix = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileFormat = "DOS";
        this.setFileCompression(fileCompressionTypeCodes[0]);
        this.fileName = "";
        this.servletOutput = false;
        this.doNotOpenNewFileInit = true;
        this.extension = "";
        this.transformNrInFilename = false;
        this.partNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.padded = false;
        this.fastDump = false;
        this.addToResultFilenames = true;
        this.newline = this.getNewLine(this.fileFormat);
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName(CONST_FIELD + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
        this.fileAppended = false;
    }

    public String buildFilename(String filename, String extension, IVariables variables, int transformnr, String partnr, int splitnr, boolean beamContext, String transformId, int bundleNr, boolean ziparchive, TextFileOutputMeta meta) {
        String realFileName = variables.resolve(filename);
        String realExtension = variables.resolve(extension);
        return this.buildFilename(variables, realFileName, realExtension, Integer.toString(transformnr), partnr, Integer.toString(splitnr), beamContext, transformId, bundleNr, new Date(), ziparchive, true, meta);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            IValueMeta v = row.searchValueMeta(field.getName());
            if (v == null) continue;
            v.setLength(field.getLength());
            v.setPrecision(field.getPrecision());
            if (field.getFormat() != null) {
                v.setConversionMask(field.getFormat());
            }
            v.setDecimalSymbol(field.getDecimalSymbol());
            v.setGroupingSymbol(field.getGroupingSymbol());
            v.setCurrencySymbol(field.getCurrencySymbol());
            v.setOutputPaddingEnabled(this.isPadded());
            v.setTrimType(field.getTrimType());
            v.setRoundingType(field.getRoundingType());
            if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                v.setStringEncoding(this.getEncoding());
            }
            v.setOutputPaddingEnabled(true);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XmlHandler.addTagValue((String)"schema_definition", (String)this.schemaDefinition));
        retval.append("    ").append(XmlHandler.addTagValue((String)"ignore_fields", (boolean)this.ignoreFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_forced", (boolean)this.enclosureForced));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_fix_disabled", (boolean)this.disableEnclosureFix));
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XmlHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XmlHandler.addTagValue((String)CONST_FORMAT, (String)this.fileFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"compression", (String)this.getFileCompression()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"endedLine", (String)this.endedLine));
        retval.append("    " + XmlHandler.addTagValue((String)"fileNameInField", (boolean)this.fileNameInField));
        retval.append("    " + XmlHandler.addTagValue((String)"fileNameField", (String)this.fileNameField));
        retval.append("    " + XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    <file>").append(Const.CR);
        this.saveFileOptions(retval);
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            if (Utils.isEmpty((CharSequence)field.getName())) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)CONST_FORMAT, (String)field.getFormat()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"roundingType", (String)field.getRoundingType()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    protected void saveFileOptions(StringBuilder retval) {
        this.saveSource(retval, this.fileName);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"servlet_output", (boolean)this.servletOutput));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"do_not_open_new_file_init", (boolean)this.doNotOpenNewFileInit));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.isSpecifyingFormat()));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"date_time_format", (String)this.getDateTimeFormat()));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"pad", (boolean)this.padded));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"fast_dump", (boolean)this.fastDump));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"splitevery", (String)this.splitEveryRows));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.outputFields[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileNameInField && !Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName), (IVariables)variables);
                this.fileName = iResourceNaming.nameResource(fileObject, variables, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    protected String loadSource(Node transformNode, IHopMetadataProvider metadataProvider) {
        return XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
    }

    protected void saveSource(StringBuilder retVal, String value) {
        retVal.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fileName));
    }

    public boolean passDataToServletOutput() {
        return this.servletOutput;
    }

    public String[] getFiles(IVariables variables) {
        return this.getFiles(variables, true);
    }

    private String[] getFiles(IVariables variables, boolean showSamples) {
        String realFileName = variables.resolve(this.fileName);
        String realExtension = variables.resolve(this.extension);
        return this.getFiles(realFileName, realExtension, showSamples);
    }

    @VisibleForTesting
    String[] getFiles(String realFileName, String realExtension, boolean showSamples) {
        Date now = new Date();
        if (showSamples) {
            int nr;
            int copies = 1;
            int splits = 1;
            int parts = 1;
            if (this.isTransformNrInFilename()) {
                copies = 3;
            }
            if (this.isPartNrInFilename()) {
                parts = 3;
            }
            if (this.getSplitEvery() != 0) {
                splits = 3;
            }
            if ((nr = copies * parts * splits) > 1) {
                ++nr;
            }
            String[] retval = new String[nr];
            int i = 0;
            for (int transform = 0; transform < copies; ++transform) {
                for (int part = 0; part < parts; ++part) {
                    for (int split = 0; split < splits; ++split) {
                        retval[i] = this.buildFilename(realFileName, realExtension, "" + transform, this.getPartPrefix() + part, "" + split, false, "", 1, now, false, showSamples);
                        ++i;
                    }
                }
            }
            if (i < nr) {
                retval[i] = "...";
            }
            return retval;
        }
        return new String[]{this.buildFilename(realFileName, realExtension, "<transform>", "<partition>", "<split>", false, "", 1, now, false, showSamples)};
    }

    protected String getPartPrefix() {
        return "";
    }

    private String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, boolean beamContext, String transformId, int bundleNr, Date date, boolean ziparchive, boolean showSamples) {
        return this.buildFilename(realFileName, realExtension, transformnr, partnr, splitnr, beamContext, transformId, bundleNr, date, ziparchive, showSamples, this);
    }

    protected String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, boolean beamContext, String transformId, int bundleNr, Date date, boolean ziparchive, boolean showSamples, TextFileOutputMeta meta) {
        return this.buildFilename(null, realFileName, realExtension, transformnr, partnr, splitnr, beamContext, transformId, bundleNr, date, ziparchive, showSamples, meta);
    }

    protected String buildFilename(IVariables variables, String realFileName, String realExtension, String transformnr, String partnr, String splitnr, boolean beamContext, String transformId, int bundleNr, Date date, boolean ziparchive, boolean showSamples, TextFileOutputMeta meta) {
        Date now;
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = realFileName;
        if (meta.isFileAsCommand()) {
            return retval;
        }
        Date date2 = now = date == null ? new Date() : date;
        if (meta.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)meta.getDateTimeFormat())) {
            daf.applyPattern(meta.getDateTimeFormat());
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (meta.isDateInFilename()) {
                if (showSamples) {
                    daf.applyPattern("yyyMMdd");
                    String d = daf.format(now);
                    retval = (String)retval + "_" + d;
                } else {
                    retval = (String)retval + "_<yyyMMdd>";
                }
            }
            if (meta.isTimeInFilename()) {
                if (showSamples) {
                    daf.applyPattern("HHmmss");
                    String t = daf.format(now);
                    retval = (String)retval + "_" + t;
                } else {
                    retval = (String)retval + "_<HHmmss>";
                }
            }
        }
        if (meta.isTransformNrInFilename()) {
            retval = (String)retval + "_" + transformnr;
        }
        if (meta.isPartNrInFilename()) {
            retval = (String)retval + "_" + partnr;
        }
        if (meta.getSplitEvery(variables) > 0) {
            retval = (String)retval + "_" + splitnr;
        }
        if (beamContext) {
            retval = (String)retval + "_" + transformId + "_" + bundleNr;
        }
        if ("Zip".equals(meta.getFileCompression())) {
            if (ziparchive) {
                retval = (String)retval + ".zip";
            } else if (!Utils.isEmpty((CharSequence)realExtension)) {
                retval = (String)retval + "." + realExtension;
            }
        } else {
            if (!Utils.isEmpty((CharSequence)realExtension)) {
                retval = (String)retval + "." + realExtension;
            }
            if ("GZip".equals(meta.getFileCompression())) {
                retval = (String)retval + ".gz";
            }
        }
        return retval;
    }

    public String[] getFilePaths(IVariables variables, boolean showSamples) {
        PipelineMeta parentPipelineMeta;
        TransformMeta parentTransformMeta = this.getParentTransformMeta();
        if (parentTransformMeta != null && (parentPipelineMeta = parentTransformMeta.getParentPipelineMeta()) != null) {
            return this.getFiles(variables, showSamples);
        }
        return new String[0];
    }

    @Generated
    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    @Generated
    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    @Generated
    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    @Generated
    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public boolean isFileAsCommand() {
        return this.fileAsCommand;
    }

    @Generated
    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    @Generated
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Generated
    public String getFileCompression() {
        return this.fileCompression;
    }

    @Generated
    public boolean isServletOutput() {
        return this.servletOutput;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public String getEnclosure() {
        return this.enclosure;
    }

    @Generated
    public boolean isEnclosureForced() {
        return this.enclosureForced;
    }

    @Generated
    public boolean isDisableEnclosureFix() {
        return this.disableEnclosureFix;
    }

    @Generated
    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    @Generated
    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    @Generated
    public String getFileFormat() {
        return this.fileFormat;
    }

    @Generated
    public String getSplitEveryRows() {
        return this.splitEveryRows;
    }

    @Generated
    public boolean isFileAppended() {
        return this.fileAppended;
    }

    @Generated
    public boolean isPadded() {
        return this.padded;
    }

    @Generated
    public boolean isFastDump() {
        return this.fastDump;
    }

    @Generated
    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getEndedLine() {
        return this.endedLine;
    }

    @Generated
    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    @Generated
    public String getFileNameField() {
        return this.fileNameField;
    }

    @Generated
    public String getNewline() {
        return this.newline;
    }

    @Generated
    public boolean isAddToResultFilenames() {
        return this.addToResultFilenames;
    }

    @Generated
    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    @Generated
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @Generated
    public boolean isIgnoreFields() {
        return this.ignoreFields;
    }

    @Generated
    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    @Generated
    public void setPartNrInFilename(boolean partNrInFilename) {
        this.partNrInFilename = partNrInFilename;
    }

    @Generated
    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    @Generated
    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    @Generated
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setFileAsCommand(boolean fileAsCommand) {
        this.fileAsCommand = fileAsCommand;
    }

    @Generated
    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    @Generated
    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Generated
    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    @Generated
    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    @Generated
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Generated
    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    @Generated
    public void setEnclosureForced(boolean enclosureForced) {
        this.enclosureForced = enclosureForced;
    }

    @Generated
    public void setDisableEnclosureFix(boolean disableEnclosureFix) {
        this.disableEnclosureFix = disableEnclosureFix;
    }

    @Generated
    public void setHeaderEnabled(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
    }

    @Generated
    public void setFooterEnabled(boolean footerEnabled) {
        this.footerEnabled = footerEnabled;
    }

    @Generated
    public void setSplitEveryRows(String splitEveryRows) {
        this.splitEveryRows = splitEveryRows;
    }

    @Generated
    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    @Generated
    public void setPadded(boolean padded) {
        this.padded = padded;
    }

    @Generated
    public void setFastDump(boolean fastDump) {
        this.fastDump = fastDump;
    }

    @Generated
    public void setOutputFields(TextFileField[] outputFields) {
        this.outputFields = outputFields;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setEndedLine(String endedLine) {
        this.endedLine = endedLine;
    }

    @Generated
    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    @Generated
    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    @Generated
    public void setNewline(String newline) {
        this.newline = newline;
    }

    @Generated
    public void setAddToResultFilenames(boolean addToResultFilenames) {
        this.addToResultFilenames = addToResultFilenames;
    }

    @Generated
    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    @Generated
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    @Generated
    public void setIgnoreFields(boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
    }
}

