/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.variables.resolver.vault;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.response.LogicalResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.resolver.IVariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolverPlugin;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
@VariableResolverPlugin(id="Vault-Variable-Resolver", name="Hashicorp Vault Variable Resolver", description="Look up values of secrets in Hashicorp Vault", documentationUrl="/metadata-types/variable-resolver/hashicorp-vault-variable-resolver.html")
public class VaultVariableResolver
implements IVariableResolver {
    @GuiWidgetElement(id="vaultAddress", order="01", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.vaultAddress", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String vaultAddress;
    @GuiWidgetElement(id="vaultToken", order="02", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.vaultToken", type=GuiElementType.TEXT, password=true, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String vaultToken;
    @GuiWidgetElement(id="verifyingSsl", order="03", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.verifyingSsl", toolTip="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.tooltip.verifyingSsl", type=GuiElementType.CHECKBOX, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private boolean verifyingSsl;
    @GuiWidgetElement(id="pemFilePath", order="04", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.pemFilePath", type=GuiElementType.FILENAME, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String pemFilePath;
    @GuiWidgetElement(id="pemString", order="05", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.pemString", type=GuiElementType.TEXT, password=true, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String pemString;
    @GuiWidgetElement(id="openTimeout", order="06", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.openTimeout", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String openTimeout;
    @GuiWidgetElement(id="readTimeout", order="07", label="i18n:org.apache.hop.core.variables.resolver.vault:VaultVariableResolver.label.readTimeout", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String readTimeout;

    public String resolve(String secretPath, IVariables variables) throws HopException {
        try {
            int timeOut;
            int timeOut2;
            if (StringUtils.isEmpty((String)secretPath)) {
                return null;
            }
            String actualVaultToken = variables.resolve(this.vaultToken);
            String actualVaultAddress = variables.resolve(this.vaultAddress);
            VaultConfig vaultConfig = new VaultConfig();
            vaultConfig.address(actualVaultAddress);
            vaultConfig.token(actualVaultToken);
            vaultConfig.sslVerify(Boolean.valueOf(this.isVerifyingSsl()));
            String pemUtf8 = null;
            if (StringUtils.isNotEmpty((String)this.pemFilePath)) {
                try (InputStream is = HopVfs.getInputStream((String)variables.resolve(this.pemFilePath));){
                    pemUtf8 = this.readUtf8StringFromInputStream(is);
                }
            } else if (StringUtils.isNotEmpty((String)this.pemString)) {
                pemUtf8 = variables.resolve(this.pemString);
            }
            if (StringUtils.isNotEmpty(pemUtf8)) {
                vaultConfig.sslPemUTF8(pemUtf8);
            }
            if (StringUtils.isNotEmpty((String)this.openTimeout) && (timeOut2 = Const.toInt((String)variables.resolve(this.openTimeout), (int)-1)) >= 0) {
                vaultConfig.openTimeout(Integer.valueOf(timeOut2));
            }
            if (StringUtils.isNotEmpty((String)this.readTimeout) && (timeOut = Const.toInt((String)variables.resolve(this.readTimeout), (int)-1)) >= 0) {
                vaultConfig.readTimeout(Integer.valueOf(timeOut));
            }
            vaultConfig.build();
            Vault vault = new Vault(vaultConfig);
            LogicalResponse logicalResponse = vault.logical().read(secretPath);
            if (logicalResponse == null) {
                LogChannel.GENERAL.logDetailed("The secret with path '" + secretPath + "' was not found in the vault");
                return null;
            }
            return (String)logicalResponse.getData().get("data");
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error looking up secret '" + secretPath + "' in the Hashicorp Vault Variable resolver", (Throwable)e);
            return null;
        }
    }

    private String readUtf8StringFromInputStream(InputStream input) throws IOException {
        StringBuilder utf8 = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String string;
            while ((string = in.readLine()) != null) {
                utf8.append(string);
                utf8.append(Const.CR);
            }
        }
        return utf8.toString();
    }

    public void setPluginId() {
    }

    public void init() {
    }

    public String getPluginId() {
        return "Vault-Variable-Resolver";
    }

    public void setPluginName(String pluginName) {
    }

    public String getPluginName() {
        return "Hashicorp Vault Variable Resolver";
    }

    @Generated
    public String getVaultAddress() {
        return this.vaultAddress;
    }

    @Generated
    public String getVaultToken() {
        return this.vaultToken;
    }

    @Generated
    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    @Generated
    public String getPemFilePath() {
        return this.pemFilePath;
    }

    @Generated
    public String getPemString() {
        return this.pemString;
    }

    @Generated
    public String getOpenTimeout() {
        return this.openTimeout;
    }

    @Generated
    public String getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public void setVaultAddress(String vaultAddress) {
        this.vaultAddress = vaultAddress;
    }

    @Generated
    public void setVaultToken(String vaultToken) {
        this.vaultToken = vaultToken;
    }

    @Generated
    public void setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
    }

    @Generated
    public void setPemFilePath(String pemFilePath) {
        this.pemFilePath = pemFilePath;
    }

    @Generated
    public void setPemString(String pemString) {
        this.pemString = pemString;
    }

    @Generated
    public void setOpenTimeout(String openTimeout) {
        this.openTimeout = openTimeout;
    }

    @Generated
    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }
}

