/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.commons.lang3.ArrayUtils;

public class TableId {
    private final UUID id;

    private TableId(UUID id) {
        this.id = id;
    }

    public static TableId fromUUID(UUID id) {
        return new TableId(id);
    }

    public static TableId generate() {
        return new TableId(TimeUUID.Generator.nextTimeUUID().asUUID());
    }

    public static TableId fromString(String idString) {
        return new TableId(UUID.fromString(idString));
    }

    public static TableId forSystemTable(String keyspace, String table) {
        assert (SchemaConstants.isSystemKeyspace(keyspace)) : String.format("Table %s.%s is not a system table; only keyspaces allowed are %s", keyspace, table, SchemaConstants.getSystemKeyspaces());
        return TableId.unsafeDeterministic(keyspace, table);
    }

    public static TableId unsafeDeterministic(String keyspace, String table) {
        return new TableId(UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])keyspace.getBytes(StandardCharsets.UTF_8), (byte[])table.getBytes(StandardCharsets.UTF_8))));
    }

    public String toHexString() {
        return ByteBufferUtil.bytesToHex(ByteBufferUtil.bytes(this.id));
    }

    public UUID asUUID() {
        return this.id;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof TableId && this.id.equals(((TableId)o).id);
    }

    public String toString() {
        return this.id.toString();
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeLong(this.id.getMostSignificantBits());
        out.writeLong(this.id.getLeastSignificantBits());
    }

    public int serializedSize() {
        return 16;
    }

    public static TableId deserialize(DataInput in) throws IOException {
        return new TableId(new UUID(in.readLong(), in.readLong()));
    }
}

