/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.transforms.bigtable.BigtableSourceColumn;
import org.apache.hop.beam.transforms.bigtable.HopToBigtableFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigtableRowToHopRowFn
extends DoFn<Row, HopRow> {
    private final String counterName;
    private final String rowMetaJson;
    private final String keyField;
    private final String columnsJson;
    private transient List<BigtableSourceColumn> sourceColumns;
    private transient IRowMeta rowMeta;
    private transient Counter readCounter;
    private transient Counter outputCounter;
    private transient Counter errorCounter;
    private transient Map<String, Integer> qualifierTargetIndexes;
    private transient Map<String, BigtableSourceColumn> qualifierSourceColumns;
    private static final Logger LOG = LoggerFactory.getLogger(HopToBigtableFn.class);

    public BigtableRowToHopRowFn(String counterName, String rowMetaJson, String keyField, String columnsJson) {
        this.counterName = counterName;
        this.rowMetaJson = rowMetaJson;
        this.keyField = keyField;
        this.columnsJson = columnsJson;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            Counter initCounter = Metrics.counter((String)"init", (String)this.counterName);
            this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
            this.outputCounter = Metrics.counter((String)"output", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init();
            this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            int indexIncrement = 0;
            if (StringUtils.isNotEmpty((String)this.keyField)) {
                ++indexIncrement;
            }
            JSONParser parser = new JSONParser();
            JSONArray array = (JSONArray)parser.parse(this.columnsJson);
            this.sourceColumns = new ArrayList<BigtableSourceColumn>();
            this.qualifierTargetIndexes = new HashMap<String, Integer>();
            this.qualifierSourceColumns = new HashMap<String, BigtableSourceColumn>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jc = (JSONObject)array.get(i);
                String qualifier = (String)jc.get((Object)"qualifier");
                String targetType = (String)jc.get((Object)"target_type");
                String targetField = (String)jc.get((Object)"target_field_name");
                BigtableSourceColumn sourceColumn = new BigtableSourceColumn(qualifier, targetType, targetField);
                this.sourceColumns.add(sourceColumn);
                this.qualifierTargetIndexes.put(qualifier, i + indexIncrement);
                this.qualifierSourceColumns.put(qualifier, sourceColumn);
            }
            initCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Parse error on setup of Bigtable Row to HopRow function : " + e.getMessage());
            throw new RuntimeException("Error on setup of Bigtable Row to HopRow function function", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        Row inputRow = (Row)processContext.element();
        Map allFields = inputRow.getAllFields();
        this.readCounter.inc();
        try {
            int rowSize = this.rowMeta.size();
            Object[] row = new Object[rowSize];
            if (StringUtils.isNotEmpty((String)this.keyField)) {
                row[0] = inputRow.getKey().toStringUtf8();
            }
            for (Family family : inputRow.getFamiliesList()) {
                for (Column column : family.getColumnsList()) {
                    String qualifier = column.getQualifier().toStringUtf8();
                    Integer targetIndex = this.qualifierTargetIndexes.get(qualifier);
                    BigtableSourceColumn sourceColumn = this.qualifierSourceColumns.get(qualifier);
                    if (targetIndex == null) continue;
                    StringBuffer values = new StringBuffer();
                    for (Cell cell : column.getCellsList()) {
                        String value = cell.getValue().toStringUtf8();
                        if (!values.isEmpty()) {
                            values.append(',');
                        }
                        values.append(value);
                    }
                    IValueMeta targetValueMeta = sourceColumn.getValueMeta();
                    IValueMeta hopValueMeta = ValueMetaFactory.createValueMeta((String)"source", (int)2);
                    row[targetIndex.intValue()] = targetValueMeta.convertData(hopValueMeta, (Object)values.toString());
                }
            }
            HopRow hopRow = new HopRow(row);
            processContext.output((Object)hopRow);
            this.outputCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Conversion error Bigtable Row to HopRow: " + e.getMessage());
            throw new RuntimeException("Error converting Bigtable Row to HopRow: ", e);
        }
    }
}

