/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum GraphProtocol {
    GRAPHSON_1_0("graphson-1.0"),
    GRAPHSON_2_0("graphson-2.0"),
    GRAPH_BINARY_1_0("graph-binary-1.0");

    private static final Map<String, GraphProtocol> BY_CODE;
    private final String stringRepresentation;

    private GraphProtocol(String stringRepresentation) {
        this.stringRepresentation = stringRepresentation;
    }

    @NonNull
    public String toInternalCode() {
        return this.stringRepresentation;
    }

    @NonNull
    public static GraphProtocol fromString(@Nullable String stringRepresentation) {
        if (stringRepresentation == null || !BY_CODE.containsKey(stringRepresentation)) {
            StringBuilder sb = new StringBuilder(String.format("Graph protocol used [\"%s\"] unknown. Possible values are: [ \"%s\"", stringRepresentation, GraphProtocol.values()[0].toInternalCode()));
            for (int i = 1; i < GraphProtocol.values().length; ++i) {
                sb.append(String.format(", \"%s\"", GraphProtocol.values()[i].toInternalCode()));
            }
            sb.append("]");
            throw new IllegalArgumentException(sb.toString());
        }
        return BY_CODE.get(stringRepresentation);
    }

    public boolean isGraphBinary() {
        return this == GRAPH_BINARY_1_0;
    }

    static {
        HashMap<String, GraphProtocol> tmp = new HashMap<String, GraphProtocol>();
        for (GraphProtocol value : GraphProtocol.values()) {
            tmp.put(value.stringRepresentation, value);
        }
        BY_CODE = Collections.unmodifiableMap(tmp);
    }
}

